/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.util;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.TmsCommonConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LockCheckerUtil {
    private static final Logger log = LoggerFactory.getLogger(LockCheckerUtil.class);
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    TmsCommonConfig tmsConfig;

    public String isAnyLocked() {
        try {
            if (this.isDaemonLocked()) {
                return "MN LOCK. lockKey:lock.manager.stop." + this.tmsConfig.getEngine() + this.tmsConfig.getNode();
            }
        }
        catch (Exception e) {
            log.warn("{}", (Throwable)e);
        }
        try {
            if (this.isManagerAllLocked()) {
                return "ALL LOCK. lockKey:lock.manager.stop.all";
            }
        }
        catch (Exception e) {
            log.warn("{}", (Throwable)e);
        }
        return "";
    }

    public boolean isDaemonLocked() throws Exception {
        return this.wrapperRedisTemplate.hasKey("lock.manager.stop." + this.tmsConfig.getEngine() + this.tmsConfig.getNode());
    }

    public boolean isManagerAllLocked() throws Exception {
        return this.wrapperRedisTemplate.hasKey("lock.manager.stop.all");
    }

    public String isTrackingAnyLocked() {
        try {
            if (this.isTrackingDaemonLocked()) {
                return "TRACKING LOCK. lockKey:lock.tracking.stop." + this.tmsConfig.getEngine() + this.tmsConfig.getNode();
            }
        }
        catch (Exception e) {
            log.warn("{}", (Throwable)e);
        }
        try {
            if (this.isTrackingAllLocked()) {
                return "ALL TRACKING LOCK. lockKey:lock.tracking.stop.all";
            }
        }
        catch (Exception e) {
            log.warn("{}", (Throwable)e);
        }
        return "";
    }

    public boolean isTrackingDaemonLocked() throws Exception {
        return this.wrapperRedisTemplate.hasKey("lock.tracking.stop." + this.tmsConfig.getEngine() + this.tmsConfig.getNode());
    }

    public boolean isTrackingAllLocked() throws Exception {
        return this.wrapperRedisTemplate.hasKey("lock.tracking.stop.all");
    }
}

