/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule.stat;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.manager.batch.executor.StatInfoBatchExecutor;
import com.humuson.tms.manager.repository.dao.StatDao;
import com.humuson.tms.manager.repository.model.SchdInfoModel;
import com.humuson.tms.manager.util.LockCheckerUtil;
import com.humuson.tms.util.date.DateUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class StatSendListYnScheduler {
    private static final Logger log = LoggerFactory.getLogger(StatSendListYnScheduler.class);
    @Autowired
    private LockContexter contexter;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Value(value="${tms.manager.proc-stat.stat-use:N}")
    private String statUseFlag;
    @Value(value="${tms.manager.proc-stat.schd-limit:10}")
    private int schdLimit;
    @Value(value="${tms.manager.proc-stat.stat-limit-day:1}")
    private int statLimitDay;
    @Value(value="${tms.manager.proc-stat.stat-check-day:7}")
    private int schdCheckDay;
    @Autowired
    StatDao statDao;
    @Autowired
    @Qualifier(value="statInfoBatchExecutor")
    StatInfoBatchExecutor statInfoBatchExecutor;
    private List<SchdInfoModel> schdList;
    @Autowired
    LockCheckerUtil lockCheckerUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelayString="${tms.manager.proc-stat.interval:5000}")
    public void schedule() {
        String lockResult = this.lockCheckerUtil.isAnyLocked();
        if (lockResult != null && !lockResult.trim().isEmpty()) {
            log.info("[SCHEDULER] {}", (Object)lockResult);
            return;
        }
        if (!"Y".equals(this.statUseFlag)) {
            log.debug("[StatSendListYnScheduler] stat config is {}", (Object)this.statUseFlag);
            return;
        }
        String lockName = "lock.manager.scheduled.stat.has.sendlist.yn";
        LockController lockController = this.contexter.lock(lockName);
        try {
            if (this.wrapperRedisTemplate.hasKey(lockName)) {
                log.info("[SCHEDULER] This Schedule is already working lock[{}]", (Object)lockName);
                return;
            }
        }
        catch (Exception e1) {
            log.error("[SCHEDULER] lock check has an error. lock[{}], {}", (Object)lockName, (Object)e1);
            return;
        }
        lockController.lock();
        long start = System.currentTimeMillis();
        int threadIndex = 0;
        String startDate = DateUtil.getDateCalculationDay((String)"yyyyMMdd", (int)(-this.schdCheckDay));
        String endDate = DateUtil.getFullDate((String)"yyyyMMdd");
        long start1 = System.currentTimeMillis();
        this.schdList = this.statDao.selectCheckStatSendListN(startDate, endDate);
        long end1 = System.currentTimeMillis();
        log.info("[QUERY] startDate:{},endDate:{}, selectSendingSchdInfo size:{}=======[{}] seconds ", new Object[]{startDate, endDate, this.schdList.size(), (double)(end1 - start1) / 1000.0});
        if (this.schdList == null || this.schdList.size() == 0) {
            lockController.unLock();
            try {
                if (this.wrapperRedisTemplate.hasKey(lockName)) {
                    this.wrapperRedisTemplate.del(lockName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            long end = System.currentTimeMillis();
            log.info("[SCHEDULER] END worked:{} [{}] seconds", (Object)threadIndex, (Object)((double)(end - start) / 1000.0));
            return;
        }
        for (SchdInfoModel sim : this.schdList) {
            long size = 0L;
            long startCount = System.currentTimeMillis();
            try {
                size = this.statDao.countSendList(String.valueOf(sim.getSchdId()));
            }
            catch (Exception e) {
                try {
                    log.error("[ERROR] query valueOf, schdId:{}. error:{}", (Object)sim.getSchdId(), (Object)e);
                }
                catch (Throwable throwable) {
                    long end = System.currentTimeMillis();
                    log.debug("[QUERY] countSendList. schdId:{}, jobStatus:{}, size:{}=======[{}] seconds ", new Object[]{sim.getSendId(), sim.getSchdId(), size, (double)(end - startCount) / 1000.0});
                    throw throwable;
                }
                long end = System.currentTimeMillis();
                log.debug("[QUERY] countSendList. schdId:{}, jobStatus:{}, size:{}=======[{}] seconds ", new Object[]{sim.getSendId(), sim.getSchdId(), size, (double)(end - startCount) / 1000.0});
                continue;
            }
            long end = System.currentTimeMillis();
            log.debug("[QUERY] countSendList. schdId:{}, jobStatus:{}, size:{}=======[{}] seconds ", new Object[]{sim.getSendId(), sim.getSchdId(), size, (double)(end - startCount) / 1000.0});
            if (size == 0L) continue;
            long start2 = System.currentTimeMillis();
            try {
                int result = this.statDao.updateStatInfoHasSendListYn(String.valueOf(sim.getSendId()), String.valueOf(sim.getSchdId()));
                ++threadIndex;
            }
            catch (Exception e) {
                try {
                    log.error("[ERROR] query updateStatInfoHasSendListYn, sendId:{}, schdId:{}. error:{}", new Object[]{sim.getSendId(), sim.getSchdId(), e});
                }
                catch (Throwable throwable) {
                    long end2 = System.currentTimeMillis();
                    log.info("[QUERY] updateStatInfoHasSendListYn, sendId:{}, schdId:{} [{}] seconds", new Object[]{sim.getSendId(), sim.getSchdId(), (double)(end2 - start2) / 1000.0});
                    throw throwable;
                }
                long end2 = System.currentTimeMillis();
                log.info("[QUERY] updateStatInfoHasSendListYn, sendId:{}, schdId:{} [{}] seconds", new Object[]{sim.getSendId(), sim.getSchdId(), (double)(end2 - start2) / 1000.0});
                continue;
            }
            long end2 = System.currentTimeMillis();
            log.info("[QUERY] updateStatInfoHasSendListYn, sendId:{}, schdId:{} [{}] seconds", new Object[]{sim.getSendId(), sim.getSchdId(), (double)(end2 - start2) / 1000.0});
        }
        if (this.schdList != null) {
            this.schdList.clear();
        }
        lockController.unLock();
        try {
            if (this.wrapperRedisTemplate.hasKey(lockName)) {
                this.wrapperRedisTemplate.del(lockName);
            }
        }
        catch (Exception end) {
            // empty catch block
        }
        long end = System.currentTimeMillis();
        log.info("[SCHEDULER] END worked:{} [{}] seconds", (Object)threadIndex, (Object)((double)(end - start) / 1000.0));
    }
}

