/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule.stat;

import com.humuson.tms.manager.batch.executor.StatInfoBatchExecutor;
import com.humuson.tms.manager.repository.dao.StatDao;
import com.humuson.tms.manager.repository.model.SchdInfoModel;
import com.humuson.tms.manager.util.LockCheckerUtil;
import com.humuson.tms.manager.util.StatusCheckerUtil;
import com.humuson.tms.util.date.DateUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class StatInfoScheduler {
    private static final Logger log = LoggerFactory.getLogger(StatInfoScheduler.class);
    @Value(value="${tms.manager.proc-stat.stat-use:N}")
    private String statUseFlag;
    @Value(value="${tms.manager.proc-stat.schd-limit:10}")
    private int schdLimit;
    @Value(value="${tms.manager.proc-stat.stat-limit-day:1}")
    private int statLimitDay;
    @Value(value="${tms.manager.proc-stat.stat-check-day:7}")
    private int schdCheckDay;
    @Autowired
    StatusCheckerUtil statusCheckerUtil;
    @Autowired
    StatDao statDao;
    @Autowired
    @Qualifier(value="statInfoBatchExecutor")
    StatInfoBatchExecutor statInfoBatchExecutor;
    private List<SchdInfoModel> schdList;
    @Autowired
    LockCheckerUtil lockCheckerUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelayString="${tms.manager.proc-stat.interval:5000}")
    public void schedule() {
        String lockResult = this.lockCheckerUtil.isAnyLocked();
        if (lockResult != null && !lockResult.trim().isEmpty()) {
            log.info("[SCHEDULER] {}", (Object)lockResult);
            return;
        }
        if (!"Y".equals(this.statUseFlag)) {
            log.info("[StatInfoScheduler] stat config is {}", (Object)this.statUseFlag);
            return;
        }
        if (this.statusCheckerUtil.isAsyncThreadStocked(this.getClass().getSimpleName())) {
            return;
        }
        long start = System.currentTimeMillis();
        int threadIndex = 0;
        String startDate = DateUtil.getDateCalculationDay((String)"yyyyMMdd", (int)(-this.schdCheckDay));
        String endDate = DateUtil.getFullDate((String)"yyyyMMdd");
        long start1 = System.currentTimeMillis();
        this.schdList = this.statDao.selectSendingSchdInfo(startDate, endDate);
        long end1 = System.currentTimeMillis();
        log.info("[QUERY] startDate:{},endDate:{}, selectSendingSchdInfo size:{}=======[{}] seconds ", new Object[]{startDate, endDate, this.schdList.size(), (double)(end1 - start1) / 1000.0});
        if (this.schdList == null || this.schdList.size() == 0) {
            long end = System.currentTimeMillis();
            log.info("[SCHEDULER] END worked:{} [{}] seconds", (Object)threadIndex, (Object)((double)(end - start) / 1000.0));
            return;
        }
        for (SchdInfoModel sim : this.schdList) {
            if (threadIndex >= this.schdLimit) break;
            if (sim.getHasSendListYn().equalsIgnoreCase("N")) continue;
            if (this.statusCheckerUtil.isAsyncThreadStocked(this.getClass().getSimpleName())) {
                return;
            }
            long schdId = sim.getSchdId();
            String jobStatus = sim.getSchdJobStatus();
            long size = 0L;
            long startCount = System.currentTimeMillis();
            try {
                size = this.statDao.countSendList(String.valueOf(schdId));
            }
            catch (Exception e) {
                try {
                    log.error("[ERROR] query valueOf, sendId:{}, schdId:{}. error:{}", new Object[]{sim.getSendId(), sim.getSchdId(), e});
                }
                catch (Throwable throwable) {
                    long end = System.currentTimeMillis();
                    log.debug("[QUERY] countSendList. schdId:{}, jobStatus:{}, size:{}=======[{}] seconds ", new Object[]{schdId, jobStatus, size, (double)(end - startCount) / 1000.0});
                    throw throwable;
                }
                long end = System.currentTimeMillis();
                log.debug("[QUERY] countSendList. schdId:{}, jobStatus:{}, size:{}=======[{}] seconds ", new Object[]{schdId, jobStatus, size, (double)(end - startCount) / 1000.0});
                continue;
            }
            long end = System.currentTimeMillis();
            log.debug("[QUERY] countSendList. schdId:{}, jobStatus:{}, size:{}=======[{}] seconds ", new Object[]{schdId, jobStatus, size, (double)(end - startCount) / 1000.0});
            if (size == 0L) continue;
            threadIndex += this.statInfoBatchExecutor.executor(sim);
        }
        if (this.schdList != null) {
            this.schdList.clear();
        }
        long end = System.currentTimeMillis();
        log.info("[StatInfoScheduler][SCHEDULER] END worked:{} [{}] seconds", (Object)threadIndex, (Object)((double)(end - start) / 1000.0));
    }
}

