/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule.stat;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.Column;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.manager.repository.dao.StatDao;
import com.humuson.tms.manager.repository.model.SchdInfoModel;
import com.humuson.tms.manager.repository.model.StatSchdModel;
import com.humuson.tms.manager.stat.Stat;
import com.humuson.tms.manager.stat.StatBasicCommon;
import com.humuson.tms.manager.util.LockCheckerUtil;
import com.humuson.tms.util.date.DateUtil;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class ResultSchdInfoScheduler {
    private static final Logger log = LoggerFactory.getLogger(ResultSchdInfoScheduler.class);
    @Autowired
    private LockContexter contexter;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    StatDao statDao;
    @Autowired
    Stat statService;
    @Value(value="${tms.manager.proc-stat.stat-use:N}")
    private String statUseFlag;
    @Value(value="${tms.manager.proc-stat.schd-limit:10}")
    private int schdLimit;
    @Value(value="${tms.manager.proc-stat.stat-limit-day:1}")
    private int statLimitDay;
    @Value(value="${tms.manager.proc-stat.stat-check-day:7}")
    private int schdCheckDay;
    private List<StatSchdModel> statSchdList;
    private List<SchdInfoModel> schdList;
    @Autowired
    LockCheckerUtil lockCheckerUtil;

    @Scheduled(fixedDelayString="${tms.manager.proc-stat.interval}")
    public void schedule() {
        String lockResult = this.lockCheckerUtil.isAnyLocked();
        if (lockResult != null && !lockResult.trim().isEmpty()) {
            log.info("[SCHEDULER] {}", (Object)lockResult);
            return;
        }
        if (!"Y".equals(this.statUseFlag)) {
            log.debug("[ResultSchdInfoScheduler] stat config is {}", (Object)this.statUseFlag);
            return;
        }
        String startDate = DateUtil.getDateCalculationDay((String)"yyyyMMdd", (int)(-this.schdCheckDay));
        String endDate = DateUtil.getFullDate((String)"yyyyMMdd");
        long start = System.currentTimeMillis();
        this.statSchdList = this.statDao.selectStatSchdule();
        long end = System.currentTimeMillis();
        log.info("[QUERY] START selectStatSchdule size:{} =======[{}] seconds", (Object)this.statSchdList.size(), (Object)((double)(end - start) / 1000.0));
        if (this.statSchdList == null || this.statSchdList.size() == 0) {
            end = System.currentTimeMillis();
            log.info("[SCHEDULER] END. count:{},  [{}] seconds", (Object)this.statSchdList.size(), (Object)((double)(end - start) / 1000.0));
            return;
        }
        try {
            for (StatSchdModel statSchdModel : this.statSchdList) {
                long sendId = statSchdModel.getSendId();
                this.doResultingSchdInfo(startDate, endDate, sendId, statSchdModel.getJobStatus());
            }
            if (this.schdList != null) {
                this.schdList.clear();
            }
        }
        catch (Exception e) {
            log.error("ERROR: {}", (Throwable)e);
        }
        end = System.currentTimeMillis();
        log.info("[SCHEDULER] END. count:{},  [{}] seconds", (Object)this.statSchdList.size(), (Object)((double)(end - start) / 1000.0));
        if (this.statSchdList != null) {
            this.statSchdList.clear();
        }
    }

    public void doResultingSchdInfo(String startDate, String endDate, long sendId, String sendJobStatus) {
        boolean isSendInfoStoped = this.checkIfDeliveryIsStopped(sendJobStatus);
        long start1 = System.currentTimeMillis();
        this.schdList = this.statDao.selectSchdInfo(null, startDate, endDate, sendId);
        long end1 = System.currentTimeMillis();
        if (this.schdList.size() > 0) {
            log.debug("[QUERY] START startDate:{},endDate:{},SenId:{}, selectSchdInfo size:{}=======[{}] seconds ", new Object[]{startDate, endDate, sendId, this.schdList.size(), (double)(end1 - start1) / 1000.0});
        }
        long schdId = 0L;
        for (SchdInfoModel sim : this.schdList) {
            schdId = sim.getSchdId();
            try {
                String totalCnt;
                long redisTargetCnt = -1L;
                long pushedCnt = -1L;
                String redisPinfoKey = "PINFO:" + schdId;
                if (this.wrapperRedisTemplate.hasHMKey(redisPinfoKey, Column.PINFO_COUNT_TARGET) && (totalCnt = this.wrapperRedisTemplate.hmget(redisPinfoKey, Column.PINFO_COUNT_TARGET)) != null && !totalCnt.trim().isEmpty() && (long)sim.getTargetCnt() != redisTargetCnt) {
                    redisTargetCnt = Long.valueOf(totalCnt);
                }
                if ((long)sim.getTargetCnt() != sim.getCtTargetCnt() && redisTargetCnt == -1L) {
                    redisTargetCnt = sim.getCtTargetCnt();
                } else if (redisTargetCnt == sim.getCtTargetCnt() && redisTargetCnt == (long)sim.getTargetCnt()) {
                    redisTargetCnt = -1L;
                }
                if ((long)sim.getPushedCnt() != sim.getMpPushedCnt()) {
                    pushedCnt = sim.getMpPushedCnt();
                }
                this.updateStatTargetCntTable(sim, redisTargetCnt, pushedCnt);
                boolean isSendRequested = this.statService.checkSendRequestCnt(sim);
                boolean isSendComplete = this.statService.checkSendCompleteCnt(sim);
                boolean isTrackingEnd = this.statService.checkTrackingEndToNow(sim.getChannelType(), sim);
                boolean isTimeOut = this.statService.checkTimeOut(sim);
                boolean isReulstProcess = this.checkIfRedsultProcess(sim);
                boolean isCtBeforeCancle = this.statService.isCtBeforeCancled(sim);
                String moniteStatus = this.statService.checkIfMoniteStatusIsFailOrStopped(sim);
                StatBasicCommon targetStat = new StatBasicCommon();
                targetStat.setSendId(sim.getSendId());
                targetStat.setSchdId(sim.getSchdId());
                targetStat.setTestId(sim.getTestId());
                targetStat.setResendId(sim.getResendId());
                targetStat.setJobStatus(sim.getJobStatus());
                targetStat.setSendComplete(isSendComplete);
                targetStat.setRequestSendComplete(isSendRequested);
                targetStat.setTrackingEnd(isTrackingEnd);
                targetStat.setTimeOut(isTimeOut);
                targetStat.setStoped(isSendInfoStoped);
                targetStat.setReulstProcess(isReulstProcess);
                targetStat.setCtBeforeCancle(isCtBeforeCancle);
                targetStat.setMoniteStatus(moniteStatus);
                this.statService.applyStatus(targetStat, sim);
            }
            catch (Exception e) {
                log.error("Error : {}", (Throwable)e);
            }
        }
    }

    private boolean checkIfDeliveryIsStopped(String schdJobStatus) {
        return schdJobStatus.equals("32");
    }

    private boolean checkIfRedsultProcess(SchdInfoModel schdInfoModel) {
        return schdInfoModel.getHasSendListYn().equalsIgnoreCase("Y");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void updateStatTargetCntTable(SchdInfoModel sim, long targetCnt, long pushedCnt) {
        long sendId = sim.getSendId();
        long schdId = sim.getSchdId();
        if (targetCnt == -1L && pushedCnt == -1L) {
            return;
        }
        HashMap<String, Long> statMap = new HashMap<String, Long>();
        if (targetCnt != -1L && (long)sim.getTargetCnt() != targetCnt) {
            statMap.put(Column.TARGET_CNT, targetCnt);
        }
        if (pushedCnt != -1L && (long)sim.getPushedCnt() != pushedCnt) {
            statMap.put(Column.PUSHED_CNT, pushedCnt);
        }
        if (statMap.containsKey(Column.TARGET_CNT) || statMap.containsKey(Column.PUSHED_CNT)) {
            statMap.put(Column.SEND_ID, sendId);
            statMap.put(Column.SCHD_ID, schdId);
        }
        if (statMap == null || statMap.size() == 0) {
            return;
        }
        long start = System.currentTimeMillis();
        try {
            this.statDao.updateStatInfo(statMap);
        }
        catch (DuplicateKeyException dupEx) {
            this.statDao.updateStatInfo(statMap);
            long end = System.currentTimeMillis();
            log.info("[QUERY] updateStatInfo sendId:{}, schdId:{}, data:{}  END ============[{}] seconds", new Object[]{sendId, schdId, ((Object)statMap).toString(), (double)(end - start) / 1000.0});
            if (statMap != null) {
                statMap.clear();
            }
        }
        catch (Exception e) {
            log.error("[QUERY] ERROR updateStatInfo Error :sendId:{}, schdId:{}, error:{}", new Object[]{sendId, schdId, e});
            {
                catch (Throwable throwable) {
                    long end = System.currentTimeMillis();
                    log.info("[QUERY] updateStatInfo sendId:{}, schdId:{}, data:{}  END ============[{}] seconds", new Object[]{sendId, schdId, ((Object)statMap).toString(), (double)(end - start) / 1000.0});
                    if (statMap != null) {
                        statMap.clear();
                    }
                    throw throwable;
                }
            }
            long end = System.currentTimeMillis();
            log.info("[QUERY] updateStatInfo sendId:{}, schdId:{}, data:{}  END ============[{}] seconds", new Object[]{sendId, schdId, ((Object)statMap).toString(), (double)(end - start) / 1000.0});
            if (statMap != null) {
                statMap.clear();
            }
        }
        long end = System.currentTimeMillis();
        log.info("[QUERY] updateStatInfo sendId:{}, schdId:{}, data:{}  END ============[{}] seconds", new Object[]{sendId, schdId, ((Object)statMap).toString(), (double)(end - start) / 1000.0});
        if (statMap != null) {
            statMap.clear();
        }
    }
}

