/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule.stat;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.manager.repository.dao.SendDao;
import com.humuson.tms.manager.repository.model.ResultSendInfoModel;
import com.humuson.tms.manager.schedule.stat.ResultSchdInfoScheduler;
import com.humuson.tms.manager.send.SendBasicService;
import com.humuson.tms.manager.util.LockCheckerUtil;
import com.humuson.tms.util.date.DateUtil;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="tms.manager.proc-send", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class CancledSendInfoScheduler {
    private static final Logger log = LoggerFactory.getLogger(CancledSendInfoScheduler.class);
    @Autowired
    ResultSchdInfoScheduler resultSchdInfoScheduler;
    @Autowired
    private LockContexter contexter;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    SendDao sendDao;
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    SendBasicService sendBasicService;
    @Autowired
    LockCheckerUtil lockCheckerUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Scheduled(fixedDelayString="${tms.manager.proc-send.interval}")
    public void schedule() {
        lockResult = this.lockCheckerUtil.isAnyLocked();
        if (lockResult != null && !lockResult.trim().isEmpty()) {
            CancledSendInfoScheduler.log.info("[SCHEDULER] {}", (Object)lockResult);
            return;
        }
        start = System.currentTimeMillis();
        workingCount = 0;
        sendList = this.sendDao.selectTargetCancledSendList();
        end = System.currentTimeMillis();
        CancledSendInfoScheduler.log.info("[QUERY] selectTargetSendList size:{} ============[{}] seconds", (Object)sendList.size(), (Object)((double)(end - start) / 1000.0));
        if (sendList == null || sendList.size() == 0) {
            end = System.currentTimeMillis();
            CancledSendInfoScheduler.log.info("[SCHEDULER] END worked:{}, [{}] seconds", (Object)workingCount, (Object)((double)(end - start) / 1000.0));
            return;
        }
        currentSendStatus = null;
lbl15:
        // 15 sources

        block16: for (ResultSendInfoModel rsm : sendList) {
            sendId = rsm.getSendId();
            lockName = "lock.manager.result.cancled.send.info.." + sendId;
            lockController = this.contexter.lock(lockName);
            try {
                if (lockController.isLocked()) {
                    CancledSendInfoScheduler.log.info("[SCHEDULER] This SEND_ID({}) is already working lock[{}]", (Object)sendId, (Object)lockName);
                    continue;
                }
                lockController.lock();
                currentSendStatus = rsm.getCurrentStatus();
                totalSchdCnt = rsm.getSchdTotalCnt();
                sending30SchdCnt = rsm.getSchd30Cnt();
                resulting38Cnt = rsm.getSchd38Cnt();
                end40Cnt = rsm.getSchd40Cnt();
                fail41Cnt = rsm.getSchd41Cnt();
                cancel42Cnt = rsm.getSchd42Cnt();
                trackingEnd43Cnt = rsm.getSchd43Cnt();
                workingCnt = sending30SchdCnt + resulting38Cnt;
                resultCnt = end40Cnt + fail41Cnt + trackingEnd43Cnt + cancel42Cnt;
                processCnt = totalSchdCnt - resultCnt;
                var25_23 = currentSendStatus;
                var26_24 = -1;
                switch (var25_23.hashCode()) {
                    case 1630: {
                        if (!var25_23.equals("31")) break;
                        var26_24 = 0;
                        break;
                    }
                    case 1631: {
                        if (!var25_23.equals("32")) break;
                        var26_24 = 1;
                    }
                }
                switch (var26_24) {
                    case 0: {
                        CancledSendInfoScheduler.log.info("## cancle ## processCnt ::{}, sendId :: {}, 31status", (Object)processCnt, (Object)sendId);
                        if (processCnt <= 0 && this.isCanceled(rsm)) {
                            this.updateSendInfo(rsm, "42", "all Schedule cancled.");
                            CancledSendInfoScheduler.log.info("## cancle ## processCnt <= 0  31 >42status ");
                            ** break;
                        }
                        try {
                            this.wrapperRedisTemplate.hmset("PCNCL", String.valueOf(sendId), String.valueOf(sendId));
                        }
                        catch (Exception e) {
                            CancledSendInfoScheduler.log.error("redis fail set this SendId : {} stop Error!", (Object)sendId);
                        }
                        this.updateSendInfo(rsm, "32", "UPLOADED PCNCL:" + sendId);
                        CancledSendInfoScheduler.log.info("## cancle ## else 31> 32 status");
                        ++workingCount;
                        ** break;
                    }
                    case 1: {
                        CancledSendInfoScheduler.log.info("## cancle ## processCnt ::{}, sendId :: {}, 31status", (Object)processCnt, (Object)sendId);
                        if (processCnt <= 0 && this.isCanceled(rsm) && workingCnt == 0) {
                            if (this.wrapperRedisTemplate.hasHMKey("PCNCL", String.valueOf(sendId))) {
                                this.wrapperRedisTemplate.hmdel("PCNCL", String.valueOf(sendId));
                            }
                            this.updateSendInfo(rsm, "42", "all Schedule cancled.");
                            CancledSendInfoScheduler.log.info("## cancle ## processCnt <= 0  32 >42status ");
                            ++workingCount;
                            ** break;
                        }
                        CancledSendInfoScheduler.log.info("## cancle ## else  32 >42status ");
                        if (processCnt > 0) {
                            start30Date = rsm.getSchd30MinRegDate();
                            start38Date = rsm.getSchd38MinRegDate();
                            endDate = DateUtil.getFullDate((String)"yyyyMMdd");
                            if (Integer.valueOf(endDate) - Integer.valueOf(start30Date) > 7) {
                                CancledSendInfoScheduler.log.info("sendId:{} has overed schdInfo by jobStatus:30. (minimunWorkday:{}) do start resultSchdInfo.", (Object)sendId, (Object)start30Date);
                                this.resultSchdInfoScheduler.doResultingSchdInfo(start30Date, endDate, sendId, currentSendStatus);
                                CancledSendInfoScheduler.log.info("## cancle ## start30Date:{} ", (Object)start30Date);
                                ** break;
                            }
                            if (Integer.valueOf(endDate) - Integer.valueOf(start38Date) <= 7) continue block16;
                            CancledSendInfoScheduler.log.info("sendId:{} has overed schdInfo by jobStatus:38. (minimunWorkday:{}) do start resultSchdInfo.", (Object)sendId, (Object)start38Date);
                            this.resultSchdInfoScheduler.doResultingSchdInfo(start38Date, endDate, sendId, currentSendStatus);
                            CancledSendInfoScheduler.log.info("## cancle ## start38Date:{} ", (Object)start38Date);
                            ** break;
                        }
                        if (totalSchdCnt - resultCnt - workingCnt <= 0) ** break;
                        startMinDate = rsm.getMinRegDate();
                        endDate = DateUtil.getFullDate((String)"yyyyMMdd");
                        if (Integer.valueOf(endDate) - Integer.valueOf(startMinDate) <= 7) ** break;
                        CancledSendInfoScheduler.log.info("sendId:{} has overed schdInfo. (minimunWorkday:{}) do start resultSchdInfo.", (Object)sendId, (Object)startMinDate);
                        this.resultSchdInfoScheduler.doResultingSchdInfo(startMinDate, endDate, sendId, currentSendStatus);
                        continue block16;
                    }
                    ** default:
lbl96:
                    // 1 sources

                    continue block16;
                }
            }
            catch (Exception e) {
                CancledSendInfoScheduler.log.error("sendId:{}, Exception : {}", (Object)sendId, (Object)e);
            }
            finally {
                if (lockController == null) continue;
                lockController.unLock();
            }
        }
        if (sendList != null) {
            sendList.clear();
            sendList = null;
        }
        end = System.currentTimeMillis();
        CancledSendInfoScheduler.log.info("[SCHEDULER] END worked:{}, [{}] seconds", (Object)workingCount, (Object)((double)(end - start) / 1000.0));
    }

    public int updateSendInfo(ResultSendInfoModel rsm, String jobstate, String reason) {
        if (this.sendDao.countSendInfoByJobStatus(rsm.getSendId(), rsm.getCurrentStatus()) < 1) {
            return 0;
        }
        switch (jobstate) {
            case "31": {
                this.sendBasicService.sendResult31Process(rsm);
                break;
            }
            case "32": {
                this.sendBasicService.sendResult32Process(rsm);
                break;
            }
            case "38": {
                this.sendBasicService.sendResult38Process(rsm);
                break;
            }
            case "40": {
                this.sendBasicService.sendResult40Process(rsm);
                break;
            }
            case "41": {
                this.sendBasicService.sendResult41Process(rsm);
                break;
            }
            case "42": {
                this.sendBasicService.sendResult42Process(rsm);
                break;
            }
            case "43": {
                this.sendBasicService.sendResult43Process(rsm);
                break;
            }
            case "10": {
                this.sendBasicService.sendResult10Process(rsm);
                break;
            }
        }
        long startDb = System.currentTimeMillis();
        int result = this.sendDao.updateSendInfoJobState(rsm.getSendId(), jobstate);
        long endDb = System.currentTimeMillis();
        if (result > 0) {
            log.info("[QUERY] updateSendInfo sendId:{} currentStatus{}, changeJobStatus:{}, reason:{} ============[{}] seconds", new Object[]{rsm.getSendId(), rsm.getCurrentStatus(), jobstate, reason, (double)(endDb - startDb) / 1000.0});
        }
        return result;
    }

    public boolean isCanceled(ResultSendInfoModel rsm) {
        if (rsm.getUpdateDate() == null) {
            return false;
        }
        return Long.parseLong(rsm.getUpdateDate()) + 10L < Long.parseLong(DateUtil.getFullDateDefaultFormat());
    }
}

