/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule.result;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.Column;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.manager.handler.MonitorSendProcessHandler;
import com.humuson.tms.manager.repository.model.SprocInfo;
import com.humuson.tms.manager.util.LockCheckerUtil;
import com.humuson.tms.util.date.DateUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
@EnableScheduling
public class SendingProgressConditionScheduler {
    private static final Logger log = LoggerFactory.getLogger(SendingProgressConditionScheduler.class);
    @Autowired
    private MonitorSendProcessHandler processSendMonitorHandler;
    @Autowired
    private LockContexter contexter;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Value(value="${tms.manager.monitor.send-process.scan-cnt}")
    public int scanCnt;
    @Value(value="${tms.manager.monitor.send-process.scan-limit}")
    public int scanLimit;
    @Value(value="${tms.manager.monitor.send-process.timeout-sender}")
    public int timeoutSender;
    @Value(value="${tms.manager.monitor.send-process.timeout-mapper}")
    public int timeoutMapper;
    @Value(value="${tms.manager.monitor.send-process.timeout-controller}")
    public int timeoutController;
    @Autowired
    LockCheckerUtil lockCheckerUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelayString="${tms.manager.monitor.send-process.interval}")
    public void sendingStateSchedule() {
        String lockResult = this.lockCheckerUtil.isAnyLocked();
        if (lockResult != null && !lockResult.trim().isEmpty()) {
            log.info("[SCHEDULER] {}", (Object)lockResult);
            return;
        }
        LockController lockController = this.contexter.lock("lock.manager.monitor.send");
        if (lockController.isLocked()) {
            log.info("[SCHEDULER] this schedule is locked. lock key[{}]", (Object)"lock.manager.monitor.send");
            return;
        }
        lockController.lock();
        long start = System.currentTimeMillis();
        List sprocKeyList = null;
        int index = 0;
        int maxCount = this.scanLimit;
        int currentlyListSize = 0;
        int maxWorkingCnt = 20;
        int workingCnt = 0;
        try {
            sprocKeyList = this.wrapperRedisTemplate.scan("SPROC", this.scanCnt, this.scanLimit);
            currentlyListSize = sprocKeyList.size();
            for (index = 0; index < 10; ++index) {
                for (int i = maxCount - this.scanLimit; i < sprocKeyList.size(); ++i) {
                    String sprocKey = (String)sprocKeyList.get(i);
                    if (maxWorkingCnt <= workingCnt) {
                        return;
                    }
                    try {
                        String schdIdOfSproc = sprocKey.split(":")[1];
                        String pinfoAndschdidKey = "PINFO" + ":" + schdIdOfSproc;
                        Map<String, String> pinfos = this.getPinfos(pinfoAndschdidKey);
                        if (ObjectUtils.isEmpty(pinfos)) {
                            log.warn("PINFO of schd_id of SPROC[{}] is empty. so delete all schd info in redis", (Object)schdIdOfSproc);
                            this.deleteAllSchdInfoInRedis(true, schdIdOfSproc);
                            ++workingCnt;
                            continue;
                        }
                        if (!this.saveProgressConditionOfDaemons(sprocKey)) continue;
                        ++workingCnt;
                        continue;
                    }
                    catch (Exception e) {
                        log.error("sproc state schedule error. key : {}, error : {} ", (Object)sprocKey, (Object)e);
                    }
                }
                if (maxWorkingCnt <= workingCnt) {
                    break;
                }
                sprocKeyList.clear();
                sprocKeyList = this.wrapperRedisTemplate.scan("SPROC", this.scanCnt, maxCount += this.scanLimit);
                if (currentlyListSize == sprocKeyList.size()) break;
                if (sprocKeyList.size() == 0) {
                    break;
                }
                currentlyListSize = sprocKeyList.size();
            }
        }
        catch (Exception e) {
            log.error("sproc state schedule error, error:{}", (Throwable)e);
        }
        finally {
            if (lockController != null) {
                lockController.unLock();
            }
        }
        long end = System.currentTimeMillis();
        log.info("[SCHEDULER] END worked:{}, SPROC try:{}. readed:{} [{}] seconds", new Object[]{workingCnt, index, currentlyListSize, (double)(end - start) / 1000.0});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveProgressConditionOfDaemons(String sprocKey) {
        boolean isProcessing = false;
        Map sprocs = null;
        Map infoMap = null;
        try {
            String[] schds = sprocKey.split(":");
            infoMap = this.wrapperRedisTemplate.hgetAllString("PINFO:" + schds[1]);
            if (infoMap != null && log.isDebugEnabled()) {
                log.debug("{} infoMap.size {}", (Object)("PINFO:" + schds[1]), (Object)infoMap.size());
            }
            if (infoMap == null || infoMap.size() == 0 || !infoMap.containsKey(Column.SEND_ID) || infoMap.get(Column.SEND_ID) == null) {
                log.warn("SPROC({}) is EXIST. But PINFO({}) is not EXIST. SCHD_ID:{}, will delete SPROC.", new Object[]{sprocKey, "PINFO:" + schds[1], schds[1]});
                this.processSendMonitorHandler.deleteSproc(sprocKey);
                boolean bl = false;
                return bl;
            }
            sprocs = this.wrapperRedisTemplate.hgetAllString(sprocKey);
            for (String schdIdAndTargetSeqField : sprocs.keySet()) {
                String sprocValue = (String)sprocs.get(schdIdAndTargetSeqField);
                if (StringUtils.isEmpty((CharSequence)sprocValue)) continue;
                try {
                    if (this.isCorrectSproc(sprocValue)) {
                        this.processState(infoMap, sprocKey, schdIdAndTargetSeqField, sprocValue, false);
                        isProcessing = true;
                        continue;
                    }
                    String[] statesOfDemons = sprocValue.split("\\:");
                    if (!DateUtil.checkTimeoutSecondToNow((int)604800, (String)statesOfDemons[3])) continue;
                    this.processState(infoMap, sprocKey, schdIdAndTargetSeqField, sprocValue, true);
                    isProcessing = true;
                }
                catch (Exception e) {
                    log.error("sproc key[{}] process error. continue.., error:{}", (Object)sprocKey, (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.error("sproc key[{}] select error, error:{}", (Object)sprocKey, (Object)e);
        }
        finally {
            if (sprocs != null) {
                sprocs.clear();
                sprocs = null;
            }
            if (infoMap != null) {
                infoMap.clear();
                infoMap = null;
            }
        }
        return isProcessing;
    }

    public boolean isCorrectSproc(String sprocValue) {
        if (sprocValue.contains("CT")) {
            String[] statesOfDemons = sprocValue.split("\\:");
            if (Integer.valueOf(statesOfDemons[2]) > 40) {
                return true;
            }
            if (sprocValue.contains("MP") && sprocValue.indexOf("MP") != sprocValue.lastIndexOf("MP")) {
                return true;
            }
        }
        return false;
    }

    private void processState(Map<String, String> infoMap, String sprocKey, String sprocField, String sprocValue, boolean isSprocTimeout) throws Exception {
        try {
            int i;
            sprocValue = sprocValue.replaceAll("\\|", ":");
            SprocInfo sprocInfo = this.createSproInfo(infoMap, sprocField);
            if (sprocValue.contains("CT")) {
                String ctSprocValue = null;
                ctSprocValue = sprocValue.contains("MP") ? sprocValue.substring(sprocValue.indexOf("CT"), sprocValue.indexOf("MP")) : sprocValue.substring(sprocValue.indexOf("CT"), sprocValue.length());
                String[] ctStatesOfDemons = ctSprocValue.split("\\:");
                for (i = 0; i < ctStatesOfDemons.length; ++i) {
                    PropertyUtils.setProperty((Object)sprocInfo, (String)SprocInfo.SPROC_CT_VALUE_PROPERTYS[i], (Object)ctStatesOfDemons[i]);
                }
            }
            if (sprocValue.contains("MP")) {
                if (sprocValue.indexOf("MP") == sprocValue.lastIndexOf("MP")) {
                    String mpSprocValue = sprocValue.substring(sprocValue.indexOf("MP"), sprocValue.length());
                    String[] statesOfDemons = mpSprocValue.split("\\:");
                    if (Integer.valueOf(statesOfDemons[2].trim()) == 10) {
                        for (i = 0; i < statesOfDemons.length; ++i) {
                            PropertyUtils.setProperty((Object)sprocInfo, (String)SprocInfo.SPROC_MPS_VALUE_PROPERTYS[i], (Object)statesOfDemons[i]);
                        }
                    } else {
                        for (i = 0; i < statesOfDemons.length; ++i) {
                            PropertyUtils.setProperty((Object)sprocInfo, (String)SprocInfo.SPROC_MPE_VALUE_PROPERTYS[i], (Object)statesOfDemons[i]);
                        }
                    }
                } else {
                    int i2;
                    String startprocValue = sprocValue.substring(sprocValue.indexOf("MP"), sprocValue.lastIndexOf("MP"));
                    String endprocValue = sprocValue.substring(sprocValue.lastIndexOf("MP"), sprocValue.length());
                    String[] startStatesOfDemons = startprocValue.split("\\:");
                    String[] endStatesOfDemons = endprocValue.split("\\:");
                    for (i2 = 0; i2 < startStatesOfDemons.length; ++i2) {
                        PropertyUtils.setProperty((Object)sprocInfo, (String)SprocInfo.SPROC_MPS_VALUE_PROPERTYS[i2], (Object)startStatesOfDemons[i2]);
                    }
                    for (i2 = 0; i2 < endStatesOfDemons.length; ++i2) {
                        PropertyUtils.setProperty((Object)sprocInfo, (String)SprocInfo.SPROC_MPE_VALUE_PROPERTYS[i2], (Object)endStatesOfDemons[i2]);
                    }
                }
            }
            sprocInfo.setCancelStatus();
            if (log.isDebugEnabled()) {
                log.debug("sprocInfo {}", (Object)sprocInfo.toString());
            }
            boolean isTimeout = this.isOverMapperTimeLimit(sprocInfo);
            if ((isSprocTimeout || this.isMapperCompleteOrSendCancel(sprocInfo) || this.isCTWhethertoregister(sprocInfo)) && this.processSendMonitorHandler.saveSprocToRepository(sprocInfo, isTimeout)) {
                this.processSendMonitorHandler.deleteSprocField(sprocKey, sprocField);
            }
        }
        catch (Exception e) {
            log.error("[SPROC FORMAT ERROR] key {} field {} value {} DELETE [Exception] {}", new Object[]{sprocKey, sprocField, sprocValue, e});
        }
    }

    private boolean isOverMapperTimeLimit(SprocInfo sprocInfo) {
        boolean isTimeout = false;
        if (sprocInfo.getMPS_DATE() != null) {
            return DateUtil.checkTimeoutSecondToNow((int)(this.timeoutMapper * 60), (String)sprocInfo.getMPS_DATE());
        }
        return isTimeout;
    }

    private SprocInfo createSproInfo(Map<String, String> infoMap, String sprocField) {
        SprocInfo sprocInfo = new SprocInfo();
        sprocInfo.setSEND_ID(Long.parseLong(infoMap.get(Column.SEND_ID)));
        sprocInfo.setSCHD_ID(Long.parseLong(infoMap.get(Column.SCHD_ID)));
        String targetSeq = sprocField.split(":")[1];
        sprocInfo.setTARGET_SEQ(Integer.parseInt(targetSeq));
        return sprocInfo;
    }

    private boolean isMapperCompleteOrSendCancel(SprocInfo sprocInfo) {
        return sprocInfo.getMPE_STATUS() != null || sprocInfo.isCANCEL_STATUS();
    }

    private boolean isCTWhethertoregister(SprocInfo sprocInfo) {
        boolean resultFlag = false;
        if (Integer.parseInt(sprocInfo.getCT_SENT_COUNT()) > 0) {
            if (sprocInfo.getCT_STATUS().equals("41")) {
                resultFlag = true;
            }
        } else {
            resultFlag = true;
        }
        return resultFlag;
    }

    private void delRedisReqFormat(String sprocKey, String sprocField) {
        this.wrapperRedisTemplate.hmdel(sprocKey, sprocField);
        log.warn("[REDIS_DELETE] {} {}", (Object)sprocKey, (Object)sprocField);
        this.wrapperRedisTemplate.del("TLIST:" + sprocField);
        log.warn("[REDIS_DELETE] {}", (Object)("TLIST:" + sprocField));
    }

    private Map<String, String> getPinfos(String pinfoAndschdidKey) {
        Map pinfos = null;
        try {
            pinfos = this.wrapperRedisTemplate.hgetAllString(pinfoAndschdidKey);
            if (log.isDebugEnabled()) {
                log.debug("{} pinfos.size {}", (Object)pinfoAndschdidKey, (Object)(pinfos == null ? 0 : pinfos.size()));
            }
        }
        catch (Exception e) {
            log.error("error select pinfo[{}], error:{} ", (Object)pinfoAndschdidKey, (Object)e);
        }
        return pinfos;
    }

    private void deleteAllSchdInfoInRedis(boolean isPinfoNull, String pinfoAndschdidKey) {
        log.info("[NOT MONITOR SEND TARGET] schdId {} is not have PINFO ", (Object)pinfoAndschdidKey);
        if (!isPinfoNull) {
            this.wrapperRedisTemplate.del("PINFO:" + pinfoAndschdidKey);
            log.warn("[REDIS_DELETE] {} ", (Object)("PINFO:" + pinfoAndschdidKey));
        }
        this.wrapperRedisTemplate.del("SPROC:" + pinfoAndschdidKey);
        log.warn("[REDIS_DELETE] {} ", (Object)("SPROC:" + pinfoAndschdidKey));
        List tlistKeyList = this.wrapperRedisTemplate.scan("TLIST:" + pinfoAndschdidKey, this.scanCnt, this.scanLimit);
        if (tlistKeyList != null && tlistKeyList.size() > 0) {
            for (String tlistKey : tlistKeyList) {
                this.wrapperRedisTemplate.del(tlistKey);
            }
            log.warn("[REDIS_DELETE] {} target seq size {}", (Object)("TLIST:" + pinfoAndschdidKey), (Object)tlistKeyList.size());
        }
    }
}

