/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule.result;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.manager.custom.batch.listener.ResultBiztalkJobListener;
import com.humuson.tms.manager.custom.repository.dao.ResultBiztalkDao;
import com.humuson.tms.manager.custom.repository.model.ResultBiztalkModel;
import com.humuson.tms.manager.result.ResultBiztalk;
import com.humuson.tms.manager.util.LockCheckerUtil;
import com.humuson.tms.util.date.DateUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="tms.manager.proc-result-ka", name={"result-use"}, havingValue="true", matchIfMissing=true)
public class SaveKaSentResultScheduler {
    private static final Logger log = LoggerFactory.getLogger(SaveKaSentResultScheduler.class);
    @Autowired
    private ResultBiztalkDao resultBiztalkDao;
    @Value(value="${tms.manager.proc-result-ka.limit}")
    private int resultTargetLimit;
    @Autowired
    ResultBiztalk resultKaService;
    @Autowired
    private LockContexter contexter;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    @Qualifier(value="syncJobLauncher")
    protected JobLauncher syncJobLauncher;
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    @Qualifier(value="resultBiztalkJob")
    public Job resultJobKa;
    @Autowired
    ResultBiztalkJobListener bizListener;
    @Autowired
    LockCheckerUtil lockCheckerUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelayString="${tms.manager.proc-result-ka.interval}")
    public void saveSentResultSchedule() {
        String lockResult = this.lockCheckerUtil.isAnyLocked();
        if (lockResult != null && !lockResult.trim().isEmpty()) {
            log.info("[SCHEDULER] {}", (Object)lockResult);
            return;
        }
        long start = System.currentTimeMillis();
        List<String> resultTableNames = this.resultKaService.makeTableList();
        LockController lockController = this.contexter.lock("lock.manager.result.ka");
        if (lockController.isLocked()) {
            log.info("[SaveKaSentResultScheduler] already !");
            return;
        }
        try {
            for (String tableName : resultTableNames) {
                ResultBiztalkModel kaStand = this.resultBiztalkDao.selectKaStandId(tableName, this.resultTargetLimit);
                kaStand.setTableName(tableName);
                log.info("[SaveKaSentResultScheduler] target start : {}", (Object)DateUtil.getFullDateDefaultFormat());
                if (this.isEmptyOfKaResult(kaStand)) continue;
                try {
                    JobParameters jobParameters = new JobParametersBuilder().addLong("minId", kaStand.getMinId()).addLong("maxId", kaStand.getMaxId()).addLong("toCnt", kaStand.getToCnt()).addString("tableName", kaStand.getTableName()).toJobParameters();
                    this.syncJobLauncher.run(this.resultBiztalkJob(this.bizListener), jobParameters);
                }
                catch (Exception e) {
                    log.error("sms result table[{}] job error sms info[{}], error:{}", new Object[]{tableName, kaStand, e});
                }
            }
        }
        catch (Exception e) {
            log.error("[ERROR]  exception:{}", (Throwable)e);
        }
        finally {
            long end = System.currentTimeMillis();
            log.info("[SCHEDULER] END [{}] seconds", (Object)((double)(end - start) / 1000.0));
            if (resultTableNames != null) {
                resultTableNames.clear();
                resultTableNames = null;
            }
        }
    }

    private boolean isEmptyOfKaResult(ResultBiztalkModel kaStand) {
        if (kaStand.getToCnt() == 0L) {
            if (log.isDebugEnabled()) {
                log.debug("[SaveKaSentResultScheduler] has not target");
            }
            return true;
        }
        log.info("[SaveKaSentResultScheduler] min {} max {} toCnt {}", new Object[]{kaStand.getMinId(), kaStand.getMaxId(), kaStand.getToCnt()});
        return false;
    }

    @Bean(value={"resultBiztalkJob"})
    public Job resultBiztalkJob(ResultBiztalkJobListener listener) {
        return ((SimpleJobBuilder)((JobBuilder)this.jobBuilderFactory.get("resultKaJobManager").incrementer((JobParametersIncrementer)new RunIdIncrementer())).start(this.resultKaService.step1()).listener((JobExecutionListener)listener)).build();
    }

    public Step step1() {
        return this.resultKaService.step1();
    }

    public List<String> makeTableList() {
        return this.resultKaService.makeTableList();
    }
}

