/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule.monitor;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.manager.monitor.MonitorDaemon;
import com.humuson.tms.manager.repository.dao.MonitorDaemonDao;
import com.humuson.tms.manager.util.LockCheckerUtil;
import com.humuson.tms.util.date.DateUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@EnableConfigurationProperties
@ConfigurationProperties(prefix="tms.manager.monitor")
public class SaveEngineStateToRepositoryScheduler {
    private static final Logger log = LoggerFactory.getLogger(SaveEngineStateToRepositoryScheduler.class);
    @Value(value="${tms.manager.monitor.daemon-live.rdb-record.enabled}")
    public boolean isRdbRecord;
    @Autowired
    private LockContexter contexter;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    private MonitorDaemonDao monitorDaemonDao;
    @Autowired
    private MonitorDaemon moniterDaemonService;
    public Map<String, String> jstat;
    @Autowired
    LockCheckerUtil lockCheckerUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelayString="${tms.manager.monitor.daemon-live.interval}")
    public void uploadEngineStateToRdbScheduler() {
        String lockResult = this.lockCheckerUtil.isAnyLocked();
        if (lockResult != null && !lockResult.trim().isEmpty()) {
            log.info("[SCHEDULER] {}", (Object)lockResult);
            return;
        }
        LockController lockController = this.contexter.lock("lock.manager.monitor.daemon");
        if (lockController.isLocked()) {
            log.info("[SCHEDULER] this schedule is locked. lock key[{}]", (Object)"lock.manager.monitor.daemon");
            return;
        }
        lockController.lock();
        long start = System.currentTimeMillis();
        Map<String, String> daemonMemoryInfoOfWorkday = new HashMap();
        try {
            for (String jstatKey : this.jstat.keySet()) {
                try {
                    daemonMemoryInfoOfWorkday = this.wrapperRedisTemplate.hgetAllString(jstatKey);
                    Iterator<String> jstatEngineStateKeyIterator = daemonMemoryInfoOfWorkday.keySet().iterator();
                    while (jstatEngineStateKeyIterator.hasNext()) {
                        this.processingMemoryInfoOfdaemonOfToday(jstatKey, daemonMemoryInfoOfWorkday, jstatEngineStateKeyIterator);
                    }
                }
                catch (Exception e) {
                    log.error("failed reading jstat key[{}] from redis. continue.., error:{}", (Object)jstatKey, (Object)e);
                }
                finally {
                    if (daemonMemoryInfoOfWorkday == null) continue;
                    daemonMemoryInfoOfWorkday.clear();
                    daemonMemoryInfoOfWorkday = null;
                }
            }
        }
        catch (Exception e) {
            log.error("failed demon live checking, error:{} ", (Throwable)e);
        }
        finally {
            long end = System.currentTimeMillis();
            log.info("[SCHEDULER] END [{}] seconds", (Object)((double)(end - start) / 1000.0));
            if (daemonMemoryInfoOfWorkday != null) {
                daemonMemoryInfoOfWorkday.clear();
                daemonMemoryInfoOfWorkday = null;
            }
            if (lockController != null) {
                lockController.unLock();
            }
        }
    }

    private void processingMemoryInfoOfdaemonOfToday(String jstatKey, Map<String, String> daemonMemoryInfoOfWorkday, Iterator<String> jstatEngineStateKeyIterator) throws Exception {
        try {
            String yyyymmddOfToday = DateUtil.getDivideDateDefault()[0];
            String daemonIdAndWorkdayKey = null;
            String daemonMemoryInfoValue = null;
            daemonIdAndWorkdayKey = jstatEngineStateKeyIterator.next();
            daemonMemoryInfoValue = daemonMemoryInfoOfWorkday.get(daemonIdAndWorkdayKey);
            if (daemonIdAndWorkdayKey.endsWith(yyyymmddOfToday)) {
                String[] vals = daemonMemoryInfoValue.split("\\|");
                if (this.isRdbRecord) {
                    this.insertMonitorInfo(jstatKey.split(":")[1], daemonIdAndWorkdayKey, this.usedMemory(vals));
                }
                this.processDaemon(daemonMemoryInfoOfWorkday.get(this.jstat), daemonIdAndWorkdayKey, this.usedMemory(vals));
            }
            this.removedaemonInfoOfToday(jstatKey, daemonIdAndWorkdayKey, daemonMemoryInfoValue);
        }
        catch (Exception e) {
            log.error("memory info processing error jstat key[{}], daemon info[{}], error:{}", new Object[]{jstatKey, daemonMemoryInfoOfWorkday, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertMonitorInfo(String daemonType, String field, String value) throws Exception {
        long start = System.currentTimeMillis();
        String[] kStrs = field.split(":");
        String[] vStrs = value.split(":");
        HashMap<String, Object> paramMap = null;
        try {
            paramMap = new HashMap<String, Object>();
            paramMap.put("DAEMON_TYPE", daemonType);
            paramMap.put("DAEMON_INDEX", kStrs[0]);
            paramMap.put("LAST_WORK_DATE", kStrs[1] + vStrs[0]);
            paramMap.put("MAX_MEMORY", Long.parseLong(vStrs[1]));
            paramMap.put("USED_MEMORY", Long.parseLong(vStrs[2]));
            this.monitorDaemonDao.updateMonitorDaemon(paramMap);
        }
        catch (Exception e) {
            try {
                log.error("[QUERY] updateMonitorDaemon Exception:{}", (Throwable)e);
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                log.debug("[QUERY] updateMonitorDaemon {}:{} ============[{}] seconds", new Object[]{daemonType, kStrs[0], (double)(end - start) / 1000.0});
                if (paramMap != null) {
                    paramMap.clear();
                    paramMap = null;
                }
                throw throwable;
            }
            long end = System.currentTimeMillis();
            log.debug("[QUERY] updateMonitorDaemon {}:{} ============[{}] seconds", new Object[]{daemonType, kStrs[0], (double)(end - start) / 1000.0});
            if (paramMap != null) {
                paramMap.clear();
                paramMap = null;
            }
        }
        long end = System.currentTimeMillis();
        log.debug("[QUERY] updateMonitorDaemon {}:{} ============[{}] seconds", new Object[]{daemonType, kStrs[0], (double)(end - start) / 1000.0});
        if (paramMap != null) {
            paramMap.clear();
            paramMap = null;
        }
    }

    public void processDaemon(String daemonType, String field, String value) throws Exception {
        this.moniterDaemonService.processDaemonWork(daemonType, field, value);
    }

    private void removedaemonInfoOfToday(String jstatKey, String daemonIdAndWorkdayKey, String daemonMemoryInfoValue) {
        if (daemonMemoryInfoValue != null) {
            this.wrapperRedisTemplate.hmdel(jstatKey, daemonIdAndWorkdayKey);
        }
    }

    private String usedMemory(String[] vals) {
        return vals[vals.length - 1];
    }

    public boolean isRdbRecord() {
        return this.isRdbRecord;
    }

    public LockContexter getContexter() {
        return this.contexter;
    }

    public WrapperRedisTemplate getWrapperRedisTemplate() {
        return this.wrapperRedisTemplate;
    }

    public MonitorDaemonDao getMonitorDaemonDao() {
        return this.monitorDaemonDao;
    }

    public MonitorDaemon getMoniterDaemonService() {
        return this.moniterDaemonService;
    }

    public Map<String, String> getJstat() {
        return this.jstat;
    }

    public LockCheckerUtil getLockCheckerUtil() {
        return this.lockCheckerUtil;
    }

    public void setRdbRecord(boolean isRdbRecord) {
        this.isRdbRecord = isRdbRecord;
    }

    public void setContexter(LockContexter contexter) {
        this.contexter = contexter;
    }

    public void setWrapperRedisTemplate(WrapperRedisTemplate wrapperRedisTemplate) {
        this.wrapperRedisTemplate = wrapperRedisTemplate;
    }

    public void setMonitorDaemonDao(MonitorDaemonDao monitorDaemonDao) {
        this.monitorDaemonDao = monitorDaemonDao;
    }

    public void setMoniterDaemonService(MonitorDaemon moniterDaemonService) {
        this.moniterDaemonService = moniterDaemonService;
    }

    public void setJstat(Map<String, String> jstat) {
        this.jstat = jstat;
    }

    public void setLockCheckerUtil(LockCheckerUtil lockCheckerUtil) {
        this.lockCheckerUtil = lockCheckerUtil;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SaveEngineStateToRepositoryScheduler)) {
            return false;
        }
        SaveEngineStateToRepositoryScheduler other = (SaveEngineStateToRepositoryScheduler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRdbRecord() != other.isRdbRecord()) {
            return false;
        }
        LockContexter this$contexter = this.getContexter();
        LockContexter other$contexter = other.getContexter();
        if (this$contexter == null ? other$contexter != null : !this$contexter.equals(other$contexter)) {
            return false;
        }
        WrapperRedisTemplate this$wrapperRedisTemplate = this.getWrapperRedisTemplate();
        WrapperRedisTemplate other$wrapperRedisTemplate = other.getWrapperRedisTemplate();
        if (this$wrapperRedisTemplate == null ? other$wrapperRedisTemplate != null : !this$wrapperRedisTemplate.equals(other$wrapperRedisTemplate)) {
            return false;
        }
        MonitorDaemonDao this$monitorDaemonDao = this.getMonitorDaemonDao();
        MonitorDaemonDao other$monitorDaemonDao = other.getMonitorDaemonDao();
        if (this$monitorDaemonDao == null ? other$monitorDaemonDao != null : !this$monitorDaemonDao.equals(other$monitorDaemonDao)) {
            return false;
        }
        MonitorDaemon this$moniterDaemonService = this.getMoniterDaemonService();
        MonitorDaemon other$moniterDaemonService = other.getMoniterDaemonService();
        if (this$moniterDaemonService == null ? other$moniterDaemonService != null : !this$moniterDaemonService.equals(other$moniterDaemonService)) {
            return false;
        }
        Map<String, String> this$jstat = this.getJstat();
        Map<String, String> other$jstat = other.getJstat();
        if (this$jstat == null ? other$jstat != null : !((Object)this$jstat).equals(other$jstat)) {
            return false;
        }
        LockCheckerUtil this$lockCheckerUtil = this.getLockCheckerUtil();
        LockCheckerUtil other$lockCheckerUtil = other.getLockCheckerUtil();
        return !(this$lockCheckerUtil == null ? other$lockCheckerUtil != null : !this$lockCheckerUtil.equals(other$lockCheckerUtil));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SaveEngineStateToRepositoryScheduler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRdbRecord() ? 79 : 97);
        LockContexter $contexter = this.getContexter();
        result = result * 59 + ($contexter == null ? 0 : $contexter.hashCode());
        WrapperRedisTemplate $wrapperRedisTemplate = this.getWrapperRedisTemplate();
        result = result * 59 + ($wrapperRedisTemplate == null ? 0 : $wrapperRedisTemplate.hashCode());
        MonitorDaemonDao $monitorDaemonDao = this.getMonitorDaemonDao();
        result = result * 59 + ($monitorDaemonDao == null ? 0 : $monitorDaemonDao.hashCode());
        MonitorDaemon $moniterDaemonService = this.getMoniterDaemonService();
        result = result * 59 + ($moniterDaemonService == null ? 0 : $moniterDaemonService.hashCode());
        Map<String, String> $jstat = this.getJstat();
        result = result * 59 + ($jstat == null ? 0 : ((Object)$jstat).hashCode());
        LockCheckerUtil $lockCheckerUtil = this.getLockCheckerUtil();
        result = result * 59 + ($lockCheckerUtil == null ? 0 : $lockCheckerUtil.hashCode());
        return result;
    }

    public String toString() {
        return "SaveEngineStateToRepositoryScheduler(isRdbRecord=" + this.isRdbRecord() + ", contexter=" + this.getContexter() + ", wrapperRedisTemplate=" + this.getWrapperRedisTemplate() + ", monitorDaemonDao=" + this.getMonitorDaemonDao() + ", moniterDaemonService=" + this.getMoniterDaemonService() + ", jstat=" + this.getJstat() + ", lockCheckerUtil=" + this.getLockCheckerUtil() + ")";
    }
}

