/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule.clean;

import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.manager.batch.listener.CleanRdbJobListener;
import com.humuson.tms.manager.clean.CleanRdb;
import com.humuson.tms.manager.util.LockCheckerUtil;
import com.humuson.tms.manager.util.StatusCheckerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="tms.manager.clean.rdb", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class CleanSentInfoInRdbScheduler {
    private static final Logger log = LoggerFactory.getLogger(CleanSentInfoInRdbScheduler.class);
    @Autowired
    CleanRdb cleanRdb;
    @Autowired
    @Qualifier(value="asyncJobLauncher")
    JobLauncher asyncJobLauncher;
    @Autowired
    private LockContexter contexter;
    @Autowired
    StatusCheckerUtil statusCheckerUtil;
    @Autowired
    LockCheckerUtil lockCheckerUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="${tms.manager.clean.rdb.cron-cycle}")
    public void cleanJobSchedule() {
        String lockResult = this.lockCheckerUtil.isAnyLocked();
        if (lockResult != null && !lockResult.trim().isEmpty()) {
            log.info("[SCHEDULER] {}", (Object)lockResult);
            return;
        }
        LockController lockController = this.contexter.lock("lock.manager.clean.rdb");
        if (lockController.isLocked()) {
            log.info("[SCHEDULER] this schedule is locked. lock key[{}]", (Object)"lock.manager.clean.rdb");
            return;
        }
        long start = System.currentTimeMillis();
        try {
            if (this.statusCheckerUtil.isAsyncJobLauncherStocked(this.getClass().getSimpleName())) {
                JobParameters jobParameters = new JobParametersBuilder().addLong("time", Long.valueOf(System.currentTimeMillis())).toJobParameters();
                this.asyncJobLauncher.run(this.cleanRdb.cleanRdbJob(new CleanRdbJobListener()), jobParameters);
            }
        }
        catch (Exception e) {
            log.error("CM0050|Fail BATCH job running : cleanRdbJob, error:{} ", (Throwable)e);
        }
        finally {
            long end = System.currentTimeMillis();
            log.info("[SCHEDULER] END [{}] seconds", (Object)((double)(end - start) / 1000.0));
        }
    }
}

