/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule.clean;

import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.manager.clean.Clean;
import com.humuson.tms.manager.util.LockCheckerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="tms.manager.clean.redis", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class CleanRedisScheduler {
    private static final Logger log = LoggerFactory.getLogger(CleanRedisScheduler.class);
    @Autowired
    Clean cleanService;
    @Autowired
    private LockContexter contexter;
    @Autowired
    LockCheckerUtil lockCheckerUtil;

    @Scheduled(cron="${tms.manager.clean.redis.cron-cycle}")
    public void schedule() {
        String lockResult = this.lockCheckerUtil.isAnyLocked();
        if (lockResult != null && !lockResult.trim().isEmpty()) {
            log.info("[SCHEDULER] {}", (Object)lockResult);
            return;
        }
        LockController lockController = this.contexter.lock("lock.manager.clean.redis");
        if (lockController.isLocked()) {
            log.info("[SCHEDULER] this schedule is locked. lock key[{}]", (Object)"lock.manager.clean.redis");
            return;
        }
        lockController.lock();
        long start = System.currentTimeMillis();
        this.cleanService.cleanData();
        if (lockController != null) {
            lockController.unLock();
        }
        long end = System.currentTimeMillis();
        log.info("[SCHEDULER] END [{}] seconds", (Object)((double)(end - start) / 1000.0));
    }
}

