/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule.clean;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
@EnableScheduling
public class CleanCrsltKeyOfRedisScheduler {
    private static final Logger log = LoggerFactory.getLogger(CleanCrsltKeyOfRedisScheduler.class);
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    private static final String yyyyMMddHHmm = "yyyyMMddHHmm";
    private static final int REMOVE_DAY = 3;
    private static final DateTimeFormatter CRSLT_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmm");
    private Map<String, Long> eachChannelCrsltKey = new ConcurrentHashMap<String, Long>();
    private Set<String> toBeDeleteCrsltKeys = Collections.synchronizedSet(new HashSet());
    private CountDownLatch afterRemove = new CountDownLatch(1);

    @Scheduled(fixedDelay=3600000L)
    public void delteAfterAfewDayCrsltKeySchedule() {
        Set crsltKeys = this.wrapperRedisTemplate.zRange("CRSLT_KEY", 0L, -1L);
        for (String crsltKey : crsltKeys) {
            String dateTimeOfKey = crsltKey.substring(9);
            LocalDateTime dateTime = LocalDateTime.parse(dateTimeOfKey, CRSLT_DATE_FORMAT);
            if (!LocalDateTime.now().minusDays(3L).isAfter(dateTime)) continue;
            log.info("[{}] days after crslt_key deleted. CRSLT_KEY[{}]", (Object)3, (Object)crsltKey);
            this.wrapperRedisTemplate.zDel("CRSLT_KEY", new String[]{crsltKey});
            this.toBeDeleteCrsltKeys.remove(crsltKey);
        }
    }

    public void delCrsltDataScheduler(String crsltkey) {
        this.wrapperRedisTemplate.del(crsltkey);
    }

    @Scheduled(fixedDelay=60000L)
    public void schedule() {
        if (this.afterRemove.getCount() == 0L) {
            this.afterRemove = new CountDownLatch(1);
        }
        try {
            Set crsltKeys = this.wrapperRedisTemplate.zRange("CRSLT_KEY", 0L, -1L);
            for (String crsltKey : crsltKeys) {
                this.canDeleteCrsltKey(crsltKey);
            }
        }
        catch (Exception e) {
            log.error("clean crslt_key list error", (Throwable)e);
        }
    }

    @Scheduled(fixedDelay=300000L)
    public void deleteCrsltKeySchedule() {
        if (this.afterRemove.getCount() != 1L) {
            return;
        }
        for (String crsltKey : this.toBeDeleteCrsltKeys) {
            try {
                Map crsltValues = this.wrapperRedisTemplate.hscan(crsltKey, "", 1, 10);
                if (!ObjectUtils.isEmpty((Object)crsltValues)) continue;
                this.wrapperRedisTemplate.zDel("CRSLT_KEY", new String[]{crsltKey});
                this.delCrsltDataScheduler(crsltKey);
                this.toBeDeleteCrsltKeys.remove(crsltKey);
                log.info("removed (zero count in redis). CRSLT_KEY[{}]", (Object)crsltKey);
            }
            catch (Exception e) {
                log.error("error when remove crslt_key[redis / local[toBeDeleteCrsltKeys]]. CRSLT_KEY[{}]", (Object)crsltKey, (Object)e);
            }
        }
        this.afterRemove.countDown();
    }

    public boolean canDeleteCrsltKey(String crsltKey) {
        String[] arrayCrsltKey = crsltKey.split(":");
        Long asIsLastTime = this.eachChannelCrsltKey.get(arrayCrsltKey[1]);
        if (ObjectUtils.isEmpty((Object)asIsLastTime)) {
            this.eachChannelCrsltKey.put(arrayCrsltKey[1], Long.parseLong(arrayCrsltKey[2]));
            return false;
        }
        Long toBeLastTime = Long.parseLong(arrayCrsltKey[2]);
        if (toBeLastTime > asIsLastTime) {
            this.toBeDeleteCrsltKeys.add("CRSLT:" + arrayCrsltKey[1] + ":" + asIsLastTime);
            this.eachChannelCrsltKey.put(arrayCrsltKey[1], Long.parseLong(arrayCrsltKey[2]));
            return true;
        }
        return false;
    }

    public static void main1(String[] args) {
        String dateTimeOfKey = "CRSLT:EM:202009021542".substring(9);
        LocalDateTime dateTime = LocalDateTime.parse(dateTimeOfKey, CRSLT_DATE_FORMAT);
        if (LocalDateTime.now().minusDays(10L).isAfter(dateTime)) {
            System.out.println("10\uc77c \uc9c0\ub0ac\ub2e4.");
        }
    }
}

