/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.manager.custom.stat.CustomStatProcess;
import com.humuson.tms.manager.custom.stat.StatDataVO;
import com.humuson.tms.manager.custom.stat.dao.CustomStatDao;
import com.humuson.tms.manager.custom.stat.dao.StatOpenClickDao;
import com.humuson.tms.manager.custom.stat.openclick.StatOpenClickInfo;
import com.humuson.tms.manager.util.LockCheckerUtil;
import com.humuson.tms.util.date.DateUtil;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="tms.manager.proc-custom-stat", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class StatOpenClickScheduler {
    private static final Logger log = LoggerFactory.getLogger(StatOpenClickScheduler.class);
    @Autowired
    private LockContexter contexter;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    CustomStatDao custStatDao;
    @Autowired
    StatOpenClickDao statOpenClickDao;
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Value(value="${tms.manager.proc-custom-stat.stat-type}")
    private String statType;
    @Value(value="${tms.manager.proc-stat-openclick.using-workday:false}")
    private String workdayUseFlag;
    @Value(value="${tms.manager.proc-stat-openclick.tracking-start-workday:7}")
    private int startWorkday;
    @Value(value="${tms.manager.proc-stat-openclick.tracking-end-workday:0}")
    private int endWorkday;
    @Value(value="${tms.manager.proc-stat-openclick.tracking-interval:7}")
    private int trackingInterval;
    @Autowired
    LockCheckerUtil lockCheckerUtil;

    @Scheduled(fixedDelayString="${tms.manager.proc-custom-stat.interval}")
    public void schedule() {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        String lockResult = this.lockCheckerUtil.isAnyLocked();
        if (lockResult != null && !lockResult.trim().isEmpty()) {
            log.info("[SCHEDULER] {}", (Object)lockResult);
            return;
        }
        LockController lockController = this.contexter.lock("lock.manager.openClick.stat");
        if (lockController.isLocked()) {
            log.info("[SCHEDULER] this schedule is locked. lock key[{}]", (Object)"lock.manager.openClick.stat");
            return;
        }
        lockController.lock();
        int betweenStartWorkday = Integer.parseInt(DateUtil.getDateCalculationDay((String)"yyyyMMdd", (int)(-this.startWorkday)));
        int betweenEndWorkday = Integer.parseInt(DateUtil.getDateCalculationDay((String)"yyyyMMdd", (int)(-this.endWorkday)));
        List<StatOpenClickInfo> openClickStatCount = null;
        openClickStatCount = "true".equalsIgnoreCase(this.workdayUseFlag) ? this.statOpenClickDao.selectStartUniqOpenClickList(betweenStartWorkday, betweenEndWorkday) : this.statOpenClickDao.selectStartUniqOpenClickListInterval(this.trackingInterval);
        long start = System.currentTimeMillis();
        List<StatOpenClickInfo> openClickStatResult = null;
        if (openClickStatCount == null || openClickStatCount.size() == 0) {
            log.debug("[CUSTOM OPEN CLICK STAT-Scheduler] has not target schedule !");
        } else {
            paramMap.put("SCHD_START_DATE", betweenStartWorkday);
            paramMap.put("SCHD_END_DATE", betweenEndWorkday);
            openClickStatResult = this.statOpenClickDao.selectStartUniqOpenClickList(betweenStartWorkday, betweenEndWorkday);
            try {
                for (StatOpenClickInfo openClickModel : openClickStatCount) {
                    StatOpenClickInfo getSendListData = this.statOpenClickDao.selectSendListData(openClickModel);
                    openClickModel.setUNIQ_CLICK_CNT(getSendListData.getUNIQ_CLICK_CNT());
                    openClickModel.setUNIQ_OPEN_CNT(getSendListData.getUNIQ_OPEN_CNT());
                    StatDataVO statDataVo = this.createCustomOCData(openClickModel);
                    statDataVo.setDateType(this.statType);
                    statDataVo.setProcType("UPDATE");
                    CustomStatProcess custStat = new CustomStatProcess(statDataVo, this.custStatDao);
                    custStat.run();
                }
            }
            catch (Exception e) {
                log.error("CUSTOM OPEN CLICK STAT ERROR, error:{}", (Throwable)e);
            }
        }
        if (openClickStatResult != null) {
            openClickStatResult.clear();
        }
        if (lockController != null) {
            lockController.unLock();
        }
        long end = System.currentTimeMillis();
        log.info("[SCHEDULER] {} ~ {} END worked:{} [{}] seconds", new Object[]{betweenStartWorkday, betweenEndWorkday, openClickStatCount.size(), (double)(end - start) / 1000.0});
    }

    public StatDataVO createCustomOCData(StatOpenClickInfo openClickModel) {
        StatDataVO statDataVo = new StatDataVO();
        int openCnt = Integer.parseInt(openClickModel.getOPEN_CNT() + "");
        int clickCnt = Integer.parseInt(openClickModel.getCLICK_CNT() + "");
        StringBuffer eventType = new StringBuffer();
        statDataVo.setSendId(openClickModel.getSEND_ID());
        statDataVo.setSchdId(openClickModel.getSCHD_ID());
        statDataVo.setChannelType(openClickModel.getCHANNEL_TYPE());
        statDataVo.setUniqOpenCnt(openClickModel.getUNIQ_OPEN_CNT());
        statDataVo.setUniqClickCnt(openClickModel.getUNIQ_CLICK_CNT());
        if (openCnt > 0) {
            eventType.append("O");
            statDataVo.setOpenWorkday(openClickModel.getOPEN_WORKDAY());
            statDataVo.setOpenHour(openClickModel.getOPEN_HOUR());
        }
        if (clickCnt > 0) {
            statDataVo.setClickHour(openClickModel.getOPEN_HOUR());
            statDataVo.setClickWorkday(openClickModel.getOPEN_WORKDAY());
            if (!eventType.toString().equals("")) {
                eventType.append("|");
            }
            eventType.append("C");
        }
        statDataVo.setStatType(eventType.toString());
        return statDataVo;
    }
}

