/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.manager.custom.batch.listener.ResultSendListJobListener;
import com.humuson.tms.manager.result.ResultSend;
import com.humuson.tms.manager.util.LockCheckerUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@EnableBatchProcessing
public class ResultRdbSendListScheduler {
    private static final Logger log = LoggerFactory.getLogger(ResultRdbSendListScheduler.class);
    @Autowired
    private LockContexter contexter;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    @Qualifier(value="ResultSendListJobListener")
    ResultSendListJobListener resultSendListJobListener;
    @Autowired
    @Qualifier(value="syncJobLauncher")
    JobLauncher syncJobLauncher;
    @Value(value="${tms.manager.proc-result-tm.result-use:N}")
    private String resultUseFlag;
    @Value(value="${tms.manager.proc-result-tm.limit}")
    private int resultTargetLimit;
    @Autowired
    ResultSend resultSendListService;
    private List<String> tableList;
    @Autowired
    LockCheckerUtil lockCheckerUtil;

    @Scheduled(fixedDelayString="${tms.manager.proc-result-tm.interval}")
    public void schedule() {
        String lockResult = this.lockCheckerUtil.isAnyLocked();
        if (lockResult != null && !lockResult.trim().isEmpty()) {
            log.info("[SCHEDULER] {}", (Object)lockResult);
            return;
        }
        this.tableList = this.makeTableList();
        if (this.resultUseFlag == null || "N".equals(this.resultUseFlag)) {
            log.debug("{} is not use setting... this schd is pass", (Object)"lock.manager.result.sendList");
            return;
        }
        if (this.tableList == null || this.tableList.size() <= 0) {
            log.warn("{} has not table list... this schd is pass", (Object)"lock.manager.result.sendList");
            return;
        }
        LockController lockController = this.contexter.lock("lock.manager.result.sendList");
        if (lockController.isLocked()) {
            log.info("[SCHEDULER] this schedule is locked. lock key[{}]", (Object)"lock.manager.result.sendList");
            return;
        }
        long start = System.currentTimeMillis();
        long time = System.currentTimeMillis();
        String jobName = "statJob." + this.tableList.get(0) + "." + time;
        try {
            JobParameters jobParameters = new JobParametersBuilder().addString("jobName", jobName).addLong("time", Long.valueOf(System.currentTimeMillis())).addString("tableName", this.tableList.get(0)).toJobParameters();
            Job job = ((SimpleJobBuilder)((JobBuilder)this.jobBuilderFactory.get(jobName).incrementer((JobParametersIncrementer)new RunIdIncrementer())).start(this.step1()).listener((JobExecutionListener)this.resultSendListJobListener)).build();
            this.syncJobLauncher.run(job, jobParameters);
        }
        catch (Exception e) {
            log.error("job start error. jobName:{}, e: {}", (Object)jobName, (Object)e);
        }
        long end = System.currentTimeMillis();
        log.info("[SCHEDULER] END [{}] seconds", (Object)((double)(end - start) / 1000.0));
        if (this.tableList != null) {
            this.tableList.clear();
        }
    }

    public Step step1() {
        return this.resultSendListService.step1();
    }

    public List<String> makeTableList() {
        return this.resultSendListService.makeTableList();
    }
}

