/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.manager.repository.dao.SendDao;
import com.humuson.tms.manager.repository.model.ResultSendInfoModel;
import com.humuson.tms.manager.send.SendBasicService;
import com.humuson.tms.manager.util.LockCheckerUtil;
import com.humuson.tms.util.date.DateUtil;
import java.util.List;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="tms.manager.proc-send", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ResultRdbSendInfoScheduler {
    private static final Logger log = LoggerFactory.getLogger(ResultRdbSendInfoScheduler.class);
    private static final String LOCK_MN_STS_ = "LOCK_MN_STS_";
    @Autowired
    private LockContexter contexter;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    SendDao sendDao;
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    SendBasicService sendBasicService;
    @Autowired
    LockCheckerUtil lockCheckerUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelayString="${tms.manager.proc-send.interval}")
    public void schedule() {
        long workingSize = 0L;
        List<ResultSendInfoModel> sendList = this.sendDao.selectTargetSendList();
        if (ObjectUtils.isEmpty(sendList)) {
            return;
        }
        for (ResultSendInfoModel rsm : sendList) {
            long SEND_ID = rsm.getSendId();
            String LOCK_NAME = LOCK_MN_STS_ + SEND_ID;
            LockController lockController = null;
            try {
                lockController = this.contexter.lock(LOCK_NAME);
                if (lockController.isLocked()) {
                    log.info("MN-R: [SCHEDULER] This SEND_ID({}) is already working lock[{}]", (Object)SEND_ID, (Object)LOCK_NAME);
                    continue;
                }
                lockController.lock();
                String triggerMethod = rsm.getTriggerMethod();
                String currentStatus = rsm.getCurrentStatus();
                log.info("MN-R: send_id={} updating result job_status[{}] send_info[{}]", new Object[]{SEND_ID, currentStatus, rsm});
                int totalCnt = rsm.getSchdTotalCnt();
                int sendingCnt = rsm.getSchd30Cnt();
                int resultingCnt = rsm.getSchd38Cnt();
                int endCnt = rsm.getSchd40Cnt();
                int failCnt = rsm.getSchd41Cnt();
                int cancelCnt = rsm.getSchd42Cnt();
                int trackingEndCnt = rsm.getSchd43Cnt();
                int procTotalCnt = sendingCnt + resultingCnt + endCnt + failCnt + cancelCnt + trackingEndCnt;
                int resultCnt = endCnt + failCnt + trackingEndCnt + cancelCnt;
                int processTotalCnt = totalCnt - resultCnt;
                String currentDate = null;
                String uptTime = rsm.getUpdateDate();
                String cancelTime = DateUtil.getFullDateDefaultFormat();
                if (rsm.getCampType().equals("T")) {
                    currentDate = DateUtil.getWorkday();
                    log.debug("MN-R: currentDate : {} getCampEndTime {}", (Object)currentDate, (Object)Integer.parseInt(rsm.getCampEndTime()));
                    if (Integer.parseInt(rsm.getCampEndTime()) >= Integer.parseInt(currentDate) || currentStatus.equals("31") || !currentStatus.equals("32")) {
                        // empty if block
                    }
                }
                if (this.sendBasicService.isStartSendProcess(rsm)) {
                    log.warn("MN-R: send_id={} triggerMethod value is null. rsm.getTriggerMethod()={}", (Object)SEND_ID, (Object)rsm.getTriggerMethod());
                    this.updateSendInfo(rsm, "42");
                    ++workingSize;
                    continue;
                }
                if (rsm.getCampType().equals("T")) {
                    currentDate = DateUtil.getWorkday();
                    log.debug("MN-R: currentDate : {} getCampEndTime {}", (Object)currentDate, (Object)Integer.parseInt(rsm.getCampEndTime()));
                    if (Integer.parseInt(rsm.getCampEndTime()) >= Integer.parseInt(currentDate) || currentStatus.equals("31") || currentStatus.equals("32")) continue;
                    if (processTotalCnt != 0) {
                        this.updateSendInfo(rsm, "31");
                        ++workingSize;
                        continue;
                    }
                    this.updateSendInfo(rsm, "43");
                    ++workingSize;
                    continue;
                }
                if (currentStatus.equals("31")) {
                    log.warn("MN-R: send_id={} job_status={}. cancelling message", (Object)SEND_ID, (Object)currentStatus);
                    continue;
                }
                if (triggerMethod.equals(Constants.TriggerMethod.F1.toString()) || triggerMethod.equals(Constants.TriggerMethod.C5.toString())) {
                    if (rsm.getLastSchdStatus().equals("41")) {
                        this.updateSendInfo(rsm, "41");
                        ++workingSize;
                    }
                    log.info("MN-R: this Target Send ID [{}] : Skip [iImmediate delivery or real Time Send", (Object)SEND_ID);
                    continue;
                }
                if (currentStatus.equals("32")) {
                    log.warn("MN-R: send_id={} job_status={}. canceled message", (Object)SEND_ID, (Object)currentStatus);
                    continue;
                }
                if (totalCnt != sendingCnt) {
                    if (resultingCnt > 0 && currentStatus.equals("30")) {
                        this.updateSendInfo(rsm, "38");
                        ++workingSize;
                        continue;
                    }
                    if (failCnt > 0 && totalCnt == failCnt) {
                        this.updateSendInfo(rsm, "41");
                        ++workingSize;
                        continue;
                    }
                    if (processTotalCnt == 0) {
                        if (resultCnt > 0) {
                            if (currentStatus.equals("38") || currentStatus.equals("30")) {
                                log.info("MN-R: [SCHD_STATE_RESULTING] triggerMethod : {}, resultCnt : {}, lastSchdStatus: {}", new Object[]{triggerMethod, resultCnt, rsm.getLastSchdStatus()});
                                if (triggerMethod.equals(Constants.TriggerMethod.O9.toString()) || triggerMethod.equals(Constants.TriggerMethod.C1.toString()) || triggerMethod.equals(Constants.TriggerMethod.C2.toString()) || triggerMethod.equals(Constants.TriggerMethod.C3.toString()) || triggerMethod.equals(Constants.TriggerMethod.C4.toString())) {
                                    if (rsm.getLastSchdStatus().equals("41")) {
                                        this.updateSendInfo(rsm, "41");
                                        ++workingSize;
                                        continue;
                                    }
                                    this.updateSendInfo(rsm, "10");
                                    ++workingSize;
                                    continue;
                                }
                                if (totalCnt == resultCnt) {
                                    this.updateSendInfo(rsm, "40");
                                    ++workingSize;
                                    continue;
                                }
                                log.info("MN-R: this Target result send_id=[{}] skiped Job_status={} ", (Object)SEND_ID, (Object)currentStatus);
                                continue;
                            }
                            if (trackingEndCnt > 0 && totalCnt == procTotalCnt && endCnt == 0) {
                                log.info("MN-R: Tracking End : sendId {} trackingEndCnt {} totalCnt {} procTotalCnt {} endCnt {}", new Object[]{SEND_ID, trackingEndCnt, totalCnt, procTotalCnt, endCnt});
                                this.updateSendInfo(rsm, "43");
                                ++workingSize;
                                continue;
                            }
                            if (currentStatus.equals("31")) {
                                log.info("MN-R: this Target result send_id=[{}] skiped Job_status={} SCHD_STATE_SEND_CANCEL_REQ ", (Object)SEND_ID, (Object)currentStatus);
                                continue;
                            }
                            log.info("MN-R: 1 this Target result send_id=[{}] skiped Job_status={}", (Object)SEND_ID, (Object)currentStatus);
                            continue;
                        }
                        log.info("MN-R: 2 this Target result send_id=[{}] skiped Job_status={}", (Object)SEND_ID, (Object)currentStatus);
                        continue;
                    }
                    log.info("MN-R: 3 this Target result send_id=[{}] skiped Job_status={}", (Object)SEND_ID, (Object)currentStatus);
                    continue;
                }
                log.info("MN-R: 4 this Target result send_id=[{}] skiped Job_status={}", (Object)SEND_ID, (Object)currentStatus);
            }
            catch (Exception e) {
                log.error("MN-R: sendId:{}, Exception : {}", (Object)SEND_ID, (Object)e);
            }
            finally {
                if (lockController != null) {
                    lockController.unLock();
                }
                log.info("MN-R: send_id=[{}] unLocked ", (Object)SEND_ID);
            }
        }
        if (sendList != null) {
            sendList.clear();
            sendList = null;
        }
    }

    public int updateSendInfo(ResultSendInfoModel rsm, String jobstate) {
        if (this.sendDao.countSendInfoByJobStatus(rsm.getSendId(), rsm.getCurrentStatus()) < 1) {
            return 0;
        }
        Object updateJobstatus = null;
        switch (jobstate) {
            case "31": {
                this.sendBasicService.sendResult31Process(rsm);
                break;
            }
            case "32": {
                this.sendBasicService.sendResult32Process(rsm);
                break;
            }
            case "38": {
                this.sendBasicService.sendResult38Process(rsm);
                break;
            }
            case "40": {
                this.sendBasicService.sendResult40Process(rsm);
                break;
            }
            case "41": {
                this.sendBasicService.sendResult41Process(rsm);
                break;
            }
            case "42": {
                this.sendBasicService.sendResult42Process(rsm);
                break;
            }
            case "43": {
                this.sendBasicService.sendResult43Process(rsm);
                break;
            }
            case "10": {
                this.sendBasicService.sendResult10Process(rsm);
                break;
            }
        }
        long startDb = System.currentTimeMillis();
        int result = this.sendDao.updateSendInfoJobState(rsm.getSendId(), jobstate);
        long endDb = System.currentTimeMillis();
        if (result > 0) {
            log.info("MN-R: [QUERY] updateSendInfo sendId:{} currentStatus{}, changeJobStatus:{} ============[{}] seconds", new Object[]{rsm.getSendId(), rsm.getCurrentStatus(), jobstate, (double)(endDb - startDb) / 1000.0});
        }
        return result;
    }

    public boolean isCanceled(ResultSendInfoModel rsm) {
        if (rsm.getUpdateDate() == null) {
            return false;
        }
        return Long.parseLong(rsm.getUpdateDate()) + 10L < Long.parseLong(DateUtil.getFullDateDefaultFormat());
    }
}

