/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.schedule;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.Column;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.manager.repository.dao.ABTestDao;
import com.humuson.tms.manager.repository.model.ABTestModel;
import com.humuson.tms.manager.util.LockCheckerUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="tms.manager.proc-abTest", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ResultABTestScheduler {
    private static final Logger log = LoggerFactory.getLogger(ResultABTestScheduler.class);
    @Autowired
    private LockContexter contexter;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    ABTestDao aBTestDao;
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Value(value="${tms.manager.proc-abTest.send-use}")
    private String abTestUseFlag;
    @Autowired
    LockCheckerUtil lockCheckerUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelayString="${tms.manager.proc-abTest.interval}")
    public void schedule() {
        String lockResult = this.lockCheckerUtil.isAnyLocked();
        if (lockResult != null && !lockResult.trim().isEmpty()) {
            log.info("[SCHEDULER] {}", (Object)lockResult);
            return;
        }
        LockController lockController = this.contexter.lock("lock.manager.result.abTest");
        if (lockController.isLocked()) {
            log.info("[SCHEDULER] this schedule is locked. lock key[{}]", (Object)"lock.manager.result.abTest");
            return;
        }
        lockController.lock();
        long start = System.currentTimeMillis();
        long workingSize = 0L;
        List<Map<String, Object>> abTestList = this.aBTestDao.selectABTarget();
        if (abTestList == null || abTestList.size() == 0) {
            log.debug("has not target schedule !");
        } else {
            log.debug("target Send Data's size : {}  ", (Object)abTestList.size());
            long sendAddId = 0L;
            workingSize = abTestList.size();
            try {
                for (Map<String, Object> abTestTarget : abTestList) {
                    sendAddId = Long.parseLong(abTestTarget.get(Column.SEND_ADD_ID).toString());
                    log.info("AB TEST RESULT => sendAddId {}", (Object)sendAddId);
                    List<ABTestModel> targetABTestModel = this.aBTestDao.selectABTargetData(sendAddId);
                    ABTestModel firstABModel = new ABTestModel();
                    ABTestModel secondABModel = new ABTestModel();
                    for (ABTestModel abTestModel : targetABTestModel) {
                        if (firstABModel.getAbType() == null) {
                            firstABModel = abTestModel;
                        } else {
                            secondABModel = abTestModel;
                        }
                        firstABModel = this.CalOfcustMesModelRate(firstABModel, secondABModel);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("AB TEST RESULT MODEL=> ABModel {}", (Object)firstABModel);
                    }
                    if (this.aBTestDao.updateABTestResult(firstABModel.getAbType(), firstABModel.getSendAddId()) <= 0) continue;
                    String reqDate = null;
                    reqDate = ResultABTestScheduler.createCrlstTime(firstABModel.getInterValMinute());
                    if (this.aBTestDao.updateSendInfoABData(firstABModel.getContentId(), reqDate, firstABModel.getPSendId()) <= 0) continue;
                    this.aBTestDao.updateSchdInfoABData(firstABModel.getContentId(), reqDate, firstABModel.getPSendId());
                }
            }
            catch (Exception e) {
                log.error("Exception : {}", (Throwable)e);
            }
            finally {
                if (abTestList != null) {
                    abTestList.clear();
                    abTestList = null;
                }
            }
        }
        if (lockController != null) {
            lockController.unLock();
        }
        long end = System.currentTimeMillis();
        log.info("[SCHEDULER] END worked:{} [{}] seconds", (Object)workingSize, (Object)((double)(end - start) / 1000.0));
    }

    public ABTestModel CalOfcustMesModelRate(ABTestModel firstModel, ABTestModel secondModel) {
        double firstRate = 0.0;
        double secondRate = 0.0;
        boolean mainTrCnt = false;
        if (firstModel.getCompareType().equals("O")) {
            firstRate = (double)firstModel.getOpenCnt() / (double)firstModel.getSuccessCnt() * 100.0;
            secondRate = (double)secondModel.getOpenCnt() / (double)secondModel.getSuccessCnt() * 100.0;
        } else if (firstModel.getCompareType().equals("C")) {
            firstRate = (double)firstModel.getClickCnt() / (double)firstModel.getSuccessCnt() * 100.0;
            secondRate = (double)secondModel.getClickCnt() / (double)secondModel.getSuccessCnt() * 100.0;
        }
        firstRate = (double)Math.round(firstRate * 10.0) / 10.0;
        secondRate = (double)Math.round(secondRate * 10.0) / 10.0;
        if (firstRate >= secondRate) {
            firstModel.setCalRate(firstRate);
            return firstModel;
        }
        secondModel.setCalRate(secondRate);
        return secondModel;
    }

    public static String createCrlstTime(int intervalMin) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar c = Calendar.getInstance();
        Date d = new Date();
        c.setTime(d);
        c.add(12, intervalMin);
        return sdf.format(c.getTime());
    }
}

