/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log.sample;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TailAssertor {
    private static final Logger log = LoggerFactory.getLogger(TailAssertor.class);
    private static final long sec = 1000L;
    private static long sampleInterval = 5000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void assertNewLinesWithTail(File logfile, String expectedLine, int durationInSec) {
        RandomAccessFile file;
        block11: {
            block10: {
                long filePointer = logfile.length();
                file = null;
                try {
                    file = new RandomAccessFile(logfile, "r");
                    Date startTime = new Date();
                    while (new Date().getTime() - startTime.getTime() < (long)durationInSec * 1000L) {
                        long fileLength = logfile.length();
                        if (fileLength < filePointer) {
                            file = new RandomAccessFile(logfile, "r");
                            filePointer = 0L;
                        }
                        if (fileLength > filePointer) {
                            file.seek(filePointer);
                            String line = file.readLine();
                            while (line != null) {
                                if (!line.contains(expectedLine)) {
                                    line = file.readLine();
                                    continue;
                                }
                                break block10;
                            }
                            filePointer = file.getFilePointer();
                        }
                        Thread.sleep(sampleInterval);
                    }
                    break block11;
                }
                catch (Exception e) {
                    try {
                        log.error("{}", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        TailAssertor.closeFile(file);
                        throw throwable;
                    }
                    TailAssertor.closeFile(file);
                    throw new AssertionError((Object)"the requested line wasn't found within the required time frame!");
                }
            }
            TailAssertor.closeFile(file);
            return;
        }
        TailAssertor.closeFile(file);
        throw new AssertionError((Object)"the requested line wasn't found within the required time frame!");
    }

    private static void closeFile(RandomAccessFile file) {
        if (file != null) {
            try {
                file.close();
            }
            catch (IOException e) {
                log.error("{}", (Throwable)e);
            }
        }
    }
}

