/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log;

import com.humuson.tms.adaptor.jdbc.mybatis.TmsBatchSqlExecutor;
import com.humuson.tms.config.Column;
import com.humuson.tms.config.Constants;
import com.humuson.tms.crypto.BASE64;
import com.humuson.tms.manager.monitor.log.FileEventListener;
import com.humuson.tms.manager.monitor.log.LogFileTailerListener;
import com.humuson.tms.manager.repository.dao.TrackingLogDao;
import com.humuson.tms.manager.repository.model.SendListModel;
import com.humuson.tms.manager.repository.model.TrackingVo;
import com.humuson.tms.util.chunk.ChunkCycleCountExecutor;
import com.humuson.tms.util.chunk.ChunkExecutor;
import com.humuson.tms.util.date.DateUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="TrackingLogFileTailerListener")
public class TrackingLogFileTailerListener
extends LogFileTailerListener {
    private static final Logger log = LoggerFactory.getLogger(TrackingLogFileTailerListener.class);
    @Autowired
    @Qualifier(value="TrackingLogFileEventListener")
    FileEventListener trackingLogFileEventListener;
    @Autowired
    TrackingLogDao trackingLogDao;
    @Autowired
    TmsBatchSqlExecutor<TrackingVo> sqlExecutor;
    @Autowired
    TmsBatchSqlExecutor<SendListModel> sqlSendListExecutor;
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Set<String> trackingVoMethodName = new HashSet<String>();
    @Value(value="${tms.manager.monitor.tracking.enable:false}")
    private boolean trackingEnable;
    ChunkExecutor chunkExecutor = new ChunkExecutor(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            TrackingLogFileTailerListener.this.lock.readLock().lock();
            try {
                if (TrackingLogFileTailerListener.this.targetInfos.isEmpty()) {
                    return;
                }
                long start = System.currentTimeMillis();
                TrackingLogFileTailerListener.this.sqlSendListExecutor.batchUpdate("insertSendListTracking", TrackingLogFileTailerListener.this.targetInfos, false);
                long end = System.currentTimeMillis();
                log.info("[QUERY] batch insertSendListTracking size {} END ============[{}] seconds", (Object)TrackingLogFileTailerListener.this.targetInfos.size(), (Object)((double)(end - start) / 1000.0));
            }
            catch (Exception e) {
                log.warn("MN1401|Bulk insert Error : SendListTracking. {}", (Throwable)e);
                for (SendListModel info : TrackingLogFileTailerListener.this.targetInfos) {
                    TrackingLogFileTailerListener.this.singleUpdate(info);
                }
            }
            finally {
                TrackingLogFileTailerListener.this.targetInfos.clear();
                TrackingLogFileTailerListener.this.lock.readLock().unlock();
            }
        }
    };
    List<TrackingVo> trackingVos = new ArrayList<TrackingVo>();
    List<SendListModel> targetInfos = new ArrayList<SendListModel>();

    @PostConstruct
    public void initinal() {
        if (!this.trackingEnable) {
            return;
        }
        this.p = Pattern.compile(this.fileLineParsePattern());
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
        new ChunkCycleCountExecutor(this.chunkExecutor, 300, 500).start();
        this.registMethodName();
    }

    private void registMethodName() {
        Method[] methods;
        TrackingVo vo = new TrackingVo();
        for (Method m : methods = vo.getClass().getMethods()) {
            this.trackingVoMethodName.add(m.getName());
        }
    }

    @Override
    protected String fileLineParsePattern() {
        return this.defaultParsePattern;
    }

    @Override
    FileEventListener fileEventListener() {
        return this.trackingLogFileEventListener;
    }

    @Override
    boolean isReadApplyPattern(String line) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void workingJob(String line) {
        SendListModel target = null;
        if (line != null || line != "") {
            try {
                target = this.parsingLine(line);
            }
            catch (Exception e) {
                return;
            }
        }
        if (target != null && target.getChannelType() != null) {
            try {
                this.lock.writeLock().lock();
                this.targetInfos.add(target);
            }
            catch (Exception e) {
                log.error("MN1404|Target List Up Error : writeLock & add target", (Throwable)e);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private void singleUpdate(TrackingVo info) {
        try {
            if (this.trackingLogDao.insertSendListTracking(info) != 1) {
                log.warn(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>failed insertSendListTracking file[{}] skip..", (Object)info);
            }
        }
        catch (Exception e) {
            log.error("MN1402|Single insert Error : SendListTracking.{}", (Throwable)e);
        }
    }

    private void singleUpdate(SendListModel info) {
        try {
            if (this.trackingLogDao.insertSendListTracking(info) != 1) {
                log.warn(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>failed insertSendListTracking file[{}] skip..", (Object)info);
            }
        }
        catch (Exception e) {
            log.error("MN1402|Single insert Error : SendListTracking.{}, {}", (Object)info, (Object)e);
        }
    }

    public TrackingVo parsing(String line) {
        if (StringUtils.isEmpty((CharSequence)line) || line.length() < 20) {
            return null;
        }
        String currentDate = DateUtil.getFullDate((String)"yyyyMMdd");
        List params = URLEncodedUtils.parse((String)line, (Charset)StandardCharsets.UTF_8);
        return this.paramsToVo(params);
    }

    private TrackingVo paramsToVo(List<NameValuePair> params) {
        TrackingVo vo = new TrackingVo();
        for (NameValuePair param : params) {
            try {
                String setMethodName = "set" + param.getName();
                if (!this.trackingVoMethodName.contains(setMethodName)) continue;
                Method method = TrackingVo.class.getMethod(setMethodName, String.class);
                method.invoke((Object)vo, param.getValue());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
        }
        if (vo.getTYPE().equals(Constants.EventType.C.toString())) {
            vo.setCODE_DETAIL(vo.getCLICK_ID());
        } else if (vo.getTYPE().equals(Constants.EventType.O.toString())) {
            if (StringUtils.isEmpty((CharSequence)vo.getOPEN_ID())) {
                vo.setCODE_DETAIL("01");
            } else {
                vo.setCODE_DETAIL(vo.getOPEN_ID());
            }
        }
        if (vo.getCHANNEL_TYPE().equals("EM")) {
            vo.setMEMBER_ID(BASE64.decode((String)vo.getMEMBER_ID()));
        }
        return vo;
    }

    public SendListModel parsingLine(String line) throws Exception {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        new SendListModel();
        SendListModel.SendListModelBuilder infoBulider = SendListModel.builder();
        if (!line.equals("") || line != null) {
            String channelType = null;
            String[] targetValue = line.split("\\&");
            boolean checkTrackingYn = true;
            String type = null;
            for (String param : targetValue) {
                try {
                    int idx = param.indexOf("=");
                    String name = param.substring(0, idx);
                    String value = param.substring(idx + 1, param.length());
                    map.put(name.trim(), value.trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (map.size() == 0) {
                throw new Exception("parsed mapSize is zero");
            }
            if (line.indexOf(Column.TRACKING_CLOSE) < 0 || map.get(Column.TRACKING_CLOSE) == null || !map.containsKey(Column.TRACKING_CLOSE) || ((String)map.get(Column.TRACKING_CLOSE)).length() > 10) {
                throw new Exception("TRACKING_CLOSE is invalid.");
            }
            if (line.contains(Column.CHANNEL_TYPE)) {
                channelType = line.substring(line.indexOf(Column.CHANNEL_TYPE) + 13, line.indexOf("&"));
                map.put(Column.CHANNEL_TYPE, channelType);
            }
            type = map.get("TYPE") != null ? ((String)map.get("TYPE")).toUpperCase() : "O";
            if (checkTrackingYn && type != null && channelType != null) {
                infoBulider = SendListModel.builder();
                infoBulider.eventType(type);
                infoBulider.channelType(channelType);
                if (map.get("TODAY") != null) {
                    infoBulider.eventTime(((String)map.get("TODAY")).trim());
                }
                if (map.get(Column.WORKDAY) != null) {
                    infoBulider.workday(((String)map.get(Column.WORKDAY)).trim());
                }
                if (map.get(Column.SITE_ID) != null) {
                    infoBulider.siteId(((String)map.get(Column.SITE_ID)).trim());
                }
                if (map.get(Column.SCHD_ID) != null) {
                    infoBulider.schdId(Long.parseLong(((String)map.get(Column.SCHD_ID)).trim()));
                }
                if (map.get(Column.SEND_ID) != null) {
                    infoBulider.sendId(Long.parseLong(((String)map.get(Column.SEND_ID)).trim()));
                }
                if (type.equals(Constants.EventType.C.toString())) {
                    if (map.get("CLICK_ID") != null) {
                        infoBulider.codeDetail(((String)map.get("CLICK_ID")).trim());
                    }
                } else if (type.equals(Constants.EventType.O.toString())) {
                    if (map.get("OPEN_ID") != null) {
                        infoBulider.codeDetail(((String)map.get("OPEN_ID")).trim());
                    } else {
                        infoBulider.codeDetail("01");
                    }
                }
                if (map.get(Column.MEMBER_ID) != null) {
                    if (channelType.equals("EM")) {
                        infoBulider.memberId(BASE64.decode((String)((String)map.get(Column.MEMBER_ID)).trim()));
                    } else {
                        infoBulider.memberId(((String)map.get(Column.MEMBER_ID)).trim());
                    }
                }
                if (map.get("MEMBER_ID_SEQ") != null) {
                    infoBulider.memberIdSeq(((String)map.get("MEMBER_ID_SEQ")).trim());
                }
                if (map.get("OS") != null) {
                    infoBulider.eventInfo1(((String)map.get("OS")).trim());
                }
                if (map.get("BROWSER") != null) {
                    infoBulider.eventInfo2(((String)map.get("BROWSER")).trim());
                }
                if (map.get("OS_TYPE") != null) {
                    infoBulider.eventInfo3(((String)map.get("OS_TYPE")).trim());
                }
                if (map.get(Column.TMA_REQ_UID) != null) {
                    infoBulider.eventInfo4(((String)map.get(Column.TMA_REQ_UID)).trim());
                }
                if (map.get(Column.EVENT_INFO5) != null) {
                    infoBulider.eventInfo5(((String)map.get(Column.EVENT_INFO5)).trim());
                }
            }
        }
        if (infoBulider == null) {
            throw new Exception("infoBulider is null.");
        }
        if (infoBulider.build().getChannelType() == null || infoBulider.build().getChannelType().isEmpty() || infoBulider.build().getChannelType().length() > 2) {
            throw new Exception("CHANNEL_TYPE is invalid");
        }
        if (infoBulider.build().getWorkday() == null || infoBulider.build().getWorkday().isEmpty() || !StringUtils.isNumeric((CharSequence)String.valueOf(infoBulider.build().getWorkday())) || infoBulider.build().getWorkday().length() > 8) {
            throw new Exception("WORKDAY is invalid");
        }
        if (infoBulider.build().getMemberId() == null || infoBulider.build().getMemberId().isEmpty() || infoBulider.build().getMemberId().length() > 150) {
            throw new Exception("MEMBER_ID is invalid");
        }
        if (infoBulider.build().getMemberIdSeq() == null || infoBulider.build().getMemberIdSeq().isEmpty() || !StringUtils.isNumeric((CharSequence)String.valueOf(infoBulider.build().getMemberIdSeq())) || infoBulider.build().getMemberIdSeq().length() > 20) {
            throw new Exception("MEMBER_ID_SEQ is invalid");
        }
        if (infoBulider.build().getEventTime() == null || infoBulider.build().getEventTime().isEmpty() || infoBulider.build().getEventTime().length() > 20) {
            throw new Exception("EVENT_TIME is invalid");
        }
        if (infoBulider.build().getSchdId() == null || !StringUtils.isNumeric((CharSequence)String.valueOf(infoBulider.build().getSchdId())) || infoBulider.build().getSchdId() < 0L) {
            throw new Exception("SCHD_ID is invalid");
        }
        if (infoBulider.build().getSendId() == null || !StringUtils.isNumeric((CharSequence)String.valueOf(infoBulider.build().getSendId())) || infoBulider.build().getSendId() < 0L) {
            throw new Exception("SEND_ID is invalid");
        }
        if (infoBulider.build().getEventType() == null || infoBulider.build().getEventType().isEmpty() || infoBulider.build().getMemberIdSeq().length() > 10) {
            throw new Exception("EVENT_TYPE is invalid");
        }
        return infoBulider.build();
    }

    public static void main(String[] args) {
    }
}

