/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log;

import com.humuson.tms.manager.monitor.log.FileTailerListener;
import com.humuson.tms.manager.monitor.log.LogFileTailerListener;
import com.humuson.tms.manager.monitor.log.SimpleLogFileEventListener;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="TrackingLogFileEventListener")
public class TrackingLogFileEventListener
extends SimpleLogFileEventListener {
    private static final Logger log = LoggerFactory.getLogger(TrackingLogFileEventListener.class);
    @Value(value="${tms.manager.monitor.tracking.log.work}")
    private String workDirectory;
    @Value(value="${tms.manager.monitor.tracking.log.backup:}")
    private String backupDirectory;
    @Value(value="${tms.manager.monitor.tracking.enable:false}")
    private boolean isTrackingEnable;
    @Autowired
    @Qualifier(value="TrackingLogFileTailerListener")
    LogFileTailerListener trackingLogFileTailerListener;

    @Override
    public FileTailerListener fileTailerListener() {
        return this.trackingLogFileTailerListener;
    }

    @Override
    String getFileNamePrefix() {
        return "^R[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9].[0-9].log$";
    }

    @Override
    public String workDirectory() {
        try {
            this.setAsExecutable(this.workDirectory);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.workDirectory;
    }

    @Override
    public String backupDirectory() {
        if (this.backupDirectory.isEmpty()) {
            this.backupDirectory = this.createDefaultBackupDirectory(this.workDirectory);
        } else if (!new File(this.backupDirectory).exists() && !new File(this.backupDirectory).mkdirs()) {
            log.error("1591| don't create backup directory[{}]", (Object)this.backupDirectory);
        }
        return this.backupDirectory;
    }
}

