/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log;

import com.humuson.tms.manager.monitor.log.FinishFileController;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MoveFileController
implements FinishFileController {
    private static final Logger log = LoggerFactory.getLogger(MoveFileController.class);
    protected Logger logger = LoggerFactory.getLogger((String)"trackingTraceLog");
    private static final String ER = ".er";

    @Override
    public void finish(File orgFile, File destFile) {
        try {
            if (destFile.exists()) {
                if (orgFile.length() != destFile.length()) {
                    log.warn("The source[{}] and destination[{}] files are different.so source file move it with an extension[.er].", (Object)orgFile.getName(), (Object)destFile.getName());
                    File erFile = new File(orgFile.getAbsolutePath() + ER);
                    if (erFile.exists()) {
                        log.warn("this ER file[{}] is exist. so skip..", (Object)erFile.getName());
                        return;
                    }
                    Files.move(orgFile.toPath(), orgFile.toPath().resolveSibling(erFile.getAbsolutePath()), new CopyOption[0]);
                }
                return;
            }
            Files.move(orgFile.toPath(), orgFile.toPath().resolveSibling(destFile.getAbsolutePath()), new CopyOption[0]);
        }
        catch (Exception e) {
            this.logger.error("MN1513| file move error. so dest file[{}] delete. org file[{}], error:{}", new Object[]{destFile.getAbsolutePath(), orgFile.getAbsolutePath(), e});
            try {
                new FileWriter(destFile).close();
                FileUtils.forceDelete((File)destFile);
            }
            catch (IOException e2) {
                this.logger.error("MN1580| dest file[{}] creating error, error:{}", (Object)destFile, (Object)e2);
            }
        }
    }

    public static void main(String[] args) {
        File o = new File("E:/test/euckr.txt");
        File d = new File("E:/test/temp/euckr.txt");
        new MoveFileController().finish(o, d);
    }
}

