/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log;

import com.humuson.tms.config.ClassDispatcher;
import com.humuson.tms.manager.monitor.log.ControllerBackupFile;
import com.humuson.tms.manager.monitor.log.ControllerLogBackupFile;
import com.humuson.tms.manager.monitor.log.FileEventListener;
import com.humuson.tms.manager.monitor.log.FileEventer;
import com.humuson.tms.manager.monitor.log.FileTailer;
import com.humuson.tms.manager.monitor.log.FileTailerListener;
import com.humuson.tms.manager.util.LockCheckerUtil;
import com.humuson.tms.util.FileUtil;
import java.io.File;
import java.nio.file.Files;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class LogFileTailerListener
implements FileTailerListener,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(LogFileTailerListener.class);
    protected Logger logger = LoggerFactory.getLogger((String)"trackingTraceLog");
    protected FileTailer tailer;
    protected Queue<FileEventer> fileEventerQueue = new LinkedList<FileEventer>();
    @Autowired
    private ControllerBackupFile controllerLogBackupFile;
    protected String defaultParsePattern = "^\\[.*\\]\\s\\[.*\\]\\s\\[WARN|ERROR\\]\\s\\[.*\\]\\s\\:\\s[CM|MN|DS|CT|MP|SD\\d{4}\\|]";
    protected Pattern p;
    int errCount = 0;
    public static final String ING = ".ing";
    public boolean running = true;
    private String workDirectory;
    private String backupDirectory;
    @Autowired
    LockCheckerUtil lockCheckerUtil;
    boolean isLocked = false;

    public void stop() {
        this.running = false;
    }

    @Override
    public void init(FileTailer tailer) {
        this.tailer = tailer;
    }

    @Override
    public void fileNotFound() {
        this.logger.error("CM0100| system error. this file[{}] not found", (Object)this.tailer.getFile());
    }

    @Override
    public void fileRotated() {
        this.logger.debug("file[{}] retated ", (Object)this.tailer.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String line, long position) {
        try {
            LogFileTailerListener logFileTailerListener = this;
            synchronized (logFileTailerListener) {
                if (this.isReadApplyPattern(line)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("file[{}] position[{}] read line[" + position + "] : ", new Object[]{this.tailer.getFile(), position, line});
                    }
                    this.writeBackupPosition(this.tailer.getFile(), position);
                    this.workingJob(line);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("error working job control file[{}] position[{}] line[{}] next continue..", new Object[]{this.tailer.getFile(), position, line, e});
        }
        finally {
            this.writeBackupPosition(this.tailer.getFile(), position + (long)line.getBytes().length + 1L);
        }
    }

    @Override
    public void handle(Exception ex) {
        this.logger.error("file[{}] read line error", (Object)this.tailer.getFile(), (Object)ex);
    }

    @Override
    public void endOfFileReached() {
        this.logger.info("this file[{}] end of file reached.", (Object)this.tailer.getFile());
        this.tailer.stop();
        this.controllerLogBackupFile.finish();
    }

    @Override
    public boolean isPossibleNextFile(String fileName) {
        if (this.tailer == null) {
            return true;
        }
        while (this.tailer.getRun()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                this.logger.error("CM0100| thread intrupted error", (Throwable)e);
            }
        }
        return true;
    }

    @Override
    public Queue<FileEventer> getFileQueue() {
        return this.fileEventerQueue;
    }

    @Override
    public boolean finishedFilter(FileEventListener eventListener, FileEventer eventer) {
        String backupFileDirName = eventListener.backupDirectory();
        File backupFileDir = new File(backupFileDirName);
        if (backupFileDir.exists()) {
            String fullPathFileName = this.getFullFileName(eventer.getFileName());
            Collection backupIngFiles = FileUtils.listFiles((File)backupFileDir, (String[])new String[]{"ing"}, (boolean)false);
            String backupIngFile = this.isWorkingFile(backupIngFiles, eventer.getFileName());
            if (backupIngFile != null) {
                this.ifWorkingFileThenSetLastPosition(eventer, backupIngFile);
                this.logger.debug("working log file[{}] setting last position[{}]", (Object)eventer.getFileName(), (Object)eventer.getEndPosition());
                return false;
            }
            if (new File(backupFileDir, eventer.getFileName()).exists()) {
                return true;
            }
        }
        return false;
    }

    private String isWorkingFile(Collection<File> backupIngFiles, String jobFile) {
        String compareFile = jobFile + ING;
        for (File ingFile : backupIngFiles) {
            if (!compareFile.equals(ingFile.getName())) continue;
            return ingFile.getName();
        }
        return null;
    }

    private File getFullFile(String fileName) {
        if (this.workDirectory == null || this.workDirectory.isEmpty()) {
            this.workDirectory = this.fileEventListener().workDirectory();
        }
        return new File(FileUtil.lastSeparator((String)this.workDirectory) + fileName);
    }

    private File getBackupFullFile(String fileName) {
        if (this.backupDirectory == null || this.backupDirectory.isEmpty()) {
            this.backupDirectory = this.fileEventListener().backupDirectory();
        }
        return new File(FileUtil.lastSeparator((String)this.backupDirectory) + fileName);
    }

    private String getFullFileName(String fileName) {
        if (this.workDirectory == null || this.workDirectory.isEmpty()) {
            this.workDirectory = this.fileEventListener().workDirectory();
        }
        return FileUtil.lastSeparator((String)this.workDirectory) + fileName;
    }

    private void ifWorkingFileThenSetLastPosition(FileEventer eventer, String backupIngFile) {
        long last = 0L;
        try {
            File workingFile = this.getBackupFullFile(backupIngFile);
            String contents = new String(Files.readAllBytes(workingFile.toPath()));
            String[] lineText = contents.split("\n");
            if (lineText.length < 2) {
                if (lineText[0].trim().isEmpty()) {
                    return;
                }
                eventer.setEndPosition(Long.parseLong(lineText[0].trim()));
            } else {
                long preLast = Long.parseLong(lineText[lineText.length - 2].trim());
                last = Long.parseLong(lineText[lineText.length - 1].trim());
                eventer.setEndPosition(last >= preLast ? last : preLast);
            }
        }
        catch (Exception e) {
            this.logger.error("MN1512| error search file[{}] last position. file:{}, error:{}", (Object)this.getFullFileName(eventer.getFileName()), (Object)e);
        }
    }

    private void createControllerBackupFile(File file, boolean append) {
        if (this.controllerLogBackupFile == null) {
            try {
                this.controllerLogBackupFile = (ControllerBackupFile)ClassDispatcher.getApplicationContext().getBean(ControllerLogBackupFile.class);
                this.controllerLogBackupFile.init(new File(this.getBackupFullFile(file.getName()) + ING), append);
            }
            catch (Exception e) {
                this.logger.error("MN1509| don't create backup file init({})", (Object)file.getName(), (Object)e);
                return;
            }
        }
    }

    private void writeBackupPosition(File file, long position) {
        try {
            this.controllerLogBackupFile.writePosition(position);
        }
        catch (Exception e) {
            this.controllerLogBackupFile.init(file, position != 0L);
            if (this.errCount++ < 10) {
                this.writeBackupPosition(file, position);
            }
            this.logger.error("MM1561| write backup position error(10) backupfile[{}]", (Object)file, (Object)e);
            throw e;
        }
    }

    @Override
    public void run() {
        while (this.running) {
            String lockResult = this.lockCheckerUtil.isTrackingAnyLocked();
            if (lockResult != null && !lockResult.trim().isEmpty()) {
                if (this.isLocked) continue;
                this.logger.info("[SCHEDULER] {}", (Object)lockResult);
                this.isLocked = true;
                continue;
            }
            this.isLocked = false;
            String fileName = null;
            try {
                FileEventer eventer = this.fileEventerQueue.poll();
                if (eventer == null) {
                    Thread.sleep(1000L);
                    continue;
                }
                fileName = eventer.getFileName();
                if (this.isPossibleNextFile(fileName)) {
                    boolean append;
                    if (this.tailer != null) {
                        this.tailer.stop();
                    }
                    boolean bl = append = eventer.getEndPosition() != 0L;
                    if (this.controllerLogBackupFile == null) {
                        this.createControllerBackupFile(this.getBackupFullFile(fileName), append);
                    }
                    this.controllerLogBackupFile.init(new File(this.getBackupFullFile(fileName) + ING), append);
                    this.tailer = new FileTailer(this.getFullFile(fileName), this, 100L);
                    if (eventer.getEndPosition() != 0L) {
                        this.tailer.setReadPosition(eventer.getEndPosition());
                    }
                    this.tailer.readingFileLine();
                    continue;
                }
                this.logger.warn("this file[{}] read skip...", (Object)fileName);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("MN1551| read file[{}] line error. continue..", (Object)fileName, (Object)e);
            }
        }
    }

    abstract FileEventListener fileEventListener();

    protected abstract String fileLineParsePattern();

    abstract boolean isReadApplyPattern(String var1);

    abstract void workingJob(String var1);
}

