/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log;

import com.humuson.tms.manager.monitor.log.FileEventListener;
import com.humuson.tms.manager.monitor.log.FileEventer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public abstract class LogFileEventListener
implements FileEventListener {
    private static final Logger log = LoggerFactory.getLogger(LogFileEventListener.class);
    protected Logger logger = LoggerFactory.getLogger((String)"trackingTraceLog");
    protected Pattern p = null;
    private BlockingQueue<FileEventer> queue = new ArrayBlockingQueue<FileEventer>(30000);
    @Value(value="${tms.manager.monitor.file.event.exist.enable:true}")
    private boolean exist;
    @Value(value="${tms.manager.monitor.file.event.modify.enable:false}")
    private boolean modify;
    @Value(value="${tms.manager.monitor.file.event.create.enable:true}")
    private boolean create;
    @Value(value="${tms.manager.monitor.file.event.delete.enable:false}")
    private boolean delete;

    @Override
    public boolean isExistListen() {
        return this.exist;
    }

    @Override
    public boolean isCreateListen() {
        return this.create;
    }

    @Override
    public boolean isDeleteListen() {
        return this.delete;
    }

    @Override
    public boolean isModifyListen() {
        return this.modify;
    }

    @Override
    public BlockingQueue<FileEventer> listenerQueue() {
        return this.queue;
    }

    @Override
    public String[] extensions() {
        return new String[]{"log", "ing"};
    }

    @Override
    public boolean detectFilePattern(String fileName) {
        if (this.p == null) {
            this.p = this.fileNamePattern();
        }
        return this.p.matcher(fileName).find();
    }

    public void setAsExecutable(String filePath) throws IOException {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.GROUP_WRITE);
        perms.add(PosixFilePermission.GROUP_EXECUTE);
        perms.add(PosixFilePermission.OTHERS_READ);
        Files.setPosixFilePermissions(Paths.get(filePath, new String[0]), perms);
    }

    public String createDefaultBackupDirectory(String workDirectory) {
        String backupDirectory = workDirectory + "_backup";
        if (!new File(backupDirectory).exists() && !new File(backupDirectory).mkdirs()) {
            this.logger.error("1591| don't create backup directory[{}]", (Object)backupDirectory);
        }
        try {
            this.setAsExecutable(workDirectory);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error("1591| don't give permission workDirectory[{}]", (Object)workDirectory);
        }
        try {
            this.setAsExecutable(backupDirectory);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error("1591| don't give permission backupDirectory[{}]. e : {}", (Object)backupDirectory, (Object)e);
        }
        return backupDirectory;
    }

    protected abstract Pattern fileNamePattern();
}

