/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log;

import com.humuson.tms.manager.monitor.log.FileTailerListener;
import com.humuson.tms.manager.monitor.log.LogFileTailerListener;
import com.humuson.tms.manager.monitor.log.SimpleLogFileEventListener;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

public class DSLogFileEventListener
extends SimpleLogFileEventListener {
    private static final Logger log = LoggerFactory.getLogger(DSLogFileEventListener.class);
    protected Logger logger = LoggerFactory.getLogger((String)"trackingTraceLog");
    @Value(value="${tms.manager.monitor.ds.log.work}")
    private String workDirectory;
    @Value(value="${tms.manager.monitor.ds.log.backup:}")
    private String backupDirectory;
    @Autowired
    @Qualifier(value="DSLogFileTailerListener")
    LogFileTailerListener dsLogFileTailerListener;

    @Override
    public FileTailerListener fileTailerListener() {
        return this.dsLogFileTailerListener;
    }

    @Override
    String getFileNamePrefix() {
        return "[manager|system][.]((19|20)\\d\\d)?([- /.])?(0[1-9]|1[012])([- /.])?(0[1-9]|[12][0-9]|3[01])\\_\\d[.]log$";
    }

    @Override
    public String workDirectory() {
        return this.workDirectory;
    }

    @Override
    public String backupDirectory() {
        if (this.backupDirectory.isEmpty()) {
            this.backupDirectory = this.createDefaultBackupDirectory(this.workDirectory);
        } else if (!new File(this.backupDirectory).exists() && !new File(this.backupDirectory).mkdirs()) {
            this.logger.error("1591| don't create backup directory[{}]", (Object)this.backupDirectory);
        }
        return this.backupDirectory;
    }
}

