/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log;

import com.humuson.tms.manager.monitor.log.EventType;
import com.humuson.tms.manager.monitor.log.FileEventer;
import com.humuson.tms.util.date.DateUtil;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckerNextFileFormat {
    private static final Logger log = LoggerFactory.getLogger(CheckerNextFileFormat.class);
    protected Logger logger = LoggerFactory.getLogger((String)"trackingTraceLog");
    FileEventer nowFileEventer = null;
    FileEventer nextFileEventer = null;
    private boolean isNextFile = false;
    Pattern p = Pattern.compile("((19|20)\\d\\d)?([- /.])?(0[1-9]|1[012])([- /.])?(0[1-9]|[12][0-9]|3[01])\\_\\d");

    public FileEventer getNowFileEventer() {
        return this.nowFileEventer;
    }

    public FileEventer getNextFileEventer() {
        return this.nextFileEventer;
    }

    public void setNowFileEventer(FileEventer eventer) {
        this.nowFileEventer = eventer;
    }

    public void checker(FileEventer nextFileEventer) {
        if (nextFileEventer == null) {
            return;
        }
        this.nextFileEventer = nextFileEventer;
        if (this.nowFileEventer == null) {
            this.setNowFileEventer(nextFileEventer);
            this.isNextFile = true;
            return;
        }
        if (EventType.EXIST == this.nowFileEventer.getEventType() && EventType.EXIST == nextFileEventer.getEventType()) {
            this.isNextFile = true;
            return;
        }
        if (EventType.CREATE == nextFileEventer.getEventType()) {
            try {
                this.compareNextPattern(nextFileEventer.getFileName(), this.nowFileEventer.getFileName());
            }
            catch (Exception e) {
                this.logger.error("MN3000| next file[{}] parser error so is not next file, error:{} ", (Object)nextFileEventer.getFileName(), (Object)e);
                this.isNextFile = false;
            }
        }
    }

    private void compareNextPattern(String nextFileName, String nowFileName) throws ParseException {
        String yyyymmdddNow = this.patternTextOrNull(nowFileName);
        String yyyymmdddNext = this.patternTextOrNull(nextFileName);
        String yyyymmddFormatOfNextFile = yyyymmdddNow.substring(0, 10).replaceAll("-", "");
        String yyyymmddFormatOfNowFile = yyyymmdddNext.substring(0, 10).replaceAll("-", "");
        String nextDayOfNow = DateUtil.nextDate((String)yyyymmddFormatOfNowFile);
        int nowIndexCount = Integer.parseInt(nowFileName.substring(nowFileName.indexOf("_") + 1, nowFileName.lastIndexOf(".")));
        int nextFirstCount = Integer.parseInt(nextFileName.substring(nextFileName.indexOf("_") + 1, nextFileName.lastIndexOf(".")));
        if (nextDayOfNow.equals(yyyymmddFormatOfNextFile) && nextFirstCount == 0) {
            this.isNextFile = true;
            return;
        }
        if (yyyymmddFormatOfNowFile.equals(yyyymmddFormatOfNextFile) && nextFirstCount == nowIndexCount + 1) {
            this.isNextFile = true;
            return;
        }
        this.isNextFile = false;
        return;
    }

    private String patternTextOrNull(String orgText) {
        Matcher matcher = this.p.matcher(orgText);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return null;
    }

    private boolean notFindPattern(Matcher nowMatcher, Matcher nextMatcher) {
        return !nowMatcher.find() || !nextMatcher.find();
    }

    public boolean isNextFile() {
        return this.isNextFile;
    }
}

