/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log;

import com.humuson.tms.manager.monitor.log.FinishFileController;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ChangeFileNameController
implements FinishFileController {
    private static final Logger log = LoggerFactory.getLogger(ChangeFileNameController.class);
    protected Logger logger = LoggerFactory.getLogger((String)"trackingTraceLog");

    @Override
    public void finish(File orgFile, File destFile) {
        try {
            Files.move(orgFile.toPath(), orgFile.toPath().resolveSibling(destFile.getAbsolutePath()), new CopyOption[0]);
        }
        catch (Exception e) {
            this.logger.error("MN1513| file rename error. so dest file[{}] creating and org file delete. org file[{}], error:{}", new Object[]{destFile.getAbsolutePath(), orgFile.getAbsolutePath(), e});
            try {
                new FileWriter(destFile).close();
                FileUtils.forceDelete((File)orgFile);
            }
            catch (IOException e2) {
                this.logger.error("MN1580| dest file[{}] creating error, error:{}", (Object)destFile, (Object)e2);
            }
        }
    }
}

