/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.handler;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.manager.result.ResultRedis;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ResultRedisHandler {
    private static final Logger log = LoggerFactory.getLogger(ResultRedisHandler.class);
    @Autowired
    LockContexter contexter;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    @Qualifier(value="emailError")
    Map<String, String> emailErrorCodes;
    @Autowired
    @Qualifier(value="pushError")
    Map<String, String> pushErrorCodes;
    @Autowired
    @Qualifier(value="smsError")
    Map<String, String> smsErrorCodes;
    @Autowired
    @Qualifier(value="bizError")
    Map<String, String> bizErrorCodes;
    @Autowired
    @Qualifier(value="tmsError")
    Map<String, String> tmsErrorCodes;
    @Autowired
    private ResultRedis processResultService;
    @Value(value="${tms.manager.proc-result.row-stand.scan-cnt}")
    private int PROC_MIN_COUNT;
    @Value(value="${tms.manager.proc-result.row-stand.max-cnt}")
    private int PROC_MAX_COUNT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="mnAsyncTask")
    public void process(boolean isOverOfDropIntervalMinute, String CRSLT_CHANNEL_YYYYMMDDHHMI) {
        long start = System.currentTimeMillis();
        LockController lockController = this.contexter.lock("lock.manager.result.handler." + CRSLT_CHANNEL_YYYYMMDDHHMI);
        Map<String, String> fieldAndValueOfCRSLT = new HashMap();
        try {
            lockController.lock();
            fieldAndValueOfCRSLT = this.wrapperRedisTemplate.hscan(CRSLT_CHANNEL_YYYYMMDDHHMI, "", this.PROC_MIN_COUNT, this.PROC_MAX_COUNT);
            if (fieldAndValueOfCRSLT.isEmpty()) {
                if (isOverOfDropIntervalMinute) {
                    this.wrapperRedisTemplate.del(CRSLT_CHANNEL_YYYYMMDDHHMI);
                    log.info("REDIS_CRSLT result key[{}] is time over. so deleted", (Object)CRSLT_CHANNEL_YYYYMMDDHHMI);
                } else {
                    log.warn("crslt key[] is empty of data(field/value).", (Object)CRSLT_CHANNEL_YYYYMMDDHHMI);
                }
                return;
            }
            String[] crsltKeys = CRSLT_CHANNEL_YYYYMMDDHHMI.split(":");
            List<Map<String, String>> mergeCrsltAndTlists = this.makeResultObj(CRSLT_CHANNEL_YYYYMMDDHHMI, fieldAndValueOfCRSLT, crsltKeys[1]);
            if (mergeCrsltAndTlists == null) {
                log.error("Make result object is null. CRSLT[key={}], CRSLTS field/value[{}] ", (Object)CRSLT_CHANNEL_YYYYMMDDHHMI, fieldAndValueOfCRSLT);
                return;
            }
            try {
                if (!mergeCrsltAndTlists.isEmpty()) {
                    log.info("CRSLT[key={}] TO RDB, count[{}] / drop is {} ", new Object[]{CRSLT_CHANNEL_YYYYMMDDHHMI, mergeCrsltAndTlists.size(), isOverOfDropIntervalMinute});
                    this.recordLog(isOverOfDropIntervalMinute, CRSLT_CHANNEL_YYYYMMDDHHMI, mergeCrsltAndTlists);
                } else {
                    log.warn("CRSLT make[crslt+tlist] result object is empty. REDIS_CRSLT[key={}], ", (Object)CRSLT_CHANNEL_YYYYMMDDHHMI);
                }
            }
            catch (Exception e) {
                log.error("failed make result object REDIS_CRSLT[key={}]], error:{}", (Object)CRSLT_CHANNEL_YYYYMMDDHHMI, (Object)e);
            }
            finally {
                if (mergeCrsltAndTlists != null) {
                    mergeCrsltAndTlists.clear();
                }
            }
        }
        catch (Exception e) {
            log.error("REDIS_CRSLT result key={} read error. {}", (Object)CRSLT_CHANNEL_YYYYMMDDHHMI, (Object)e);
        }
        finally {
            if (lockController != null) {
                lockController.unLock();
            }
            if (fieldAndValueOfCRSLT != null) {
                fieldAndValueOfCRSLT.clear();
            }
        }
    }

    private String getChannelFromCRSLT(String[] crsltKeys) {
        return crsltKeys[1];
    }

    public List<Map<String, String>> makeResultObj(String crsltKey, Map<String, String> fieldAndValueOfCRSLT, String CHANNEL_TYPE) {
        Map<Object, Object> errorChannelCode = new HashMap();
        HashMap<String, String> tmsErrorCode = new HashMap();
        if (CHANNEL_TYPE.equals(Constants.ChannelType.EM.toString())) {
            errorChannelCode = this.emailErrorCodes;
        } else if (CHANNEL_TYPE.equals(Constants.ChannelType.SM.toString())) {
            errorChannelCode = this.smsErrorCodes;
        } else if (CHANNEL_TYPE.equals(Constants.ChannelType.PU.toString()) || CHANNEL_TYPE.equals("XP")) {
            errorChannelCode = this.pushErrorCodes;
        } else if (CHANNEL_TYPE.equals(Constants.ChannelType.KA.toString())) {
            errorChannelCode = this.bizErrorCodes;
        }
        tmsErrorCode = this.tmsErrorCodes;
        return this.processResultService.makeResultObj(crsltKey, fieldAndValueOfCRSLT, tmsErrorCode, errorChannelCode);
    }

    public void recordLog(boolean isDel, String crsltKey, List<Map<String, String>> resultMapList) {
        this.processResultService.recordLog(false, crsltKey, resultMapList);
    }
}

