/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.handler;

import com.humuson.tms.adaptor.jdbc.mybatis.TmsBatchSqlExecutor;
import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.Column;
import com.humuson.tms.config.Constants;
import com.humuson.tms.manager.repository.dao.MonitorSendDao;
import com.humuson.tms.manager.repository.dao.ResultDao;
import com.humuson.tms.manager.repository.model.SendListModel;
import com.humuson.tms.manager.repository.model.SprocInfo;
import com.humuson.tms.manager.util.ManagerUtil;
import com.humuson.tms.util.JsonUtil;
import com.humuson.tms.util.date.DateUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class MonitorSendProcessHandler {
    private static final Logger log = LoggerFactory.getLogger(MonitorSendProcessHandler.class);
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    TmsBatchSqlExecutor<SendListModel> sqlExecutor;
    @Autowired
    MonitorSendDao processMonitorSendDao;
    @Autowired
    ResultDao resultDao;
    @Value(value="${tms.manager.monitor.send-process.page-size}")
    private int pageSize;

    @PostConstruct
    public void init() {
    }

    public boolean saveSprocToRepository(SprocInfo sprocInfo, boolean isTimeout) {
        long start = System.currentTimeMillis();
        boolean result = false;
        String daemonType = null;
        try {
            if (!StringUtils.isEmpty((String)sprocInfo.getCT_DAEMON_ID())) {
                daemonType = "CT";
                sprocInfo.setCT_STATUS(this.statusTimeout(sprocInfo.getCT_STATUS(), isTimeout));
                this.processMonitorSendDao.insertSentInfoOfCtSproc(sprocInfo);
            }
            if (!StringUtils.isEmpty((String)sprocInfo.getMPS_DAEMON_ID())) {
                daemonType = "MP";
                sprocInfo.setMPS_STATUS(this.statusTimeout(sprocInfo.getMPS_STATUS(), isTimeout));
                this.processMonitorSendDao.insertSentInfoOfMpsSproc(sprocInfo);
            }
            if (!StringUtils.isEmpty((String)sprocInfo.getMPE_DAEMON_ID())) {
                daemonType = "MP";
                sprocInfo.setMPE_STATUS(this.statusTimeout(sprocInfo.getMPE_STATUS(), isTimeout));
                this.processMonitorSendDao.insertSentInfoOfMpeSproc(sprocInfo);
            }
            result = true;
        }
        catch (Exception e) {
            log.error("[saveSprocToRepository] SPROC INSERT FAIL / sproc={}, error:{}", (Object)sprocInfo, (Object)e);
            result = false;
        }
        long end = System.currentTimeMillis();
        log.debug("[QUERY] insertMoniteSend. sendId:{},schdId:{},targetSeq:{},daemonType:{} END ============[{}] seconds", new Object[]{sprocInfo.getSEND_ID(), sprocInfo.getSCHD_ID(), sprocInfo.getTARGET_SEQ(), daemonType, (double)(end - start) / 1000.0});
        return result;
    }

    public void deleteSprocField(String key, String field) {
        try {
            this.wrapperRedisTemplate.hmdel(key, field);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
        }
    }

    public void deleteSproc(String key) {
        try {
            this.wrapperRedisTemplate.del(key);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
        }
    }

    private String statusTimeout(String status, boolean isTimeout) {
        if (isTimeout && "10".equals(status)) {
            return "90";
        }
        return status;
    }

    @Async(value="mnAsyncTask")
    public void cleanRedisReq(Map<String, String> infoMap, Map<String, String> sprocMap, String sprocKey) {
        long start = System.currentTimeMillis();
        long schdId = Long.parseLong(infoMap.get(Column.SCHD_ID));
        long sendId = Long.parseLong(infoMap.get(Column.SEND_ID));
        log.info("[MonitorSendProcessHandler] cleanRedisReq start {}. sendId:{}, schdId:{} ", new Object[]{sprocKey, sendId, schdId});
        String channelType = infoMap.get(Column.CHANNEL_TYPE);
        String workday = infoMap.get(Column.WORKDAY);
        String nowDate = DateUtil.getFullDateDefaultFormat();
        CopyOnWriteArrayList<SendListModel> sendList = new CopyOnWriteArrayList<SendListModel>();
        Map tlistMap = new HashMap();
        CopyOnWriteArrayList<String> sprocFields = new CopyOnWriteArrayList<String>();
        for (Map.Entry<String, String> targetSproc : sprocMap.entrySet()) {
            sprocFields.add(targetSproc.getKey());
        }
        for (String sprocField : sprocFields) {
            try {
                log.info("sprocFields , {}", (Object)sprocField);
                String tlistKey = null;
                tlistKey = "TLIST:" + sprocField;
                tlistMap = this.wrapperRedisTemplate.hgetAllString(tlistKey);
                if (tlistMap != null && tlistMap.size() > 0) {
                    for (String tlistField : tlistMap.keySet()) {
                        String tlistValue = (String)tlistMap.get(tlistField);
                        if (tlistValue != null && !"".equals(tlistValue)) {
                            Map tlistValueMap = JsonUtil.getMapFromJson((String)tlistValue);
                            String tlistStatus = (String)tlistValueMap.get(Column.STATUS);
                            if (tlistStatus != null && !"".equals(tlistStatus)) {
                                tlistValueMap.put(Column.STATUS, tlistStatus);
                                tlistValueMap.put(Column.END_TIME, nowDate);
                                sendList.add(this.settingResultModel(tlistValueMap, workday, channelType, schdId, sendId));
                                this.wrapperRedisTemplate.hmset(tlistKey, tlistField, "");
                                log.warn("[REDIS_BLANK] {} {} ", (Object)tlistKey, (Object)tlistField);
                            } else {
                                log.debug("[cleanRedisReq] {} {} is ready sending. it is normal.", (Object)tlistKey, (Object)tlistField);
                            }
                            if (sendList == null || sendList.size() < this.pageSize) continue;
                            this.insertSendListBulk(sendList, schdId);
                            sendList.clear();
                            continue;
                        }
                        log.debug("[cleanRedisReq] {} {} is CRSLT target. already deleted.", (Object)tlistKey, (Object)tlistField);
                    }
                    if (sendList != null && sendList.size() >= 0) {
                        this.insertSendListBulk(sendList, schdId);
                    }
                }
            }
            catch (Exception e) {
                log.error("{}", (Throwable)e);
            }
            if (sendList != null) {
                sendList.clear();
                sendList = null;
            }
            if (tlistMap != null) {
                tlistMap.clear();
                tlistMap = null;
            }
            if (sprocFields == null) continue;
            sprocFields.clear();
            sprocFields = null;
        }
        this.wrapperRedisTemplate.del(sprocKey);
        log.warn("[REDIS_DELETE] {}", (Object)sprocKey);
        long end = System.currentTimeMillis();
        log.info("[REDIS] cleanRedisReq {} END ============[{}] seconds", (Object)sprocKey, (Object)((double)(end - start) / 1000.0));
    }

    private SendListModel settingResultModel(Map<String, String> memberMap, String workday, String channelType, long schdId, long sendId) {
        log.info("memberMap => {}", (Object)memberMap.toString());
        SendListModel.SendListModelBuilder sendListModelBuiler = SendListModel.builder();
        sendListModelBuiler.logType("TMS_SEND_LIST").channelType(channelType).workday(workday).memberTargetData(memberMap.get(Column.TMS_M_TARGET)).memberId(memberMap.get(Column.MEMBER_ID)).memberIdSeq(memberMap.get(Column.UNIQUE_SEQ)).memberName(memberMap.get(Column.TMS_M_NAME)).domain(memberMap.get(Column.DOMAIN)).schdId(schdId).sendId(sendId).eventCode(memberMap.get(Column.STATUS)).eventType(Constants.EventType.S.toString()).codeDetail(memberMap.get(Column.ERROR_CODE)).eventTime(memberMap.get(Column.END_TIME)).tmsMEmail(memberMap.get(Column.TMS_M_EMAIL)).tmsMPhone(memberMap.get(Column.TMS_M_PHONE)).tmsMToken(memberMap.get(Column.TMS_M_TOKEN)).deviceId(Long.parseLong(memberMap.get(Column.DEVICE_ID)));
        return sendListModelBuiler.build();
    }

    private void insertSendListBulk(List<SendListModel> sendList, long schdId) {
        try {
            log.info("[StatBasicTasklet] {} insertSendListBulk sendList size {}", (Object)schdId, (Object)sendList.size());
            this.sqlExecutor.batchUpdate("insertSendList", sendList, false);
        }
        catch (Exception e) {
            log.warn("insertSendList Bulk insert Error schdId {}. start each update. {}", (Object)schdId, (Object)e.getMessage());
            for (SendListModel result : sendList) {
                try {
                    if (result.getLogDetail() != null) {
                        result.setLogDetail(ManagerUtil.isSplitListByte(result.getLogDetail(), 400));
                    }
                    if (result.getCodeDetail() != null) {
                        result.setCodeDetail(ManagerUtil.isSplitListByte(result.getCodeDetail(), 40));
                    }
                    if (result.getContent() != null) {
                        result.setContent(ManagerUtil.isSplitListByte(result.getContent(), 4000));
                    }
                    this.resultDao.insertSendList(result);
                }
                catch (Exception e1) {
                    log.error("Single insert Error : {}, error:{}", (Object)result.toLogString(), (Object)e1);
                }
            }
        }
    }
}

