/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.custom.batch.writer;

import com.humuson.tms.adaptor.jdbc.mybatis.TmsBatchSqlExecutor;
import com.humuson.tms.manager.custom.repository.dao.ResultSmsDao;
import com.humuson.tms.manager.custom.repository.model.ResultSmsModel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="resultInfobankSmsWriter")
@StepScope
public class ResultInfobankSmsWriter
implements ItemWriter<ResultSmsModel> {
    private static final Logger log = LoggerFactory.getLogger(ResultInfobankSmsWriter.class);
    @Autowired
    ResultSmsDao resultSmsDao;
    @Autowired
    TmsBatchSqlExecutor<ResultSmsModel> sqlExecutorSms;
    @Value(value="#{jobParameters['minId'] ?: 0L}")
    private long minId;
    @Value(value="#{jobParameters['maxId'] ?: 0L}")
    private long maxId;
    @Value(value="#{jobParameters['tableName'] ?: 'em_smt_log'}")
    private String tableName;

    @BeforeStep
    public void before() {
    }

    @Transactional
    public void write(List<? extends ResultSmsModel> items) {
        ArrayList<ResultSmsModel> targetResultData = new ArrayList<ResultSmsModel>();
        List<? extends ResultSmsModel> targetList = items;
        if (targetList.size() > 0) {
            for (ResultSmsModel resultSmsModel : targetList) {
                String[] targetMember = resultSmsModel.getTargetMember().split("\\".concat("|"));
                String memberId = targetMember[0];
                String memberIdSeq = targetMember[1];
                resultSmsModel.setMemberId(memberId);
                resultSmsModel.setMemberIdSeq(memberIdSeq);
                targetResultData.add(resultSmsModel);
            }
            try {
                log.info("[JOB_WRITER] START updateSmResultByKey min {} max {} size {}", new Object[]{this.minId, this.maxId, targetResultData.size()});
                this.sqlExecutorSms.batchUpdate("com.humuson.tms.manager.custom.repository.dao.ResultSmsDao.updateSmResultByKey", targetResultData, false);
            }
            catch (Exception e) {
                log.warn("ResultSmsDao.updateSmResultByKey Bulk insert Error min {} max {}. start each update. {}", new Object[]{this.minId, this.maxId, e.getMessage()});
                for (ResultSmsModel result : targetResultData) {
                    try {
                        this.resultSmsDao.updateSmResultByKey(result);
                    }
                    catch (Exception e1) {
                        log.error("ResultSmsDao.insertSendListSms Single insert Error : {}, error:{}", (Object)result.toLogString(), (Object)e1);
                    }
                }
            }
            try {
                log.info("[JOB_WRITER] START insertSendList min {} max {} size {}", new Object[]{this.minId, this.maxId, targetResultData.size()});
                this.sqlExecutorSms.batchUpdate("com.humuson.tms.manager.custom.repository.dao.ResultSmsDao.insertSendListSms", targetResultData, false);
            }
            catch (Exception e) {
                log.warn("ResultSmsDao.insertSendListSms Bulk insert Error min {} max {}. start each update. {}", new Object[]{this.minId, this.maxId, e.getMessage()});
                for (ResultSmsModel result : targetResultData) {
                    try {
                        this.resultSmsDao.insertSendListSms(result);
                    }
                    catch (Exception e1) {
                        log.error("ResultSmsDao.insertSendListSms Single insert Error : {}, error:{}", (Object)result.toLogString(), (Object)e1);
                    }
                }
            }
        }
    }
}

