/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.custom.batch.reader;

import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.manager.repository.model.SendListModel;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.batch.MyBatisPagingItemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@TmsComponent(value="resultSendListReader")
@StepScope
public class ResultSendListReader
extends MyBatisPagingItemReader<SendListModel> {
    private static final Logger log = LoggerFactory.getLogger(ResultSendListReader.class);
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    @Value(value="#{jobParameters['tableName'] ?: 'TMS_SEND_LIST'}")
    private String tableName;
    @Value(value="${tms.manager.proc-result-sm.reader-page-size}")
    private int pageSize;

    @PostConstruct
    public void init() {
        this.setSqlSessionFactory(this.sqlSessionFactory);
        this.setQueryId("com.humuson.tms.manager.custom.repository.dao.ResultSendListDao.resultSendList");
        this.setPageSize(this.pageSize);
    }

    @BeforeStep
    public void before() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("TABLE_NAME", this.tableName);
        try {
            this.setParameterValues(paramMap);
            this.afterPropertiesSet();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SendListModel read() throws Exception, UnexpectedInputException, ParseException {
        return (SendListModel)super.read();
    }
}

