/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.custom.batch.listener;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.manager.repository.dao.SendDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="ResultSendListJobListener")
public class ResultSendListJobListener
extends JobExecutionListenerSupport {
    private static final Logger log = LoggerFactory.getLogger(ResultSendListJobListener.class);
    @Autowired
    SendDao sendDao;
    @Autowired
    private LockContexter contexter;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    private LockController lockController;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterJob(JobExecution jobExecution) {
        String jobKey = "lock.manager.result.sendList";
        if (this.lockController == null) {
            this.lockController = this.contexter.lock(jobKey);
        }
        if (jobExecution.getStatus() != BatchStatus.COMPLETED) {
            log.info("insertWebResult job Not Completed");
        }
        try {
            long startTime = jobExecution.getJobParameters().getLong("time");
            String jobName = jobExecution.getJobParameters().getString("jobName");
            log.info("[JOB] END insertWebResult job id {}, jobName:{}, state {} END [{}] seconds", new Object[]{jobExecution.getId(), jobName, jobExecution.getStatus(), (double)(System.currentTimeMillis() - startTime) / 1000.0});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.lockController != null) {
                this.lockController.unLock();
                this.lockController.close();
            }
        }
    }

    public void beforeJob(JobExecution jobExecution) {
        this.lockController = this.contexter.lock("lock.manager.result.sendList");
        this.lockController.lock();
    }
}

