/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.stereotype.Component;

@Component
@EnableAsync
@Configuration
public class SchedulingConfiguration
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(SchedulingConfiguration.class);
    @Value(value="${tms.manager.schedule.thread-size:-1}")
    private int schedulePoolSize;

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        if (this.schedulePoolSize >= 0) {
            taskScheduler.setPoolSize(this.schedulePoolSize);
        }
        taskScheduler.initialize();
        taskScheduler.setThreadNamePrefix("mnScheduler-");
        log.info("[SchedulingConfiguration] Scheduled set");
        taskRegistrar.setTaskScheduler((TaskScheduler)taskScheduler);
    }
}

