/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.config;

import com.humuson.tms.config.Constants;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties
@ConfigurationProperties(prefix="error-code")
public class ErrorConfig {
    private static final Logger log = LoggerFactory.getLogger(ErrorConfig.class);
    private Map<String, String> pu;
    private Map<String, String> sm;
    private Map<String, String> ka;
    private Map<String, String> tms;
    private Map<String, String> em;

    @Bean(name={"emailError"})
    public Map<String, String> emailErrorCodes() {
        return this.em;
    }

    @Bean(name={"pushError"})
    public Map<String, String> pushErrorCodes() {
        return this.pu;
    }

    @Bean(name={"smsError"})
    public Map<String, String> smsErrorCodes() {
        return this.sm;
    }

    @Bean(name={"bizError"})
    public Map<String, String> bizErrorCodes() {
        return this.ka;
    }

    @Bean(name={"tmsError"})
    public Map<String, String> tmsErrorCodes() {
        return this.tms;
    }

    public Map<String, String> getChnResultCode(String chnType) {
        if (Constants.ChannelType.EM.toString().equals(chnType)) {
            return this.getEm();
        }
        if (Constants.ChannelType.SM.toString().equals(chnType)) {
            return this.getSm();
        }
        if (Constants.ChannelType.KA.toString().equals(chnType)) {
            return this.getKa();
        }
        if (Constants.ChannelType.PU.toString().equals(chnType)) {
            return this.getPu();
        }
        return this.getTms();
    }

    public String judgeResultCode(String status, Map<String, String> tmsCodeMap, Map<String, String> chnCodeMap) {
        String resultCode = null;
        String defaultDomainApplyStatus = null;
        String defaultDomainApplyStatusUpper = null;
        String defaultDomainApplyStatusLower = null;
        String[] statuss = null;
        try {
            if (status.contains(".")) {
                statuss = status.split("\\.");
                if (statuss.length > 2) {
                    defaultDomainApplyStatus = statuss[0].concat(".").concat(statuss[1]).concat(".").concat("default");
                    defaultDomainApplyStatusUpper = statuss[0].toUpperCase().concat(".").concat(statuss[1]).concat(".").concat("default");
                    defaultDomainApplyStatusLower = statuss[0].toLowerCase().concat(".").concat(statuss[1]).concat(".").concat("default");
                } else {
                    defaultDomainApplyStatus = status;
                }
            }
            if (!StringUtils.isEmpty((Object)status.trim())) {
                if (chnCodeMap.containsKey(status = status.trim())) {
                    resultCode = chnCodeMap.get(status);
                } else if (tmsCodeMap.containsKey(status)) {
                    resultCode = status;
                }
                status = status.trim().toUpperCase();
                if (chnCodeMap.containsKey(status)) {
                    resultCode = chnCodeMap.get(status);
                } else if (tmsCodeMap.containsKey(status)) {
                    resultCode = status;
                }
                status = status.trim().toLowerCase();
                if (chnCodeMap.containsKey(status)) {
                    resultCode = chnCodeMap.get(status);
                } else if (tmsCodeMap.containsKey(status)) {
                    resultCode = status;
                }
                if (resultCode == null) {
                    if (chnCodeMap.containsKey(defaultDomainApplyStatus)) {
                        resultCode = chnCodeMap.get(defaultDomainApplyStatus);
                    } else if (chnCodeMap.containsKey(defaultDomainApplyStatusUpper)) {
                        resultCode = chnCodeMap.get(defaultDomainApplyStatusUpper);
                    } else if (chnCodeMap.containsKey(defaultDomainApplyStatusLower)) {
                        resultCode = chnCodeMap.get(defaultDomainApplyStatusLower);
                    }
                }
                if (resultCode == null) {
                    resultCode = "99";
                }
            } else {
                resultCode = "99";
            }
        }
        catch (Exception e) {
            log.error("Error converting target result code to TMS code. error:{}", (Throwable)e);
        }
        return resultCode;
    }

    public Map<String, String> getPu() {
        return this.pu;
    }

    public Map<String, String> getSm() {
        return this.sm;
    }

    public Map<String, String> getKa() {
        return this.ka;
    }

    public Map<String, String> getTms() {
        return this.tms;
    }

    public Map<String, String> getEm() {
        return this.em;
    }

    public void setPu(Map<String, String> pu) {
        this.pu = pu;
    }

    public void setSm(Map<String, String> sm) {
        this.sm = sm;
    }

    public void setKa(Map<String, String> ka) {
        this.ka = ka;
    }

    public void setTms(Map<String, String> tms) {
        this.tms = tms;
    }

    public void setEm(Map<String, String> em) {
        this.em = em;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorConfig)) {
            return false;
        }
        ErrorConfig other = (ErrorConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$pu = this.getPu();
        Map<String, String> other$pu = other.getPu();
        if (this$pu == null ? other$pu != null : !((Object)this$pu).equals(other$pu)) {
            return false;
        }
        Map<String, String> this$sm = this.getSm();
        Map<String, String> other$sm = other.getSm();
        if (this$sm == null ? other$sm != null : !((Object)this$sm).equals(other$sm)) {
            return false;
        }
        Map<String, String> this$ka = this.getKa();
        Map<String, String> other$ka = other.getKa();
        if (this$ka == null ? other$ka != null : !((Object)this$ka).equals(other$ka)) {
            return false;
        }
        Map<String, String> this$tms = this.getTms();
        Map<String, String> other$tms = other.getTms();
        if (this$tms == null ? other$tms != null : !((Object)this$tms).equals(other$tms)) {
            return false;
        }
        Map<String, String> this$em = this.getEm();
        Map<String, String> other$em = other.getEm();
        return !(this$em == null ? other$em != null : !((Object)this$em).equals(other$em));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErrorConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $pu = this.getPu();
        result = result * 59 + ($pu == null ? 0 : ((Object)$pu).hashCode());
        Map<String, String> $sm = this.getSm();
        result = result * 59 + ($sm == null ? 0 : ((Object)$sm).hashCode());
        Map<String, String> $ka = this.getKa();
        result = result * 59 + ($ka == null ? 0 : ((Object)$ka).hashCode());
        Map<String, String> $tms = this.getTms();
        result = result * 59 + ($tms == null ? 0 : ((Object)$tms).hashCode());
        Map<String, String> $em = this.getEm();
        result = result * 59 + ($em == null ? 0 : ((Object)$em).hashCode());
        return result;
    }

    public String toString() {
        return "ErrorConfig(pu=" + this.getPu() + ", sm=" + this.getSm() + ", ka=" + this.getKa() + ", tms=" + this.getTms() + ", em=" + this.getEm() + ")";
    }
}

