/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.clean;

import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.manager.batch.listener.CleanRdbJobListener;
import com.humuson.tms.manager.clean.CleanRdb;
import com.humuson.tms.manager.repository.model.LongIdModel;
import com.humuson.tms.manager.repository.model.SendListModel;
import org.mybatis.spring.batch.MyBatisCursorItemReader;
import org.mybatis.spring.batch.MyBatisPagingItemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

@TmsComponent
public class CleanBasicRdb
implements CleanRdb {
    private static final Logger log = LoggerFactory.getLogger(CleanBasicRdb.class);
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Autowired
    @Qualifier(value="cleanBatchTasklet")
    public Tasklet cleanBatchTasklet;
    @Autowired
    @Qualifier(value="cleanAppSessReader")
    public MyBatisPagingItemReader<LongIdModel> cleanAppSessReader;
    @Autowired
    @Qualifier(value="cleanAppSessWriter")
    public ItemWriter<LongIdModel> cleanAppSessWriter;
    @Autowired
    @Qualifier(value="cleanAppDeletedReader")
    public MyBatisPagingItemReader<LongIdModel> cleanAppDeletedReader;
    @Autowired
    @Qualifier(value="cleanAppDeletedWriter")
    public ItemWriter<LongIdModel> cleanAppDeletedWriter;
    @Autowired
    @Qualifier(value="cleanRecordTasklet")
    public Tasklet cleanRecordTasklet;
    @Autowired
    @Qualifier(value="cleanRecordReader")
    public MyBatisPagingItemReader<LongIdModel> cleanRecordReader;
    @Autowired
    @Qualifier(value="cleanRecordWriter")
    public ItemWriter<LongIdModel> cleanRecordWriter;
    @Autowired
    @Qualifier(value="cleanRecordWebReader")
    public MyBatisCursorItemReader<SendListModel> cleanRecordWebReader;
    @Autowired
    @Qualifier(value="cleanRecordWebWriter")
    public ItemWriter<SendListModel> cleanRecordWebWriter;
    @Autowired
    @Qualifier(value="cleanRecordTempReader")
    public MyBatisPagingItemReader<LongIdModel> cleanRecordTempReader;
    @Autowired
    @Qualifier(value="cleanRecordTempWriter")
    public ItemWriter<LongIdModel> cleanRecordTempWriter;
    @Value(value="${tms.manager.clean.rdb.reader-page-size}")
    private int pageSize;
    @Value(value="${tms.manager.clean.rdb.auth-level}")
    private String authLevel;
    @Value(value="${tms.manager.clean.rdb.include-web}")
    private String includeWeb;
    @Value(value="${tms.manager.clean.rdb.include-temp}")
    private String includeTemp;

    @Override
    public Job cleanRdbJob(CleanRdbJobListener listener) {
        JobBuilder jb = this.jobBuilderFactory.get("cleanRdbJob");
        jb.incrementer((JobParametersIncrementer)new RunIdIncrementer());
        SimpleJobBuilder sjb = jb.start(this.cleanBatchTasklet());
        sjb.next(this.cleanAppSessStep());
        sjb.next(this.cleanAppDeletedStep());
        if (this.authLevel != null && "QRY".equals(this.authLevel)) {
            sjb.next(this.cleanRecordStep());
            if ("Y".equals(this.includeWeb)) {
                sjb.next(this.cleanRecordWebStep());
            }
            if ("Y".equals(this.includeTemp)) {
                sjb.next(this.cleanRecordTempStep());
            }
        } else if (this.authLevel != null && "DDL".equals(this.authLevel)) {
            sjb.next(this.cleanRecordTasklet());
        }
        sjb.listener((JobExecutionListener)listener);
        return sjb.build();
    }

    @Override
    public Step cleanBatchTasklet() {
        DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
        attribute.setPropagationBehavior(Propagation.REQUIRES_NEW.value());
        attribute.setIsolationLevel(Isolation.READ_COMMITTED.value());
        return this.stepBuilderFactory.get("cleanBatchTasklet").tasklet(this.cleanBatchTasklet).transactionAttribute((TransactionAttribute)attribute).build();
    }

    @Override
    public Step cleanAppSessStep() {
        DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
        attribute.setPropagationBehavior(Propagation.REQUIRES_NEW.value());
        attribute.setIsolationLevel(Isolation.READ_COMMITTED.value());
        return this.stepBuilderFactory.get("cleanAppSessStep").chunk(this.pageSize).reader(this.cleanAppSessReader).writer(this.cleanAppSessWriter).transactionAttribute((TransactionAttribute)attribute).build();
    }

    @Override
    public Step cleanAppDeletedStep() {
        DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
        attribute.setPropagationBehavior(Propagation.REQUIRES_NEW.value());
        attribute.setIsolationLevel(Isolation.READ_COMMITTED.value());
        return this.stepBuilderFactory.get("cleanAppDeletedStep").chunk(this.pageSize).reader(this.cleanAppDeletedReader).writer(this.cleanAppDeletedWriter).transactionAttribute((TransactionAttribute)attribute).build();
    }

    @Override
    public Step cleanRecordTasklet() {
        DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
        attribute.setPropagationBehavior(Propagation.REQUIRES_NEW.value());
        attribute.setIsolationLevel(Isolation.READ_COMMITTED.value());
        return this.stepBuilderFactory.get("cleanRecordTasklet").tasklet(this.cleanRecordTasklet).transactionAttribute((TransactionAttribute)attribute).build();
    }

    @Override
    public Step cleanRecordStep() {
        DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
        attribute.setPropagationBehavior(Propagation.REQUIRES_NEW.value());
        attribute.setIsolationLevel(Isolation.READ_COMMITTED.value());
        return this.stepBuilderFactory.get("cleanRecordSendStep").chunk(this.pageSize).reader(this.cleanRecordReader).writer(this.cleanRecordWriter).transactionAttribute((TransactionAttribute)attribute).build();
    }

    @Override
    public Step cleanRecordWebStep() {
        DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
        attribute.setPropagationBehavior(Propagation.REQUIRES_NEW.value());
        attribute.setIsolationLevel(Isolation.READ_COMMITTED.value());
        return this.stepBuilderFactory.get("cleanRecordWebStep").chunk(this.pageSize).reader(this.cleanRecordWebReader).writer(this.cleanRecordWebWriter).transactionAttribute((TransactionAttribute)attribute).build();
    }

    @Override
    public Step cleanRecordTempStep() {
        DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
        attribute.setPropagationBehavior(Propagation.REQUIRES_NEW.value());
        attribute.setIsolationLevel(Isolation.READ_COMMITTED.value());
        return this.stepBuilderFactory.get("cleanRecordTempStep").chunk(this.pageSize).reader(this.cleanRecordTempReader).writer(this.cleanRecordTempWriter).transactionAttribute((TransactionAttribute)attribute).build();
    }
}

