/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.batch.writer;

import com.humuson.tms.adaptor.jdbc.mybatis.TmsBatchSqlExecutor;
import com.humuson.tms.manager.repository.dao.CleanRdbDao;
import com.humuson.tms.manager.repository.model.LongIdModel;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="cleanRecordTempWriter")
@StepScope
public class CleanRecordTempBasicWriter
implements ItemWriter<LongIdModel> {
    private static final Logger log = LoggerFactory.getLogger(CleanRecordTempBasicWriter.class);
    @Autowired
    TmsBatchSqlExecutor<LongIdModel> sqlExecutor;
    @Autowired
    SqlSessionFactory sqlSessionFactory;

    @BeforeStep
    public void before() {
    }

    public void write(List<? extends LongIdModel> items) {
        log.info("[JOB_WRITER] START items cnt {}", (Object)items.size());
        SqlSession sqlSession = this.sqlSessionFactory.openSession(ExecutorType.SIMPLE);
        CleanRdbDao cleanRdbDao = (CleanRdbDao)sqlSession.getMapper(CleanRdbDao.class);
        List<? extends LongIdModel> resultList = items;
        try {
            this.sqlExecutor.batchUpdate("com.humuson.tms.manager.repository.dao.CleanRdbDao.deleteRecordTargetTemp", resultList, false);
        }
        catch (Exception e) {
            log.warn("MN1601|Bulk delete Error : deleteRecordTargetTemp. start each update. {}", (Object)e.getMessage());
            for (LongIdModel longIdModel : resultList) {
                try {
                    cleanRdbDao.deleteRecordTargetTemp(longIdModel);
                }
                catch (Exception e1) {
                    log.error("MN1602|Single delete Error : deleteRecordTargetTemp : {}, error:{}", (Object)longIdModel.getId(), (Object)e1);
                }
            }
        }
        if (sqlSession != null) {
            sqlSession.commit(true);
            sqlSession.close();
        }
        log.info("[JOB_WRITER] END");
    }
}

