/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.batch.task;

import com.humuson.tms.adaptor.jdbc.mybatis.TmsBatchSqlExecutor;
import com.humuson.tms.manager.repository.dao.CleanRdbDao;
import com.humuson.tms.manager.repository.model.BatchJobExeModel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="cleanBatchTasklet")
@StepScope
public class CleanBatchBasicTasklet
implements Tasklet {
    private static final Logger log = LoggerFactory.getLogger(CleanBatchBasicTasklet.class);
    @Autowired
    CleanRdbDao cleanRdbDao;
    @Autowired
    TmsBatchSqlExecutor<Long> sqlExecutor;
    @Value(value="${tms.manager.clean.rdb.limit-day}")
    private int limitDay;

    public RepeatStatus execute(StepContribution arg0, ChunkContext arg1) throws Exception {
        log.info("[CleanBatchBasicTasklet]");
        List<Object> list = new ArrayList();
        do {
            list = this.cleanRdbDao.selectJobInstanceIdSql(this.limitDay);
            ArrayList<Long> jobExecutionIdParams = new ArrayList<Long>();
            ArrayList<Long> jobInstanceIdParams = new ArrayList<Long>();
            for (BatchJobExeModel batchJobExeModel : list) {
                jobExecutionIdParams.add(batchJobExeModel.getJobExecutionId());
                jobInstanceIdParams.add(batchJobExeModel.getJobInstanceId());
            }
            log.info("deleteStepExecutionContext start [size:{}]", (Object)list.size());
            try {
                this.sqlExecutor.batchUpdate("com.humuson.tms.manager.repository.dao.CleanRdbDao.deleteStepExecutionContext", jobExecutionIdParams, false);
            }
            catch (Exception e) {
                log.error("MN1601|Bulk delete Error : StepExecutionContext");
                for (Long param : jobExecutionIdParams) {
                    try {
                        this.cleanRdbDao.deleteStepExecutionContext(param);
                    }
                    catch (Exception e2) {
                        log.error("MN1602|Single delete Error : StepExecutionContext : {}, error:{}", (Object)param, (Object)e2);
                    }
                }
            }
            log.info("deleteBatchJobExecutionContext start [size:{}]", (Object)list.size());
            try {
                this.sqlExecutor.batchUpdate("com.humuson.tms.manager.repository.dao.CleanRdbDao.deleteBatchJobExecutionContext", jobExecutionIdParams, false);
            }
            catch (Exception e) {
                log.error("MN1601|Bulk delete Error : JobExecutionContext");
                for (Long param : jobExecutionIdParams) {
                    try {
                        this.cleanRdbDao.deleteBatchJobExecutionContext(param);
                    }
                    catch (Exception e2) {
                        log.error("MN1602|Single delete Error : JobExecutionContext : {}, error:{}", (Object)param, (Object)e2);
                    }
                }
            }
            log.info("deleteStepExecution start [size:{}]", (Object)list.size());
            try {
                this.sqlExecutor.batchUpdate("com.humuson.tms.manager.repository.dao.CleanRdbDao.deleteStepExecution", jobExecutionIdParams, false);
            }
            catch (Exception e) {
                log.error("MN1601|Bulk delete Error : StepExecution");
                for (Long param : jobExecutionIdParams) {
                    try {
                        this.cleanRdbDao.deleteStepExecution(param);
                    }
                    catch (Exception e2) {
                        log.error("MN1602|Single delete Error : StepExecution : {}, error:{}", (Object)param, (Object)e2);
                    }
                }
            }
            log.info("deleteBatchJobExecutionParam start [size:{}]", (Object)list.size());
            try {
                this.sqlExecutor.batchUpdate("com.humuson.tms.manager.repository.dao.CleanRdbDao.deleteBatchJobExecutionParam", jobExecutionIdParams, false);
            }
            catch (Exception e) {
                log.error("MN1601|Bulk delete Error : JobExecutionParam");
                for (Long param : jobExecutionIdParams) {
                    try {
                        this.cleanRdbDao.deleteBatchJobExecutionParam(param);
                    }
                    catch (Exception e2) {
                        log.error("MN1602|Single delete Error : JobExecutionParam : {}, error:{}", (Object)param, (Object)e2);
                    }
                }
            }
            log.info("deleteBatchJobExecution start [size:{}]", (Object)list.size());
            try {
                this.sqlExecutor.batchUpdate("com.humuson.tms.manager.repository.dao.CleanRdbDao.deleteBatchJobExecution", jobExecutionIdParams, false);
            }
            catch (Exception e) {
                log.error("MN1601|Bulk delete Error : JobExecution");
                for (Long param : jobExecutionIdParams) {
                    try {
                        this.cleanRdbDao.deleteBatchJobExecution(param);
                    }
                    catch (Exception e2) {
                        log.error("MN1602|Single delete Error : JobExecution : {}, error:{}", (Object)param, (Object)e2);
                    }
                }
            }
            log.info("deleteBatchJobInstance start [size:{}]", (Object)list.size());
            try {
                this.sqlExecutor.batchUpdate("com.humuson.tms.manager.repository.dao.CleanRdbDao.deleteBatchJobInstance", jobInstanceIdParams, false);
            }
            catch (Exception e) {
                log.error("MN1601|Bulk delete Error : JobInstance");
                for (Long param : jobInstanceIdParams) {
                    try {
                        this.cleanRdbDao.deleteBatchJobInstance(param);
                    }
                    catch (Exception e2) {
                        log.error("MN1602|Single delete Error : JobInstance : {}, error:{}", (Object)param, (Object)e2);
                    }
                }
            }
        } while (!(list = new ArrayList()).isEmpty());
        return RepeatStatus.FINISHED;
    }
}

