/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.util;

import com.humuson.tms.adaptor.jdbc.TmsBatchDataSourceManager;
import com.humuson.tms.adaptor.jdbc.mybatis.DynamicMapSqlMapper;
import com.humuson.tms.adaptor.jdbc.mybatis.TmsJdbcTemplate;
import com.humuson.tms.config.ClassDispatcher;
import com.humuson.tms.config.Column;
import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.controller.repository.dao.ApiTargetCountDao;
import com.humuson.tms.controller.util.StringUtil;
import com.humuson.tms.util.FileExtentionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.aspectj.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TargetCounterUtil {
    private static final Logger log = LoggerFactory.getLogger(TargetCounterUtil.class);
    public static final String UTF8_BOM = "\ufeff";
    @Autowired
    ApiTargetCountDao apiTargetCountDao;
    @Autowired
    FileExtentionUtil extentionUtil;
    @Autowired
    DynamicMapSqlMapper mapper;
    @Value(value="${tms.controller.local.File}")
    public boolean localFile;
    @Value(value="${tms.controller.local.FilePath}")
    public String localFilePath;
    String encryptKey = null;
    @Autowired
    TmsCommonConfig tmsCommonConfig;

    @PostConstruct
    public void onPost() {
        this.encryptKey = this.tmsCommonConfig.getHumusonKey();
    }

    public long getDbTargetCount(HashMap<String, Object> mapTargetInfo) throws Exception {
        String sql = this.makeCountSqlFromTargetSql(mapTargetInfo.get(Column.TARGET_QUERY_S).toString());
        if (!mapTargetInfo.containsKey(Column.DB_URL) || String.valueOf(mapTargetInfo.get(Column.DB_URL)).equalsIgnoreCase("null")) {
            return this.apiTargetCountDao.selectTargetCount(sql);
        }
        TmsJdbcTemplate jdbcTemplate = (TmsJdbcTemplate)ClassDispatcher.getApplicationContext().getBean(TmsJdbcTemplate.class);
        try {
            jdbcTemplate.db(TmsBatchDataSourceManager.INSTANCE.getDataSource(mapTargetInfo));
            Map result = jdbcTemplate.selectOne(sql);
            String count = String.valueOf(result.get("CNT"));
            long l = Long.parseLong(count);
            return l;
        }
        catch (Exception e) {
            log.error("failed return count sql[{}], {} ", (Object)sql, (Object)e);
            throw e;
        }
        finally {
            if (jdbcTemplate != null) {
                jdbcTemplate.close();
            }
            jdbcTemplate = null;
        }
    }

    private String makeCountSqlFromTargetSql(String query) {
        return "SELECT count(*) as CNT FROM (" + query + ") A";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileTargetCount(HashMap<String, Object> mapTargetInfo) throws Exception {
        String fullPathFileName = String.valueOf(mapTargetInfo.get(Column.TARGET_FILE_NAME)).trim();
        if (!this.localFile) {
            fullPathFileName = String.valueOf(mapTargetInfo.get(Column.TARGET_FILE_NAME)).trim();
        } else {
            fullPathFileName = fullPathFileName.substring(fullPathFileName.lastIndexOf("/"), fullPathFileName.length());
            fullPathFileName = this.localFilePath + fullPathFileName.trim();
        }
        mapTargetInfo.put(Column.TARGET_FILE_NAME, fullPathFileName);
        if (!this.extentionUtil.isTargetingFileExtention(fullPathFileName)) {
            log.info("FILE TARGETING START, File is invalid Extention : {}", (Object)fullPathFileName);
            throw new Exception("File Extention is Invalid. file : " + fullPathFileName);
        }
        File targetFile = new File(fullPathFileName);
        if (!targetFile.exists()) {
            log.info("FILE TARGETING START, File is not exist : {}", (Object)fullPathFileName);
            throw new Exception("File is not exist. file : " + fullPathFileName);
        }
        if (!FileUtil.canReadFile((File)targetFile)) {
            log.info("FILE TARGETING START, File can't read : {}", (Object)fullPathFileName);
            throw new Exception("File can't read. file : " + fullPathFileName);
        }
        boolean firstSkip = "Y".equalsIgnoreCase(String.valueOf(mapTargetInfo.get(Column.TARGET_FILE_HEAD_FLAG)));
        int targetCnt = 0;
        int lineToSkipCount = 0;
        if (firstSkip) {
            lineToSkipCount = 1;
        }
        try (BufferedReader lnr = null;){
            String line;
            lnr = new LineNumberReader(new FileReader(targetFile));
            while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                if (StringUtil.isBOMFile(line)) {
                    log.debug("IS BOM FILE!!!!!!!!!!!!!!!!, will RemoveBom. filePath  : {}", (Object)targetFile);
                    line = StringUtil.removeBOM(line);
                }
                if (line.trim().isEmpty()) continue;
                ++targetCnt;
            }
            log.debug("lineNumber:{}, lineToSkipCount:{}", (Object)((LineNumberReader)lnr).getLineNumber(), (Object)lineToSkipCount);
            targetCnt = ((LineNumberReader)lnr).getLineNumber() - lineToSkipCount;
        }
        return targetCnt;
    }
}

