/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.util;

import com.humuson.tms.config.Column;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StringUtil<T>
extends StringUtils {
    private static final Logger log = LoggerFactory.getLogger(StringUtil.class);

    public static byte[] compress(String data) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length());
        GZIPOutputStream gzip = new GZIPOutputStream(bos);
        gzip.write(data.getBytes());
        gzip.close();
        byte[] compressed = bos.toByteArray();
        bos.close();
        return compressed;
    }

    public static String decompress(byte[] compressed) throws IOException {
        String line;
        ByteArrayInputStream bis = new ByteArrayInputStream(compressed);
        GZIPInputStream gis = new GZIPInputStream(bis);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)gis, "UTF-8"));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        br.close();
        gis.close();
        bis.close();
        return sb.toString();
    }

    public static final String getDomain(String str) {
        if (str == null) {
            return "";
        }
        int index = str.indexOf(64);
        if (index < 0) {
            return "";
        }
        return str.substring(index + 1);
    }

    public boolean hasKey(Map<String, T> map, String keyName) {
        try {
            if (!map.containsKey(keyName)) {
                return false;
            }
            if (map.get(keyName) == null) {
                return false;
            }
            return !String.valueOf(map.get(keyName)).trim().isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isEqual(Map<String, T> map, String keyName, String compareString) {
        try {
            if (!map.containsKey(keyName)) {
                return false;
            }
            if (map.get(keyName) == null) {
                return false;
            }
            if (String.valueOf(map.get(keyName)).trim().isEmpty()) {
                return false;
            }
            return compareString.trim().equalsIgnoreCase(String.valueOf(map.get(keyName)).trim());
        }
        catch (Exception e) {
            return false;
        }
    }

    public Map<String, Object> convertMap(Map<String, T> originalMap) throws Exception {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (String strKey : originalMap.keySet()) {
            newMap.put(strKey, originalMap.get(strKey));
        }
        return newMap;
    }

    public HashMap<String, String> convertStringMap(HashMap<String, Object> originalMap) throws Exception {
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (String strKey : originalMap.keySet()) {
            if (!strKey.equalsIgnoreCase(Column.TARGET_FILE_DELIM)) {
                newMap.put(strKey, String.valueOf(originalMap.get(strKey)).trim());
                continue;
            }
            newMap.put(strKey, String.valueOf(originalMap.get(strKey)).trim());
        }
        return newMap;
    }

    public HashMap<String, Object> convertObjectHashMap(Map<String, String> originalMap) throws Exception {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (String strKey : originalMap.keySet()) {
            if (!strKey.equalsIgnoreCase(Column.TARGET_FILE_DELIM)) {
                newMap.put(strKey, originalMap.get(strKey).trim());
                continue;
            }
            newMap.put(strKey, originalMap.get(strKey));
        }
        return newMap;
    }

    public HashMap<String, String> convertStringHashMap(Map<String, Object> originalMap) throws Exception {
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (String strKey : originalMap.keySet()) {
            if (!strKey.equalsIgnoreCase(Column.TARGET_FILE_DELIM)) {
                newMap.put(strKey, String.valueOf(originalMap.get(strKey)).trim());
                continue;
            }
            newMap.put(strKey, String.valueOf(originalMap.get(strKey)));
        }
        return newMap;
    }

    public static boolean isBOMFile(String str) {
        if (str == null || "".equals(str)) {
            return true;
        }
        if (str.startsWith("\ufeff")) {
            return false;
        }
        if (str.startsWith("\ufffe")) {
            return false;
        }
        if (str.startsWith("\uefbbBF")) {
            return false;
        }
        if (str.startsWith("\u0000FEFF")) {
            return false;
        }
        if (str.startsWith("\ufffe0000")) {
            return false;
        }
        return !str.startsWith("\u0000FEFF");
    }

    public static String removeBOM(String str) {
        if (str == null || "".equals(str)) {
            return str;
        }
        if (str.startsWith("\ufeff")) {
            str = str.substring(1);
        } else if (str.startsWith("\ufffe")) {
            str = str.substring(1);
        } else if (str.startsWith("\uefbbBF")) {
            str = str.substring(1);
        } else if (str.startsWith("\u0000FEFF")) {
            str = str.substring(1);
        } else if (str.startsWith("\ufffe0000")) {
            str = str.substring(1);
        } else if (str.startsWith("\u0000FEFF")) {
            str = str.substring(1);
        }
        return str;
    }

    public static org.json.JSONObject jsonFromJsonString(String str) {
        try {
            return new org.json.JSONObject(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HashMap<String, String> mapFromJsonString(String str, boolean isContainNullValue) {
        try {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            JSONObject resultJSON = new JSONObject();
            JSONParser parser = new JSONParser();
            Object obj = parser.parse(str);
            resultJSON = (JSONObject)obj;
            for (Object o : resultJSON.entrySet()) {
                Map.Entry e = (Map.Entry)o;
                String key = (String)e.getKey();
                if (resultJSON.containsKey((Object)key) && resultJSON.get((Object)key) != null) {
                    resultMap.put(key, String.valueOf(resultJSON.get((Object)key)));
                    continue;
                }
                if (!resultJSON.containsKey((Object)key) || resultJSON.get((Object)key) != null || !isContainNullValue) continue;
                resultMap.put(key, "null");
            }
            return resultMap;
        }
        catch (Exception e) {
            log.debug("Fail to Convert String(json) to Map. Maybe String is not JsonObject : {}", (Object)str);
            return null;
        }
    }

    public static boolean isByteSizeOver(String str, long limitByte) {
        byte[] bytes = str.getBytes();
        return (long)bytes.length > limitByte;
    }

    public static ArrayList<String> isSplitListByte(String str, int limitByte) {
        ArrayList<String> splitedStringList = new ArrayList<String>();
        boolean isByteOver = true;
        while (isByteOver) {
            byte[] bytes = str.getBytes();
            int totalLength = bytes.length;
            if (totalLength > limitByte) {
                isByteOver = true;
                String spliteString = new String(bytes, 0, limitByte);
                splitedStringList.add(spliteString);
                str = str.substring(spliteString.length(), str.length());
                continue;
            }
            splitedStringList.add(str);
            isByteOver = false;
        }
        return splitedStringList;
    }

    public static String isSplitStringByte(String str, int limitByte) {
        byte[] bytes = str.getBytes();
        if (bytes.length > limitByte) {
            return new String(bytes, 0, limitByte);
        }
        return str;
    }
}

