/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.util;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.controller.logger.RedisLogger;
import com.humuson.tms.controller.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    RedisLogger logger;
    @Autowired
    StringUtil<Object> stringUtil;

    public <T> void hmSetAll(String key, HashMap<String, T> map) throws Exception {
        this.wrapperRedisTemplate.hmsetAll(key, this.stringUtil.convertStringMap(map));
        this.logger.write(RedisLogger.HMSETALL, key, map.size());
    }

    public <T> void set(String key, String value) throws Exception {
        this.wrapperRedisTemplate.set(key, value);
        this.logger.write(RedisLogger.SET, key, value);
    }

    public Map<String, String> hgetall(String key) throws Exception {
        Map result = this.wrapperRedisTemplate.hgetAllString(key);
        this.logger.write(RedisLogger.HGETALL, key, result.size());
        return result;
    }

    public String hmget(String key, String field) throws Exception {
        String result = this.wrapperRedisTemplate.hmget(key, field);
        this.logger.write(RedisLogger.HMGET, key, field, "", result);
        return result;
    }

    public void hmset(String key, String field, String value) throws Exception {
        this.wrapperRedisTemplate.hmset(key, field, value);
        this.logger.write(RedisLogger.HMSET, key, field, value);
    }

    public long hincrby(String key, String field, long value) throws Exception {
        long result = this.wrapperRedisTemplate.hincrby(key, field, value);
        return result;
    }

    public boolean hmHasKey(String key, String field) throws Exception {
        boolean result = this.wrapperRedisTemplate.hmHasKey(key, field);
        return result;
    }

    public boolean hasKey(String key) throws Exception {
        boolean result = this.wrapperRedisTemplate.hasKey(key);
        return result;
    }

    public long incr(String key, long value) throws Exception {
        long result = this.wrapperRedisTemplate.incr(key, value);
        return result;
    }

    public String get(String key) throws Exception {
        String result = this.wrapperRedisTemplate.defaultGet(key);
        this.logger.write(RedisLogger.GET, key, "", "", result);
        return result;
    }

    public void del(String key) throws Exception {
        this.wrapperRedisTemplate.del(key);
        this.logger.write(RedisLogger.DEL, key);
    }

    public void hmdel(String key, String field) throws Exception {
        this.wrapperRedisTemplate.hmdel(key, field);
        this.logger.write(RedisLogger.HMDEL, key, field);
    }
}

