/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.util;

import com.humuson.tms.config.Column;
import com.humuson.tms.controller.config.JobPINFOConfigReader;
import com.humuson.tms.controller.module.RedisKeyMaker;
import com.humuson.tms.controller.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JobParameterUtil {
    private static final Logger log = LoggerFactory.getLogger(JobParameterUtil.class);
    @Autowired
    RedisKeyMaker redisKeyMaker;
    @Autowired
    JobPINFOConfigReader pinfoReader;
    @Value(value="${tms.controller.batch.string-val-size:1024}")
    public int stringValSize;
    @Value(value="${tms.controller.batch.using-json:false}")
    public boolean isUsingJson;

    public HashMap<String, Object> getMapFromJobParam(JobParameters jobParams) {
        if (this.isUsingJson) {
            return this.getMapFromJsonJobParameters(jobParams);
        }
        return this.getMapFromJobParameters(jobParams);
    }

    public HashMap<String, String> getStringMapFromJobParam(JobParameters jobParams) {
        if (this.isUsingJson) {
            return this.getStringMapFromJsonJobParameters(jobParams);
        }
        return this.getStringMapFromJobParameters(jobParams);
    }

    public JobParameters getJobParamFromMap(Map<String, Object> jobDataMap) throws Exception {
        if (this.isUsingJson) {
            return this.getJsonJobParametersFromMap(jobDataMap);
        }
        return this.getJobParametersFromMap(jobDataMap);
    }

    public JobParameters getJobParametersFromMap(Map<String, Object> jobDataMap) throws Exception {
        JobParametersBuilder builder = new JobParametersBuilder();
        for (Map.Entry<String, Object> entry : jobDataMap.entrySet()) {
            String key = entry.getKey();
            if (key.equalsIgnoreCase(Column.TARGET_QUERY_S)) continue;
            Object value = entry.getValue();
            if (value instanceof String) {
                builder.addString(key, (String)value);
                continue;
            }
            if (value instanceof Float || value instanceof Double) {
                builder.addDouble(key, Double.valueOf(((Number)value).doubleValue()));
                continue;
            }
            if (value instanceof Integer || value instanceof Long) {
                builder.addLong(key, Long.valueOf(((Number)value).longValue()));
                continue;
            }
            if (value instanceof Date) {
                builder.addDate(key, (Date)value);
                continue;
            }
            log.debug("JobDataMap contains values which are not job parameters (ignoring). [key:{}, value:{}]", (Object)key, value);
        }
        return builder.toJobParameters();
    }

    public HashMap<String, String> getStringMapFromJobParameters(JobParameters jobParams) {
        HashMap<String, String> jobDataMap = new HashMap<String, String>();
        for (Map.Entry entry : jobParams.getParameters().entrySet()) {
            String key = (String)entry.getKey();
            Object value = ((JobParameter)entry.getValue()).getValue();
            if (value instanceof String) {
                jobDataMap.put(key, String.valueOf((String)value));
                continue;
            }
            if (value instanceof Float || value instanceof Double) {
                jobDataMap.put(key, String.valueOf((Number)value));
                continue;
            }
            if (value instanceof Integer || value instanceof Long) {
                jobDataMap.put(key, String.valueOf((Number)value));
                continue;
            }
            if (value instanceof Date) {
                jobDataMap.put(key, String.valueOf((Date)value));
                continue;
            }
            log.debug("JobDataMap contains values which are not object (ignoring). [key:{}, value:{}]", (Object)key, value);
        }
        return jobDataMap;
    }

    public HashMap<String, Object> getMapFromJobParameters(JobParameters jobParams) {
        HashMap<String, Object> jobDataMap = new HashMap<String, Object>();
        for (Map.Entry entry : jobParams.getParameters().entrySet()) {
            String key = (String)entry.getKey();
            Object value = ((JobParameter)entry.getValue()).getValue();
            if (value instanceof String) {
                jobDataMap.put(key, (String)value);
                continue;
            }
            if (value instanceof Float || value instanceof Double) {
                jobDataMap.put(key, (Number)value);
                continue;
            }
            if (value instanceof Integer || value instanceof Long) {
                jobDataMap.put(key, (Number)value);
                continue;
            }
            if (value instanceof Date) {
                jobDataMap.put(key, (Date)value);
                continue;
            }
            log.debug("JobDataMap contains values which are not object (ignoring). [key:{}, value:{}]", (Object)key, value);
        }
        return jobDataMap;
    }

    public JobParameters getJsonJobParametersFromMap(Map<String, Object> jobDataMap) throws Exception {
        JobParametersBuilder builder = new JobParametersBuilder();
        builder.addString(Column.SCHD_ID, String.valueOf(jobDataMap.get(Column.SCHD_ID)));
        builder.addString(Column.SEND_ID, String.valueOf(jobDataMap.get(Column.SEND_ID)));
        JSONObject jsonTarget = new JSONObject();
        List<String> arrJobPramKey = this.pinfoReader.getJobParamList();
        for (int i = 0; i < arrJobPramKey.size(); ++i) {
            if (!jobDataMap.containsKey(arrJobPramKey.get(i))) continue;
            jsonTarget.put(arrJobPramKey.get(i), (Object)String.valueOf(jobDataMap.get(arrJobPramKey.get(i))));
        }
        ArrayList<String> arrAllParamJson = StringUtil.isSplitListByte(jsonTarget.toString(), this.stringValSize);
        for (int i = 0; i < arrAllParamJson.size(); ++i) {
            builder.addString("JSON_PARAM" + i, arrAllParamJson.get(i));
        }
        return builder.toJobParameters();
    }

    public HashMap<String, Object> getMapFromJsonJobParameters(JobParameters jobParams) {
        HashMap<String, Object> jobDataMap = new HashMap<String, Object>();
        HashMap<String, String> jsonParamMap = new HashMap<String, String>();
        for (Map.Entry entry : jobParams.getParameters().entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith("JSON_PARAM")) {
                jsonParamMap.put(key, String.valueOf(((JobParameter)entry.getValue()).getValue()));
                continue;
            }
            Object value = ((JobParameter)entry.getValue()).getValue();
            if (value instanceof String) {
                jobDataMap.put(key, String.valueOf((String)value));
                continue;
            }
            if (value instanceof Float || value instanceof Double) {
                jobDataMap.put(key, String.valueOf((Number)value));
                continue;
            }
            if (value instanceof Integer || value instanceof Long) {
                jobDataMap.put(key, String.valueOf((Number)value));
                continue;
            }
            if (value instanceof Date) {
                jobDataMap.put(key, String.valueOf((Date)value));
                continue;
            }
            log.debug("JobDataMap contains values which are not object (ignoring). [key:{}, value:{}]", (Object)key, value);
        }
        StringBuilder sbuilder = new StringBuilder();
        for (int i = 0; i < jsonParamMap.size(); ++i) {
            sbuilder.append(jsonParamMap.get("JSON_PARAM" + i));
        }
        HashMap<String, String> jsonMap = StringUtil.mapFromJsonString(sbuilder.toString(), false);
        jobDataMap.putAll(jsonMap);
        return jobDataMap;
    }

    public HashMap<String, String> getStringMapFromJsonJobParameters(JobParameters jobParams) {
        HashMap<String, String> jobDataMap = new HashMap<String, String>();
        HashMap<String, String> jsonParamMap = new HashMap<String, String>();
        for (Map.Entry entry : jobParams.getParameters().entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith("JSON_PARAM")) {
                jsonParamMap.put(key, String.valueOf(((JobParameter)entry.getValue()).getValue()));
                continue;
            }
            Object value = ((JobParameter)entry.getValue()).getValue();
            if (value instanceof String) {
                jobDataMap.put(key, String.valueOf((String)value));
                continue;
            }
            if (value instanceof Float || value instanceof Double) {
                jobDataMap.put(key, String.valueOf((Number)value));
                continue;
            }
            if (value instanceof Integer || value instanceof Long) {
                jobDataMap.put(key, String.valueOf((Number)value));
                continue;
            }
            if (value instanceof Date) {
                jobDataMap.put(key, String.valueOf((Date)value));
                continue;
            }
            log.debug("JobDataMap contains values which are not object (ignoring). [key:{}, value:{}]", (Object)key, value);
        }
        StringBuilder sbuilder = new StringBuilder();
        for (int i = 0; i < jsonParamMap.size(); ++i) {
            sbuilder.append((String)jsonParamMap.get("JSON_PARAM" + i));
        }
        HashMap<String, String> jsonMap = StringUtil.mapFromJsonString(sbuilder.toString(), false);
        if (jsonMap != null && jsonMap.size() > 0) {
            jobDataMap.putAll(jsonMap);
        }
        return jobDataMap;
    }
}

