/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.targeter;

import com.humuson.tms.config.Column;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.controller.logger.FilterLogger;
import com.humuson.tms.controller.repository.dao.PushTargeterDao;
import com.humuson.tms.controller.targeter.InefficientTargeter;
import com.humuson.tms.controller.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@TmsComponent
public class TmsInefficientTargeter
implements InefficientTargeter {
    private static final Logger log = LoggerFactory.getLogger(TmsInefficientTargeter.class);
    @Autowired
    FilterLogger filterLog;
    @Autowired
    PushTargeterDao pushTargeterDao;
    @Autowired
    StringUtil stringUtil;

    @Override
    public List<HashMap<String, String>> doTargeting(HashMap<String, Object> mapPINFO, HashMap<String, String> mapTLIST) {
        ArrayList<HashMap<String, String>> listResult = new ArrayList<HashMap<String, String>>();
        if (listResult.size() == 0) {
            listResult.add(mapTLIST);
        }
        return listResult;
    }

    private HashMap<String, String> checkUUID(HashMap<String, Object> mapPInfo, HashMap<String, String> targetInfo) {
        try {
            if (this.stringUtil.hasKey(mapPInfo, Column.UUID) && !this.stringUtil.hasKey(targetInfo, Column.TMS_M_TOKEN)) {
                String uuid = String.valueOf(mapPInfo.get(Column.UUID));
                HashMap<String, Object> mapToken = this.pushTargeterDao.selectAppDeviceByUUID(String.valueOf(mapPInfo.get(Column.APP_GRP_ID)), String.valueOf(mapPInfo.get(Column.SITE_ID)), uuid);
                if (mapToken != null && mapToken.size() > 0 && mapToken.containsKey(Column.TMS_M_TOKEN)) {
                    targetInfo.putAll(this.stringUtil.convertMap(mapToken));
                } else {
                    targetInfo.put(Column.STATUS, "CT102");
                    targetInfo.put(Column.LOG_DETAIL, "TMS_M_ID :" + String.valueOf(targetInfo.get(Column.TMS_M_ID)) + ", Doesn't have device ");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            targetInfo.put(Column.STATUS, "CT102");
            targetInfo.put(Column.LOG_DETAIL, "TMS_M_ID :" + String.valueOf(targetInfo.get(Column.TMS_M_ID)) + ", has an exception. ");
            log.error("TARGETER FAIL, checkUUID has an exception. error : {} " + e);
        }
        return targetInfo;
    }

    private HashMap<String, String> getLastDeviceToken(String siteId, String appGrpId, HashMap<String, String> targetInfo) {
        try {
            String custId = targetInfo.get(Column.TMS_M_ID);
            HashMap<String, Object> mapToken = this.pushTargeterDao.selectTokenByLastID(appGrpId, siteId, custId);
            if (mapToken != null && mapToken.size() > 0 && this.stringUtil.hasKey(mapToken, Column.TMS_M_TOKEN)) {
                targetInfo.putAll(this.stringUtil.convertMap(mapToken));
            } else {
                targetInfo.put(Column.STATUS, "CT102");
                targetInfo.put(Column.LOG_DETAIL, "TMS_M_ID :" + String.valueOf(targetInfo.get(Column.TMS_M_ID)) + ", Doesn't have device ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            targetInfo.put(Column.STATUS, "CT102");
            targetInfo.put(Column.LOG_DETAIL, "TMS_M_ID :" + String.valueOf(targetInfo.get(Column.TMS_M_ID)) + ", has an exception. ");
        }
        return targetInfo;
    }

    private List<HashMap<String, String>> getMultiDeviceToken(String siteId, String appGrpId, HashMap<String, String> targetInfo) {
        ArrayList<HashMap<String, String>> listResult = new ArrayList<HashMap<String, String>>();
        try {
            String custId = targetInfo.get(Column.TMS_M_ID);
            List<HashMap<String, Object>> listDevicess = this.pushTargeterDao.selectTokenByCustID(appGrpId, siteId, custId);
            if (listDevicess.size() > 0) {
                for (HashMap<String, Object> mapDevice : listDevicess) {
                    HashMap<String, String> eachMap = targetInfo;
                    eachMap.putAll(this.stringUtil.convertMap(mapDevice));
                    listResult.add(targetInfo);
                }
            } else {
                targetInfo.put(Column.STATUS, "CT102");
                targetInfo.put(Column.LOG_DETAIL, "TMS_M_ID :" + String.valueOf(targetInfo.get(Column.TMS_M_ID)) + ", Doesn't have device. ");
                listResult.add(targetInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            targetInfo.put(Column.STATUS, "CT102");
            targetInfo.put(Column.LOG_DETAIL, "TMS_M_ID :" + String.valueOf(targetInfo.get(Column.TMS_M_ID)) + ", has an exception. ");
            listResult.add(targetInfo);
            log.error("TARGETER FAIL, getMultiDeviceToken has an exception. error : {} " + e);
        }
        return listResult;
    }
}

