/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.targeter;

import com.humuson.tms.config.Column;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.controller.batch.BatchLauncher;
import com.humuson.tms.controller.logger.StatusChanger;
import com.humuson.tms.controller.module.RedisKeyMaker;
import com.humuson.tms.controller.module.result.ResultDBHandler;
import com.humuson.tms.controller.repository.dao.SchedulerDao;
import com.humuson.tms.controller.repository.dao.TargeterDao;
import com.humuson.tms.controller.util.RedisUtil;
import com.humuson.tms.controller.util.StringUtil;
import com.humuson.tms.controller.util.TargetCounterUtil;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.task.TaskExecutor;

public abstract class Targeter {
    private static final Logger log = LoggerFactory.getLogger(Targeter.class);
    @Autowired
    StringUtil<Object> stringUtil;
    @Autowired
    TargetCounterUtil targetCounterUtil;
    @Autowired
    protected RedisUtil redisUtil;
    @Autowired
    protected RedisKeyMaker redisKeyMaker;
    @Autowired
    StatusChanger statusChanger;
    @Autowired
    TargeterDao targeterDao;
    @Autowired
    SchedulerDao schedulerDao;
    @Autowired
    @Qualifier(value="ResultDBHandler")
    ResultDBHandler resultSender;
    @Autowired
    BatchLauncher batchLauncher;
    @Value(value="${tms.controller.ct-tlist-unit:1000}")
    public int ctTlistUnit;
    @Value(value="${tms.controller.local.MQ:false}")
    protected boolean localMQ;
    @Value(value="${tms.controller.job-thread-pool.once.max-pool:0}")
    private int nmMaxPoolSize;
    @Value(value="${tms.controller.job-thread-pool.once.capacity:0}")
    private int nmQueueCapacity;
    @Value(value="${tms.controller.job-thread-pool.cycle.max-pool:4}")
    private int cycleMaxPoolSize;
    @Value(value="${tms.controller.job-thread-pool.cycle.capacity:4}")
    private int cycleQueueCapacity;
    @Autowired
    @Qualifier(value="task.ct.normal")
    TaskExecutor nmTask;
    @Autowired
    @Qualifier(value="task.ct.cycle")
    TaskExecutor cyTask;
    String encryptKey = null;
    @Autowired
    TmsCommonConfig tmsCommonConfig;

    @PostConstruct
    public void onPost() {
        this.encryptKey = this.tmsCommonConfig.getHumusonKey();
    }

    abstract void doTargeting(long var1, long var3, long var5, HashMap<String, Object> var7) throws Exception;

    protected HashMap<String, Object> getInitTarget(String targetType, HashMap<String, Object> mapPINFO) {
        long initTargetCount = 0L;
        try {
            if (targetType.equalsIgnoreCase(Constants.TargetType.FILE.name())) {
                initTargetCount = this.targetCounterUtil.getFileTargetCount(mapPINFO);
            } else if (targetType.equalsIgnoreCase(Constants.TargetType.DB.name())) {
                initTargetCount = this.targetCounterUtil.getDbTargetCount(mapPINFO);
            }
            mapPINFO.put(Column.PINFO_INIT_TARGET, initTargetCount);
        }
        catch (Exception e) {
            e.printStackTrace();
            mapPINFO.put(Column.ERROR_CODE, "CT0603");
            mapPINFO.put(Column.DESCRIPTION, "Controller Targeter has Exception. " + this.getClass().getSimpleName() + " : " + e);
        }
        return mapPINFO;
    }

    protected HashMap<String, Object> setJobParamData(HashMap<String, Object> mapPINFO) {
        try {
            String sendId = String.valueOf(mapPINFO.get(Column.SEND_ID)).trim();
            String schdId = String.valueOf(mapPINFO.get(Column.SCHD_ID)).trim();
            String targetType = String.valueOf(mapPINFO.get(Column.TARGET_TYPE));
            if (this.stringUtil.hasKey(mapPINFO, Column.CT_TARGET_TYPE)) {
                targetType = String.valueOf(mapPINFO.get(Column.CT_TARGET_TYPE));
            }
            mapPINFO.put(Column.CT_TARGET_TYPE, targetType);
            String id = null;
            if (targetType.equalsIgnoreCase(Constants.TargetType.DB.name())) {
                id = String.valueOf(mapPINFO.get(Column.TARGET_DB_ID)).trim();
            } else if (targetType.equalsIgnoreCase(Constants.TargetType.FILE.name())) {
                id = String.valueOf(mapPINFO.get(Column.TARGET_FILE_ID)).trim();
            }
            String batchName = sendId + ":" + schdId + ":" + targetType + ":" + id + ":" + System.currentTimeMillis();
            mapPINFO.put(Column.JOB_NAME, "job-" + batchName);
            mapPINFO.put(Column.STEP_NAME, "step-" + batchName);
            mapPINFO.put(Column.CT_TLIST_UNIT, this.ctTlistUnit);
            mapPINFO.put(Column.LOCAL_MQ, this.localMQ);
            String realtimeLockName = this.redisKeyMaker.realtimeLockKey(String.valueOf(mapPINFO.get(Column.TRIGGER_METHOD)), sendId, schdId);
            mapPINFO.put("REALTIME_LOCK_NAME", realtimeLockName);
        }
        catch (Exception e) {
            e.printStackTrace();
            mapPINFO.put(Column.ERROR_CODE, "CT0603");
            mapPINFO.put(Column.DESCRIPTION, "Controller Targeter has Exception. " + this.getClass().getSimpleName() + " : " + e);
        }
        return mapPINFO;
    }
}

