/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.targeter;

import com.humuson.tms.batch.FileReader;
import com.humuson.tms.config.Column;
import com.humuson.tms.config.Constants;
import com.humuson.tms.controller.schedule.BatchCheckScheduler;
import com.humuson.tms.controller.targeter.Targeter;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Qualifier(value="fileTargeter")
public class FileBatchTargeter
extends Targeter {
    private static final Logger log = LoggerFactory.getLogger(FileBatchTargeter.class);
    @Autowired
    BatchCheckScheduler batchCheckScheduler;
    String targetType = "FILE";
    @Autowired
    FileReader<Object> fileReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTargeting(long sendId, long schdId, long originInitCount, HashMap<String, Object> mapPINFO) throws Exception {
        log.debug("Controller-Targeter ::FILE TARGETING START");
        try {
            if (mapPINFO.containsKey(Column.TARGET_FILE)) {
                mapPINFO.put(Column.TARGET_FILE_NAME, String.valueOf(mapPINFO.get(Column.TARGET_FILE)));
            }
            if (this.resultSender.updateSchdErrorAndLog(mapPINFO = this.getInitTarget(this.targetType, mapPINFO), "25")) {
                return;
            }
            long initTarget = Long.valueOf(String.valueOf(mapPINFO.get(Column.PINFO_INIT_TARGET)));
            if (initTarget == 0L) {
                if (!String.valueOf(mapPINFO.get(Column.TRIGGER_METHOD)).equalsIgnoreCase(Constants.TriggerMethod.C5.name())) {
                    log.info("FILE TARGETER. schd({}:{}) initTarget={}. will changeJobStatus and DELETE PINFO", new Object[]{schdId, String.valueOf(mapPINFO.get(Column.TRIGGER_METHOD)), initTarget});
                }
                this.resultSender.zeroTarget(schdId, String.valueOf(mapPINFO.get(Column.TRIGGER_METHOD)));
                return;
            }
            log.info("FILE TARGETER. schd({}:{}) initTarget={}. will Start Batch Job", new Object[]{schdId, String.valueOf(mapPINFO.get(Column.TRIGGER_METHOD)), initTarget});
            if (this.batchCheckScheduler.isBatchStocked(String.valueOf(mapPINFO.get(Column.TRIGGER_METHOD)))) {
                log.info("SCHEDULER  Batch Job Pool is FULL. this schedule({}) pass. stil JOB_STATUS = 25", (Object)schdId);
                return;
            }
            if (!this.statusChanger.isScheduleExpectJobstatus(schdId, "25")) {
                return;
            }
            if (String.valueOf(mapPINFO.get(Column.TRIGGER_METHOD)).equalsIgnoreCase(Constants.TriggerMethod.C5.name())) {
                this.statusChanger.updateScheduleTarget("29", schdId, "Y", initTarget += originInitCount, this.getClass().getSimpleName() + "|" + sendId + "|" + schdId + "| This schedule(C5, FILE) will start Batch job. job_status will Change " + "29");
            } else {
                this.statusChanger.updateScheduleTarget("30", schdId, "Y", initTarget, this.getClass().getSimpleName() + "|" + sendId + "|" + schdId + "| This schedule(" + String.valueOf(mapPINFO.get(Column.TRIGGER_METHOD)) + ", FILE) will start Batch job. job_status will Change " + "30");
            }
            log.info("SCHEDULER  will update InitTarget. schdId({}), nowTarget({}), total INIT_TARGET({}). ", new Object[]{schdId, Long.valueOf(String.valueOf(mapPINFO.get(Column.PINFO_INIT_TARGET))), initTarget});
            mapPINFO = this.setJobParamData(mapPINFO);
            if (this.resultSender.updateSchdErrorAndLog(mapPINFO, "25")) {
                return;
            }
            ItemReader itemReader = this.fileReader.getReader(mapPINFO);
            this.batchLauncher.execute(sendId, schdId, mapPINFO, (ItemReader<HashMap<String, Object>>)itemReader);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("{}|{}|{}|Controller Targeter has Exception. {} : {}", new Object[]{"CT0603", sendId, schdId, this.getClass().getSimpleName(), e});
            this.resultSender.updateSchdError(sendId, schdId, e.getMessage());
        }
    }
}

