/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.targeter;

import com.humuson.tms.adaptor.jdbc.TmsBatchDataSourceManager;
import com.humuson.tms.batch.JdbcCursorItemReaderBuilder;
import com.humuson.tms.config.Column;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.controller.schedule.BatchCheckScheduler;
import com.humuson.tms.controller.targeter.Targeter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Qualifier(value="dbTargeter")
public class DBBatchTargeter
extends Targeter {
    private static final Logger log = LoggerFactory.getLogger(DBBatchTargeter.class);
    @Autowired
    BatchCheckScheduler batchCheckScheduler;
    String targetType = "DB";
    @Value(value="${tms.controller.batch.chunk-unit}")
    public String batchChunkUnit;
    String encryptKey = null;
    @Autowired
    TmsCommonConfig tmsCommonConfig;

    @Override
    @PostConstruct
    public void onPost() {
        this.encryptKey = this.tmsCommonConfig.getHumusonKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTargeting(long sendId, long schdId, long originInitCount, HashMap<String, Object> mapPINFO) throws Exception {
        log.debug("Controller-Targeter ::DB TARGETING START");
        try {
            String dbId = String.valueOf(mapPINFO.get(Column.TARGET_DB_ID));
            HashMap<String, Object> mapTotalPInfo = this.targeterDao.selectTargetDBInfo(dbId);
            if (mapTotalPInfo == null || mapTotalPInfo.size() < 1) {
                mapPINFO.put(Column.ERROR_CODE, "CT0503");
                mapPINFO.put(Column.DESCRIPTION, "JOIN TABLE(TMS_TARGET_DB_INFO) IS INVALID. Maybe not exist");
                if (this.resultSender.updateSchdErrorAndLog(mapPINFO, "25")) {
                    return;
                }
            }
            mapTotalPInfo.putAll(mapPINFO);
            mapPINFO = (HashMap<String, Object>)mapTotalPInfo.clone();
            mapTotalPInfo.clear();
            mapPINFO = this.getInitTarget(this.targetType, mapPINFO);
            if (this.resultSender.updateSchdErrorAndLog(mapPINFO, "25")) {
                return;
            }
            long initTarget = Long.valueOf(String.valueOf(mapPINFO.get(Column.PINFO_INIT_TARGET)));
            if (initTarget == 0L) {
                if (!String.valueOf(mapPINFO.get(Column.TRIGGER_METHOD)).equalsIgnoreCase(Constants.TriggerMethod.C5.name())) {
                    log.info("DB TARGETER. schd({}:{}) initTarget={}. will changeJobStatus(43)", new Object[]{schdId, String.valueOf(mapPINFO.get(Column.TRIGGER_METHOD)), initTarget});
                }
                this.resultSender.zeroTarget(schdId, String.valueOf(mapPINFO.get(Column.TRIGGER_METHOD)));
                return;
            }
            log.info("DB TARGETER. schd({}:{}) initTarget={}. will Start Batch Job", new Object[]{schdId, String.valueOf(mapPINFO.get(Column.TRIGGER_METHOD)), initTarget});
            if (this.batchCheckScheduler.isBatchStocked(String.valueOf(mapPINFO.get(Column.TRIGGER_METHOD)))) {
                log.info("SCHEDULER  Batch Job Pool is FULL. this schedule({}) pass. stil JOB_STATUS = 25 ", (Object)schdId);
                return;
            }
            if (!this.statusChanger.isScheduleExpectJobstatus(schdId, "25")) {
                return;
            }
            if (String.valueOf(mapPINFO.get(Column.TRIGGER_METHOD)).equalsIgnoreCase(Constants.TriggerMethod.C5.name())) {
                this.statusChanger.updateScheduleTarget("29", schdId, "Y", initTarget += originInitCount, this.getClass().getSimpleName() + "|" + sendId + "|" + schdId + "|C5|DB| will start Batch job. job_status changed " + "29");
            } else {
                this.statusChanger.updateScheduleTarget("30", schdId, "Y", initTarget, this.getClass().getSimpleName() + "|" + sendId + "|" + schdId + "|" + String.valueOf(mapPINFO.get(Column.TRIGGER_METHOD)) + "|DB| will start Batch job. job_status changed " + "30");
            }
            log.info("SCHEDULER  will update InitTarget. schdId({}), nowTarget({}), total INIT_TARGET({}). ", new Object[]{schdId, Long.valueOf(String.valueOf(mapPINFO.get(Column.PINFO_INIT_TARGET))), initTarget});
            mapPINFO = this.setJobParamData(mapPINFO);
            if (this.resultSender.updateSchdErrorAndLog(mapPINFO, "25")) {
                return;
            }
            JdbcCursorItemReader jdbcCursorItemReader = new JdbcCursorItemReaderBuilder().dataSource(this.getDatasource(mapPINFO)).name(String.valueOf(mapPINFO.get("JOB_NAME"))).sql(String.valueOf(mapPINFO.get(Column.TARGET_QUERY_S))).fetchSize(Integer.valueOf(this.batchChunkUnit).intValue()).ignoreWarnings(true).rowMapper(this.getRowMapper()).build();
            this.batchLauncher.execute(sendId, schdId, mapPINFO, (ItemReader<HashMap<String, Object>>)jdbcCursorItemReader);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("{}|{}|{}|Controller Targeter has Exception. {} : {}", new Object[]{"CT0603", sendId, schdId, this.getClass().getSimpleName(), e});
            this.resultSender.updateSchdError(sendId, schdId, e.getMessage());
        }
    }

    private RowMapper<HashMap<String, Object>> getRowMapper() {
        return new RowMapper<HashMap<String, Object>>(){

            public HashMap<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                return this.commonRowMapping(rs);
            }

            protected HashMap<String, Object> commonRowMapping(ResultSet rs) throws SQLException {
                HashMap<String, Object> mapping = new HashMap<String, Object>();
                ResultSetMetaData rsmd = rs.getMetaData();
                int cnt = rsmd.getColumnCount();
                for (int loop = 0; loop < cnt; ++loop) {
                    mapping.put(rsmd.getColumnLabel(loop + 1), rs.getObject(loop + 1));
                }
                return mapping;
            }
        };
    }

    private DataSource getDatasource(HashMap<String, Object> mapPINFO) throws Exception {
        return TmsBatchDataSourceManager.INSTANCE.getDataSource(mapPINFO);
    }
}

