/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.schedule.dispatch;

import com.humuson.tms.config.Constants;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.controller.schedule.dispatch.Scheduler;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@Qualifier(value="TMSTargetO7Scheduler")
@ConditionalOnProperty(prefix="tms.controller.schedule.use", name={"schedule-O7"}, havingValue="true", matchIfMissing=true)
public class TMSTargetO7Scheduler
extends Scheduler {
    private static final Logger log = LoggerFactory.getLogger(TMSTargetO7Scheduler.class);
    public String triggerMethod = Constants.TriggerMethod.O7.name();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelayString="${tms.controller.schedule.schedule-O7:3000}")
    public void schedule() {
        if (this.isWatcherUse) {
            this.parser.callWatcher(Constants.JobName.TARGETING);
            if (!this.parser.isOk()) {
                log.warn("Watcher Passing this Scheduling work. ENGINE : [{}]", (Object)(this.tmsConfig.getEngine() + this.tmsConfig.getNode()));
                return;
            }
        }
        if (this.batchCheckScheduler.isBatchStocked(this.triggerMethod)) {
            log.info("SCHEDULER  Batch Job Pool is FULL. this Scheduler({}) pass.", (Object)this.getClass().getSimpleName());
            return;
        }
        String lockName = this.company + ":" + this.daemonType + ":" + this.getClass().getSimpleName();
        LockController lockController = this.contexter.lock(lockName);
        List<Object> listScheduleIds = new ArrayList();
        try {
            if (lockController.isLocked()) {
                log.warn("[{}] is Locked(). Passing this Scheduling work.", (Object)lockName);
                return;
            }
            lockController.lock();
            listScheduleIds = this.selectTriggerSchedule(this.triggerMethod);
            if (listScheduleIds == null || listScheduleIds.size() == 0) {
                return;
            }
            this.doScheduling(listScheduleIds);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("{}|||Controller has Exception. CLASS : {}, ERROR : {}", new Object[]{"CT0501", this.getClass().getSimpleName(), e});
        }
        finally {
            lockController.unLock();
            listScheduleIds.clear();
            lockController = null;
            listScheduleIds = null;
        }
    }
}

