/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.schedule.dispatch;

import com.humuson.tms.config.Column;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.controller.module.PINFOMaker;
import com.humuson.tms.controller.schedule.dispatch.Scheduler;
import com.humuson.tms.util.date.DateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@Qualifier(value="TmsMainScheduler")
@ConditionalOnProperty(prefix="tms.controller.schedule.use", name={"main-10"}, havingValue="true", matchIfMissing=true)
public class TMSMainScheduler
extends Scheduler {
    private static final Logger log = LoggerFactory.getLogger(TMSMainScheduler.class);
    @Autowired
    protected PINFOMaker pinfoMaker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelayString="${tms.controller.schedule.default:3000}")
    public void schedule() {
        if (this.isWatcherUse) {
            this.parser.callWatcher(Constants.JobName.TARGETING);
            if (!this.parser.isOk()) {
                log.warn("Watcher Passing this Scheduling work. ENGINE : [{}]", (Object)(this.tmsConfig.getEngine() + this.tmsConfig.getNode()));
                return;
            }
        }
        String lockName = this.company + ":" + this.daemonType + ":" + this.getClass().getSimpleName();
        LockController lockController = this.contexter.lock(lockName);
        List<Object> listScheduleIds = new ArrayList();
        try {
            if (lockController.isLocked()) {
                log.warn("[{}] is Locked(). Passing this Scheduling work.", (Object)lockName);
                return;
            }
            lockController.lock();
            listScheduleIds = this.schedulerDao.selectDetectSchedule();
            if (listScheduleIds.size() == 0) {
                return;
            }
            HashMap<String, Object> mapPINFO = new HashMap<String, Object>();
            for (HashMap hashMap : listScheduleIds) {
                long schdId = Long.valueOf(String.valueOf(hashMap.get(Column.SCHD_ID)).trim());
                long sendId = Long.valueOf(String.valueOf(hashMap.get(Column.SEND_ID)).trim());
                String triggerMethod = String.valueOf(hashMap.get(Column.TRIGGER_METHOD)).trim();
                try {
                    if (!this.statusChanger.isScheduleExpectJobstatus(schdId, "10")) continue;
                    this.statusChanger.updateSchedule("20", schdId, "Y", null, this.getClass().getSimpleName() + "|" + sendId + "|" + schdId + "|" + triggerMethod + "| schedule detected. Lets start dispatch. job_status changed " + "20");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    mapPINFO = new HashMap();
                    mapPINFO.put(Column.ERROR_CODE, "CT0501");
                    mapPINFO.put(Column.SCHD_ID, schdId);
                    mapPINFO.put(Column.SEND_ID, sendId);
                    mapPINFO.put(Column.TRIGGER_METHOD, triggerMethod);
                    mapPINFO.put(Column.DESCRIPTION, "Controller has Exception. " + this.getClass().getSimpleName() + " : " + e);
                    if (this.resultSender.updateSchdErrorAndLog(mapPINFO, "10")) {
                        continue;
                    }
                }
                finally {
                    mapPINFO.clear();
                    continue;
                }
                try {
                    String mqPriority;
                    block42: {
                        String today;
                        mapPINFO.clear();
                        mapPINFO = this.pinfoMaker.get(sendId, schdId);
                        mapPINFO.put(Column.SCHD_ID, schdId);
                        mapPINFO.put(Column.SEND_ID, sendId);
                        mapPINFO.put(Column.TRIGGER_METHOD, triggerMethod);
                        if (this.resultSender.updateSchdErrorAndLog(mapPINFO, "20") || this.resultSender.updateSchdErrorAndLog(mapPINFO = this.pinfoFilter.execute(mapPINFO), "20")) continue;
                        if (triggerMethod.equalsIgnoreCase(Constants.TriggerMethod.C5.name()) && !this.stringUtil.isEqual(mapPINFO, Column.WORKDAY, today = DateUtil.getDivideDateDefault()[0])) {
                            if (!this.statusChanger.isScheduleExpectJobstatus(schdId, "20")) continue;
                            mqPriority = null;
                            if (this.stringUtil.hasKey(mapPINFO, Column.MQ_PRIORITY)) {
                                mqPriority = String.valueOf(mapPINFO.get(Column.MQ_PRIORITY));
                            }
                            this.statusChanger.updateSchedule("15", schdId, "N", mqPriority, this.getClass().getSimpleName() + "|" + sendId + "|" + schdId + "|" + triggerMethod + "| schedule has past WORKDAY. job_status changed " + "15");
                            log.info("SCHEDULER schdId({}) has past WORKDAY. JOB_STATUS change {} ", (Object)schdId, (Object)"15");
                            continue;
                        }
                        if (this.isRealTimeScheduleLocked(sendId, schdId, String.valueOf(mapPINFO.get(Column.TRIGGER_METHOD)))) continue;
                        if (this.stringUtil.isEqual(mapPINFO, Column.CHANNEL_TYPE, Constants.ChannelType.PU.name()) && this.stringUtil.isEqual(mapPINFO, Column.MKT_YN, "Y") && !triggerMethod.equalsIgnoreCase(Constants.TriggerMethod.O8.name()) && this.stringUtil.hasKey(mapPINFO = this.pushBlockedTimeActor.execute(mapPINFO), Column.ERROR_CODE)) {
                            log.error("{}|{}|{}|{}", new Object[]{String.valueOf(mapPINFO.get(Column.ERROR_CODE)), sendId, schdId, String.valueOf(mapPINFO.get(Column.DESCRIPTION))});
                            continue;
                        }
                        String redisKey = this.redisKeyMaker.PINFOKey(schdId + "");
                        try {
                            this.redisUtil.hmSetAll(redisKey, mapPINFO);
                            if ((!this.showC5PinfoUploadLog || !this.stringUtil.isEqual(mapPINFO, Column.TRIGGER_METHOD, Constants.TriggerMethod.C5.name())) && triggerMethod.equalsIgnoreCase(Constants.TriggerMethod.C5.name())) break block42;
                            log.info("Redis::[PINFO] Redis Upload Done.hmSetAll =====SEND_ID:[{}], key : {}, triggerMethod : {}", new Object[]{sendId, redisKey, String.valueOf(mapPINFO.get(Column.TRIGGER_METHOD))});
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            mapPINFO.put(Column.ERROR_CODE, "CM0201");
                            mapPINFO.put(Column.DESCRIPTION, "Redis HMSETALL(" + redisKey + ") has an Exception." + e);
                            if (!this.resultSender.updateSchdErrorAndLog(mapPINFO, "20")) break block42;
                            mapPINFO.clear();
                            continue;
                        }
                    }
                    if (!triggerMethod.equalsIgnoreCase(Constants.TriggerMethod.O8.name()) && !triggerMethod.equalsIgnoreCase(Constants.TriggerMethod.O7.name()) && this.isRequiredCancled(mapPINFO, "20")) continue;
                    if (!triggerMethod.equalsIgnoreCase(Constants.TriggerMethod.F1.name())) {
                        mapPINFO.put(Column.JOB_STATUS, "25");
                    } else {
                        mapPINFO.put(Column.JOB_STATUS, "30");
                    }
                    if (!this.statusChanger.isScheduleExpectJobstatus(schdId, "20")) continue;
                    mqPriority = null;
                    if (this.stringUtil.hasKey(mapPINFO, Column.MQ_PRIORITY)) {
                        mqPriority = String.valueOf(mapPINFO.get(Column.MQ_PRIORITY));
                    }
                    this.statusChanger.updateSchedule(String.valueOf(mapPINFO.get(Column.JOB_STATUS)), schdId, "Y", mqPriority, this.getClass().getSimpleName() + "|" + sendId + "|" + schdId + "|" + triggerMethod + "| schedule uploaded redis PINFO. job_status changed " + String.valueOf(mapPINFO.get(Column.JOB_STATUS)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    mapPINFO.put(Column.ERROR_CODE, "CT0501");
                    mapPINFO.put(Column.SCHD_ID, schdId);
                    mapPINFO.put(Column.SEND_ID, sendId);
                    mapPINFO.put(Column.DESCRIPTION, "Controller has Exception. " + this.getClass().getSimpleName() + " : " + e);
                    if (!this.resultSender.updateSchdErrorAndLog(mapPINFO, "20")) continue;
                }
                finally {
                    mapPINFO.clear();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("{}|||Controller has Exception. CLASS : {}, ERROR : {}", new Object[]{"CT0501", this.getClass().getSimpleName(), e});
        }
        finally {
            lockController.unLock();
            listScheduleIds.clear();
            lockController = null;
            listScheduleIds = null;
        }
    }
}

