/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.schedule.dispatch;

import com.humuson.tms.config.Column;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.controller.filtercommon.TmsPINFOFilter;
import com.humuson.tms.controller.filtercommon.executor.PushBlockedTimeActor;
import com.humuson.tms.controller.logger.StatusChanger;
import com.humuson.tms.controller.module.CancleChecker;
import com.humuson.tms.controller.module.RedisKeyMaker;
import com.humuson.tms.controller.module.result.ResultDBHandler;
import com.humuson.tms.controller.repository.dao.SchedulerDao;
import com.humuson.tms.controller.schedule.BatchCheckScheduler;
import com.humuson.tms.controller.targeter.DBBatchTargeter;
import com.humuson.tms.controller.targeter.FileBatchTargeter;
import com.humuson.tms.controller.targeter.TmsTargetingExecutor;
import com.humuson.tms.controller.util.RedisUtil;
import com.humuson.tms.controller.util.StringUtil;
import com.humuson.tms.monitor.feasibility.WatcherHttpCallParser;
import com.humuson.tms.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.task.TaskExecutor;

@Qualifier(value="defaultScheduler")
public abstract class Scheduler {
    private static final Logger log = LoggerFactory.getLogger(Scheduler.class);
    @Autowired
    TmsCommonConfig tmsConfig;
    @Autowired
    WatcherHttpCallParser parser;
    @Autowired
    protected LockContexter contexter;
    @Autowired
    PushBlockedTimeActor pushBlockedTimeActor;
    @Autowired
    CancleChecker cancleChecker;
    @Autowired
    protected StatusChanger statusChanger;
    @Autowired
    protected SchedulerDao schedulerDao;
    @Autowired
    protected BatchCheckScheduler batchCheckScheduler;
    @Value(value="${tms.company}")
    protected String company;
    @Value(value="${tms.daemon-type}")
    protected String daemonType;
    @Value(value="${tms.daemon-id}")
    protected String daemonId;
    @Value(value="${tms.controller.isWatcherUse:false}")
    boolean isWatcherUse;
    @Value(value="${tms.controller.showC5PinfoUploadLog:false}")
    boolean showC5PinfoUploadLog;
    @Value(value="${tms.controller.job-thread-pool.once.max-pool:0}")
    private int nmMaxPoolSize;
    @Value(value="${tms.controller.job-thread-pool.once.capacity:0}")
    private int nmQueueCapacity;
    @Value(value="${tms.controller.job-thread-pool.cycle.max-pool:4}")
    private int cycleMaxPoolSize;
    @Value(value="${tms.controller.job-thread-pool.cycle.capacity:4}")
    private int cycleQueueCapacity;
    @Autowired
    @Qualifier(value="task.ct.normal")
    TaskExecutor nmTask;
    @Autowired
    @Qualifier(value="task.ct.cycle")
    TaskExecutor cyTask;
    @Autowired
    protected RedisUtil redisUtil;
    @Autowired
    @Qualifier(value="ResultDBHandler")
    protected ResultDBHandler resultSender;
    @Autowired
    TmsPINFOFilter pinfoFilter;
    @Autowired
    protected StringUtil<Object> stringUtil;
    @Autowired
    RedisKeyMaker redisKeyMaker;
    @Autowired
    @Qualifier(value="dbTargeter")
    protected DBBatchTargeter dbTargeter;
    @Autowired
    @Qualifier(value="fileTargeter")
    protected FileBatchTargeter fileTargeter;
    @Autowired
    protected TmsTargetingExecutor custumTargetingExecutor;

    protected boolean isRequiredCancled(HashMap<String, Object> mapPINFO, String expectJobStatus) throws Exception {
        boolean isCancle = false;
        String schdId = String.valueOf(mapPINFO.get(Column.SCHD_ID));
        long sendId = Long.valueOf(String.valueOf(mapPINFO.get(Column.SEND_ID)));
        HashMap<String, Object> dbSendInfo = this.schedulerDao.selectSendInfoStatus(sendId);
        if (this.cancleChecker.isCancled(sendId)) {
            isCancle = true;
        }
        if (!isCancle && this.stringUtil.hasKey(dbSendInfo, "USE_YN") && String.valueOf(dbSendInfo.get("USE_YN")).equalsIgnoreCase("N")) {
            isCancle = true;
        }
        if (!isCancle && this.stringUtil.hasKey(dbSendInfo, "JOB_STATUS") && (String.valueOf(dbSendInfo.get("JOB_STATUS")).equalsIgnoreCase("31") || String.valueOf(dbSendInfo.get("JOB_STATUS")).equalsIgnoreCase("32") || String.valueOf(dbSendInfo.get("JOB_STATUS")).equalsIgnoreCase("42"))) {
            isCancle = true;
        }
        if (isCancle) {
            log.error("{}|{}|{}|THIS SEND_ID({}) IS CANCLED", new Object[]{"CT0601", sendId, schdId, sendId});
            mapPINFO.put("INIT_TARGET", "0");
            mapPINFO.put("COUNT_TARGET", "0");
            mapPINFO.put("FAILED_TARGET", "0");
            mapPINFO.put(Column.TARGET_SEQ, this.resultSender.getPinfoNextTargetSeq(schdId));
            this.resultSender.sprocSend((HashMap)StringUtils.convertStringMap(mapPINFO), "42", true);
            if (!this.statusChanger.isScheduleExpectJobstatus(Long.valueOf(String.valueOf(mapPINFO.get(Column.SCHD_ID))), expectJobStatus)) {
                return true;
            }
            String mqPriority = null;
            if (this.stringUtil.hasKey(mapPINFO, Column.MQ_PRIORITY)) {
                mqPriority = String.valueOf(mapPINFO.get(Column.MQ_PRIORITY));
            }
            this.statusChanger.updateSchedule("30", Long.valueOf(schdId), "N", mqPriority, this.getClass().getSimpleName() + "|" + sendId + "|" + schdId + "|| schedule is required Cancle. job_status changed " + "30");
        }
        dbSendInfo.clear();
        dbSendInfo = null;
        return isCancle;
    }

    protected boolean isRealTimeScheduleLocked(long sendId, long schdId, String triggerMethod) {
        if (triggerMethod.equalsIgnoreCase(Constants.TriggerMethod.C5.name())) {
            String realtimeLockName = triggerMethod + ":" + sendId + ":" + schdId;
            LockController realtimeLockController = this.contexter.lock(realtimeLockName);
            if (realtimeLockController.isLocked()) {
                log.info("SEND_ID:{}, SCHD_ID:{}, TRIGGER_METHOD:{}, is Already Regist(=LOCKED). LOCK_NAME : ({}). Skip this scheduling", new Object[]{sendId, schdId, triggerMethod, realtimeLockName});
                if (!this.statusChanger.isScheduleExpectJobstatus(schdId, "20")) {
                    return true;
                }
                this.statusChanger.updateSchedule("10", schdId, "N", null, this.getClass().getSimpleName() + "|" + sendId + "|" + schdId + "|" + triggerMethod + "| This schedule is Locked. job_status changed " + "10");
                return true;
            }
            log.debug("SEND_ID:{}, SCHD_ID:{}, is not Locked. do start schedule. ({})", new Object[]{sendId, schdId, realtimeLockName});
            return false;
        }
        return false;
    }

    protected List<HashMap<String, Object>> selectTriggerSchedule(String triggerMethod) {
        return this.selectTriggerSchedule("25", triggerMethod);
    }

    protected List<HashMap<String, Object>> selectTriggerSchedule(String jobStatus, String triggerMethod) {
        return this.schedulerDao.selectTriggerSchedule(jobStatus, triggerMethod);
    }

    protected HashMap<String, Object> getRedisPINFO(long sendId, long schdId) throws Exception {
        String redisKey = "PINFO:" + schdId;
        Map<String, String> mapPINFO = this.redisUtil.hgetall(redisKey);
        HashMap<String, Object> mapFilteredPInfo = null;
        if (mapPINFO == null || mapPINFO.size() == 0) {
            mapFilteredPInfo = new HashMap<String, Object>();
            mapFilteredPInfo.put(Column.SEND_ID, sendId + "");
            mapFilteredPInfo.put(Column.SCHD_ID, schdId + "");
            mapFilteredPInfo.put(Column.ERROR_CODE, "CT0503");
            mapFilteredPInfo.put(Column.DESCRIPTION, "Redis (HGETALL {" + redisKey + "}) has an Exception. redis's data is empty");
            return mapFilteredPInfo;
        }
        return this.pinfoFilter.execute(this.stringUtil.convertObjectHashMap(mapPINFO));
    }

    protected void doScheduling(List<HashMap<String, Object>> listScheduleIds) throws Exception {
        HashMap<Object, Object> mapPINFO = new HashMap();
        for (HashMap<String, Object> schedule : listScheduleIds) {
            mapPINFO.clear();
            long sendId = Long.valueOf(String.valueOf(schedule.get(Column.SEND_ID)));
            long schdId = Long.valueOf(String.valueOf(schedule.get(Column.SCHD_ID)));
            long originalInitTarget = String.valueOf(schedule.get(Column.INIT_TARGET)) != null ? Long.valueOf(String.valueOf(schedule.get(Column.INIT_TARGET))) : 0L;
            try {
                mapPINFO = this.getRedisPINFO(sendId, schdId);
                mapPINFO.put(Column.SCHD_ID, schdId);
                mapPINFO.put(Column.SEND_ID, sendId);
                if (this.isRequiredCancled(schedule, "25") || this.resultSender.updateSchdErrorAndLog(mapPINFO, "25")) continue;
                String targetType = String.valueOf(mapPINFO.get(Column.TARGET_TYPE));
                if (this.stringUtil.hasKey(mapPINFO, Column.CT_TARGET_TYPE)) {
                    targetType = String.valueOf(mapPINFO.get(Column.CT_TARGET_TYPE));
                }
                if (targetType.equalsIgnoreCase(Constants.TargetType.DB.name())) {
                    this.dbTargeter.doTargeting(sendId, schdId, originalInitTarget, mapPINFO);
                    continue;
                }
                if (targetType.equalsIgnoreCase(Constants.TargetType.FILE.name())) {
                    this.fileTargeter.doTargeting(sendId, schdId, originalInitTarget, mapPINFO);
                    continue;
                }
                this.custumTargetingExecutor.execute(mapPINFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                schedule.put(Column.ERROR_CODE, "CT0501");
                schedule.put(Column.DESCRIPTION, "Controller has Exception. " + this.getClass().getSimpleName() + " : " + e);
                if (!this.resultSender.updateSchdErrorAndLog(schedule, "25")) continue;
            }
        }
        mapPINFO.clear();
        mapPINFO = null;
    }
}

