/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.schedule;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.util.date.DateUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="tms.controller.schedule.use", name={"live-check"}, havingValue="true", matchIfMissing=true)
public class LiveCheckScheduler {
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Value(value="${tms.daemon-type:CT}")
    private String daemonType;
    @Value(value="${tms.daemon-id}")
    String daemonId;
    DecimalFormat df = new DecimalFormat("#0");
    @Value(value="${tms.controller.memory-check.critical-percent:80}")
    private int memoryMaxPercent;
    protected Logger liveTraceLogger = LoggerFactory.getLogger((String)"liveTraceLog");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelayString="${tms.controller.schedule.live-check:30000}")
    private void statusMonitor() {
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memUsage = memoryMxBean.getHeapMemoryUsage();
        String smemUsed = this.df.format((double)memUsage.getUsed() / 1048576.0);
        String smemMax = this.df.format((double)memUsage.getMax() / 1048576.0);
        String[] dates = DateUtil.getDivideDateDefault();
        String redisKey = "JSTAT:CT";
        String field = this.daemonId + ":" + dates[0];
        try {
            String oldValue = this.wrapperRedisTemplate.hmget(redisKey, field);
            oldValue = oldValue == null ? "" : oldValue + "|";
            this.wrapperRedisTemplate.hmset(redisKey, field, oldValue + dates[1] + ":" + smemMax + ":" + smemUsed);
            this.liveTraceLogger.info("Redis::[CheckLive] KEY:{}, FIELD:{}, DATA:{} / max {} MB used {} MB", new Object[]{redisKey, field, dates[1], smemMax, smemUsed});
        }
        catch (Exception e) {
            e.printStackTrace();
            this.liveTraceLogger.error("{}|||Redis::[CheckLive] KEY:{}, FIELD:{}, ERROR:{}", new Object[]{"CM0201", redisKey, field, e});
        }
        finally {
            this.wrapperRedisTemplate.close();
            memoryMxBean = null;
            memUsage = null;
            smemUsed = null;
            smemMax = null;
            dates = null;
            redisKey = null;
            field = null;
        }
    }

    public boolean isCheckMemory() {
        boolean res = false;
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memUsage = memoryMxBean.getHeapMemoryUsage();
        DecimalFormat df = new DecimalFormat("#0");
        String useMemory = df.format((double)memUsage.getUsed() / 1048576.0);
        String totalMemory = df.format((double)memUsage.getMax() / 1048576.0);
        int usePercent = (int)(Double.parseDouble(useMemory) / Double.parseDouble(totalMemory) * 100.0);
        if (usePercent >= this.memoryMaxPercent) {
            this.liveTraceLogger.info("HeapMemory::[CheckMemory] useMemory:{}/totalMemory:{},  criticalPercent:{} %,  usePercent:{} %", new Object[]{totalMemory, useMemory, this.memoryMaxPercent, usePercent});
            res = true;
        }
        return res;
    }
}

