/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.schedule;

import com.humuson.tms.controller.schedule.LiveCheckScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="tms.controller.schedule.use", name={"batch-check"}, havingValue="true", matchIfMissing=true)
public class BatchCheckScheduler {
    private static final Logger log = LoggerFactory.getLogger(BatchCheckScheduler.class);
    @Value(value="${tms.controller.job-thread-pool.once.max-pool:0}")
    private int nmMaxPoolSize;
    @Value(value="${tms.controller.job-thread-pool.once.capacity:0}")
    private int nmQueueCapacity;
    @Value(value="${tms.controller.job-thread-pool.cycle.max-pool:4}")
    private int cycleMaxPoolSize;
    @Value(value="${tms.controller.job-thread-pool.cycle.capacity:4}")
    private int cycleQueueCapacity;
    @Autowired
    @Qualifier(value="task.ct.normal")
    TaskExecutor nmTask;
    @Autowired
    @Qualifier(value="task.ct.cycle")
    TaskExecutor cyTask;
    @Autowired
    LiveCheckScheduler checkLiveScheduler;

    @Scheduled(fixedDelayString="${tms.controller.schedule.batch-check:300000}")
    private void status() {
        this.logging();
        if (this.checkLiveScheduler.isCheckMemory()) {
            System.gc();
        }
    }

    public void logging() {
        int nmTaskActiveCount = ((ThreadPoolTaskExecutor)this.nmTask).getActiveCount();
        int nmTaskQueueSize = ((ThreadPoolTaskExecutor)this.nmTask).getThreadPoolExecutor().getQueue().size();
        int cyTaskActiveCount = ((ThreadPoolTaskExecutor)this.cyTask).getActiveCount();
        int cyTaskQueueSize = ((ThreadPoolTaskExecutor)this.cyTask).getThreadPoolExecutor().getQueue().size();
        log.info(">>>BATCH TaskExecutor NORMAL(active:{}/maxPool:{}), (queueSize:{}/capacity:{}))\n>>>BATCH TaskExecutor CYCLE(active:{}/maxPool:{}), (queueSize:{}/capacity:{}))", new Object[]{nmTaskActiveCount, this.nmMaxPoolSize, nmTaskQueueSize, this.nmQueueCapacity, cyTaskActiveCount, this.cycleMaxPoolSize, cyTaskQueueSize, this.cycleQueueCapacity});
    }

    public boolean isBatchStocked(String triggerMethod) {
        boolean isStock = false;
        if (triggerMethod.startsWith("C")) {
            int cyActiveCount = ((ThreadPoolTaskExecutor)this.cyTask).getActiveCount();
            int cyTaskQueueSize = ((ThreadPoolTaskExecutor)this.cyTask).getThreadPoolExecutor().getQueue().size();
            log.debug("TRIGGER_METHOD:{}, activeTask:{}/maxPool:{}, taskQueueSize:{}/capacity:{}", new Object[]{triggerMethod, cyActiveCount, this.cycleMaxPoolSize, cyTaskQueueSize, this.cycleQueueCapacity});
            if (this.cycleMaxPoolSize > 0 && cyActiveCount >= this.cycleMaxPoolSize) {
                isStock = true;
                isStock = this.cycleQueueCapacity == cyTaskQueueSize;
            }
        } else if (triggerMethod.startsWith("O")) {
            int nmActiveCount = ((ThreadPoolTaskExecutor)this.nmTask).getActiveCount();
            int nmTaskQueueSize = ((ThreadPoolTaskExecutor)this.nmTask).getThreadPoolExecutor().getQueue().size();
            log.debug("TRIGGER_METHOD:{}, activeTask:{}/maxPool:{}, taskQueueSize:{}/capacity:{}", new Object[]{triggerMethod, nmActiveCount, this.nmMaxPoolSize, nmTaskQueueSize, this.nmQueueCapacity});
            isStock = false;
            if (this.nmMaxPoolSize > 0 && nmActiveCount >= this.nmMaxPoolSize) {
                isStock = true;
                isStock = this.nmQueueCapacity == nmTaskQueueSize;
            }
        }
        return isStock;
    }
}

