/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.mq;

import com.humuson.tms.adaptor.activemq.ActiveMQSender;
import com.humuson.tms.adaptor.activemq.ActivemqConnectorConfig;
import com.humuson.tms.config.Column;
import com.humuson.tms.config.Constants;
import com.humuson.tms.controller.config.MqNameConfing;
import com.humuson.tms.controller.config.MqPriorityConfig;
import com.humuson.tms.controller.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ActivemqProducer {
    private static final Logger log = LoggerFactory.getLogger(ActivemqProducer.class);
    @Autowired
    @Qualifier(value="activemq-sender")
    ActiveMQSender activeMQsender;
    @Autowired
    private MqNameConfing mqNameConfing;
    @Autowired
    private MqPriorityConfig mqPriorityConfing;
    @Autowired
    StringUtil stringUtil;
    @Value(value="${tms.controller.local.MQ:falsee}")
    boolean localMQ;
    @Value(value="${tms.controller.local.MQname}")
    String localMQname;
    @Value(value="${spring.activemq.controller.producer.default}")
    String defaultQueue;
    @Value(value="${tms.controller.schedule-priority.db-first:false}")
    boolean priorityDbFirst;

    public void send(HashMap<String, String> mapPINFO, String message) throws Exception {
        String queue = this.defaultQueue;
        try {
            queue = !this.localMQ && mapPINFO != null && mapPINFO.size() > 0 ? this.getQueueName(mapPINFO) : this.localMQname;
        }
        catch (Exception e) {
            log.info("Detect MQ queue Name has an error. willSend defaultQueue:{}. error : {}", (Object)queue, (Object)e.getMessage());
        }
        log.debug("Will MQ produce(queueName : {}, message: {}", (Object)queue, (Object)message);
        int priority = 4;
        int ymlPriority = 4;
        if (this.stringUtil.hasKey(mapPINFO, Column.MQ_PRIORITY)) {
            priority = Integer.valueOf(mapPINFO.get(Column.MQ_PRIORITY));
        }
        if (this.stringUtil.hasKey(mapPINFO, "INIT_TARGET") && !this.stringUtil.isEqual(mapPINFO, Column.TRIGGER_METHOD, Constants.TriggerMethod.C5.name())) {
            ymlPriority = this.getPriorityByTarget(mapPINFO);
        }
        if (!this.priorityDbFirst && !this.stringUtil.isEqual(mapPINFO, Column.TRIGGER_METHOD, Constants.TriggerMethod.C5.name())) {
            priority = ymlPriority;
        }
        ActivemqConnectorConfig config = this.activeMQsender.getactiveMQSenderConfig();
        config.jmsTemplate().setExplicitQosEnabled(true);
        config.jmsTemplate().setPriority(priority);
        config.jmsTemplate().afterPropertiesSet();
        this.activeMQsender.setactiveMQSenderConfig(config);
        this.activeMQsender.send(queue, message);
        log.info("MQ::[produce] SEND ===== queue:{}, message:{}, priority:{}", new Object[]{queue, message, priority});
    }

    public String getQueueName(HashMap<String, String> mapPINFO) throws Exception {
        List<Map<String, String>> nameList = this.mqNameConfing.getList();
        String mqName = this.defaultQueue;
        for (Map<String, String> nameMap : nameList) {
            String column = nameMap.get(MqNameConfing.mqColumn).trim();
            String value = nameMap.get(MqNameConfing.mqValue).trim();
            String queue = nameMap.get(MqNameConfing.mqQueue).trim();
            if (!this.stringUtil.hasKey(mapPINFO, column) || !mapPINFO.get(column).trim().equalsIgnoreCase(value)) continue;
            mqName = queue;
        }
        return mqName;
    }

    public int getPriorityByTarget(HashMap<String, String> mapPINFO) throws Exception {
        List<Map<String, String>> priorityList = this.mqPriorityConfing.getList();
        int priority = 4;
        long targetMinusCount = 0L;
        boolean setted = false;
        for (Map<String, String> nameMap : priorityList) {
            long targetCountUnder = Long.valueOf(nameMap.get(MqPriorityConfig.targetCountUnder));
            int targetPriority = Integer.valueOf(nameMap.get(MqPriorityConfig.priority));
            long initTarget = Integer.valueOf(mapPINFO.get("INIT_TARGET")).intValue();
            if (initTarget > targetCountUnder) continue;
            if (!setted) {
                setted = true;
                priority = targetPriority;
                targetMinusCount = targetCountUnder - initTarget;
                continue;
            }
            if (targetMinusCount <= targetCountUnder - initTarget) continue;
            priority = targetPriority;
            targetMinusCount = targetCountUnder - initTarget;
        }
        return priority;
    }
}

