/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.module.result;

import com.humuson.tms.config.Column;
import com.humuson.tms.controller.logger.StatusChanger;
import com.humuson.tms.controller.module.RedisKeyMaker;
import com.humuson.tms.controller.mq.ActivemqProducer;
import com.humuson.tms.controller.repository.dao.SchedulerDao;
import com.humuson.tms.controller.util.RedisUtil;
import com.humuson.tms.controller.util.StringUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="ResultHandler")
public abstract class ResultHandler {
    private static final Logger log = LoggerFactory.getLogger(ResultHandler.class);
    @Value(value="${tms.daemon-type}")
    protected String daemonType;
    @Value(value="${tms.daemon-id}")
    protected String daemonId;
    @Value(value="${tms.controller.local.MQ:false}")
    protected boolean localMQ;
    @Value(value="${tms.controller.ct-tlist-unit:1000}")
    public int ctTlistUnit;
    @Value(value="${tms.controller.sprocUploadCheckCount:3}")
    protected int sprocUploadCheckCount;
    @Autowired
    protected StringUtil stringUtil;
    @Autowired
    protected SchedulerDao schedulerDao;
    @Autowired
    protected StatusChanger statusChanger;
    @Autowired
    protected RedisUtil redisUtil;
    @Autowired
    protected ActivemqProducer producer;
    @Autowired
    protected RedisKeyMaker redisKeyMaker;
    boolean writeErrorList = false;
    protected boolean isResultLog = true;

    public long getPinfoNextTargetSeq(String schdId) {
        try {
            long targetSeq = this.redisUtil.hincrby(this.redisKeyMaker.PINFOKey(schdId), Column.PINFO_TARGET_SEQ_MAX, 1L);
            return targetSeq;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public long getPinfoLastTargetSeq(String schdId) {
        try {
            long lastTargetSeq = Long.valueOf(this.redisUtil.hmget(this.redisKeyMaker.PINFOKey(schdId), Column.PINFO_TARGET_SEQ_MAX));
            return lastTargetSeq;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public boolean finishTargetSeqData(HashMap<String, String> mapPINFO, String jobStatus) throws Exception {
        String redisKey = this.redisKeyMaker.SPROCKey(mapPINFO);
        String redisField = this.redisKeyMaker.SPROCField(mapPINFO);
        this.sprocSend(redisKey, redisField, mapPINFO, jobStatus, false);
        boolean isWrited = false;
        int tryCount = 0;
        while (!isWrited) {
            isWrited = this.redisUtil.hmHasKey(redisKey, redisField);
            if (isWrited) {
                this.mqSend(mapPINFO);
                continue;
            }
            log.info("SPROC KEY:{}, FIELD:{}, is not uploaded. sleep 1000mils", (Object)redisKey, (Object)redisField);
            Thread.sleep(1000L);
            if (++tryCount <= this.sprocUploadCheckCount) continue;
            isWrited = true;
            this.redisUtil.hmdel(redisKey, redisField);
            log.error("SPROC KEY:{}, FIELD:{}, is not uploaded. Check Count is over. will Delete SPROC. Not Sending MQ", (Object)redisKey, (Object)redisField);
        }
        return true;
    }

    public void mqSend(HashMap<String, String> mapPINFO) throws Exception {
        block6: {
            String sendId = String.valueOf(mapPINFO.get(Column.SEND_ID));
            String schdId = String.valueOf(mapPINFO.get(Column.SCHD_ID));
            long doneCount = Long.valueOf(String.valueOf(mapPINFO.get("COUNT_TARGET")));
            try {
                if (doneCount > 0L) {
                    String mqValue = sendId + ":" + schdId + ":" + String.valueOf(mapPINFO.get(Column.TARGET_SEQ));
                    this.producer.send(mapPINFO, mqValue);
                    try {
                        this.redisUtil.hincrby(this.redisKeyMaker.PINFOKey(schdId + ""), Column.PINFO_COUNT_TARGET, doneCount);
                        break block6;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error("{}|{}|{}|MQ EXCEPTION. {}", new Object[]{"CM0302", sendId, schdId, e});
                        throw e;
                    }
                }
                if (this.isResultLog) {
                    log.info("TLIST size is zero. not Sending  MQ ");
                }
            }
            catch (Exception e) {
                log.error("{}|{}|{}|Controller has Exception. {} : {}", new Object[]{"CT0501", sendId, schdId, this.getClass().getSimpleName(), e});
                throw e;
            }
        }
    }

    public void sprocSend(HashMap<String, String> mapPINFO, String jobStatus, boolean isNotSendMP) throws Exception {
        String redisKey = this.redisKeyMaker.SPROCKey(mapPINFO);
        String redisField = this.redisKeyMaker.SPROCField(mapPINFO);
        this.sprocSend(redisKey, redisField, mapPINFO, jobStatus, isNotSendMP);
    }

    public void sprocSend(String redisKey, String redisField, HashMap<String, String> mapPINFO, String jobStatus, boolean isNotSendMP) {
        try {
            String redisValue = this.redisKeyMaker.SPROCValue(mapPINFO, jobStatus);
            if (!this.localMQ) {
                this.redisUtil.hmset(redisKey, redisField, redisValue);
            }
            if (this.isResultLog) {
                log.info("Redis::[SPROC] Redis Upload Done.hmSetAll =====SEND_ID[{}], key : {}, field : {}, value : {}, isNotRedisUpload : {}", new Object[]{String.valueOf(Column.SEND_ID), redisKey, redisField, redisValue, this.localMQ});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("{}||{}|Redis (SPROC {}) has an Exception. {}", new Object[]{"CT0503", mapPINFO.get(Column.SCHD_ID), redisKey, e});
        }
    }

    public void delTempRedis(HashMap<String, String> mapPINFO) {
        String tFailRedisKey = this.redisKeyMaker.TFAILCTKey(mapPINFO);
        try {
            String tempTfailValue = "0";
            if (this.redisUtil.hasKey(tFailRedisKey)) {
                if (this.isResultLog) {
                    log.info("CONTROLLER will delete Temp Redis. tFailRedisKey:{}", (Object)tFailRedisKey);
                }
                tempTfailValue = this.redisUtil.get(tFailRedisKey);
            }
            if (this.stringUtil.hasKey(mapPINFO, "FAILED_TARGET") && Long.valueOf(String.valueOf(mapPINFO.get("FAILED_TARGET"))) > 0L) {
                tempTfailValue = Long.valueOf(tempTfailValue) + Long.valueOf(String.valueOf(mapPINFO.get("FAILED_TARGET"))) + "";
            }
            if (tempTfailValue != null && !tempTfailValue.trim().isEmpty()) {
                this.redisUtil.hincrby(this.redisKeyMaker.PINFOKey(mapPINFO), Column.PINFO_FAILED_TARGET, Long.valueOf(tempTfailValue));
            }
            this.redisUtil.del(tFailRedisKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("{}|{}|{}|Redis (del {}) has an Exception. {}", new Object[]{"CT0503", String.valueOf(mapPINFO.get(Column.SEND_ID)), String.valueOf(mapPINFO.get(Column.SCHD_ID)), tFailRedisKey, e});
        }
    }
}

