/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.module.result;

import com.humuson.tms.config.Column;
import com.humuson.tms.config.Constants;
import com.humuson.tms.controller.module.result.ResultHandler;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="ResultDBHandler")
public class ResultDBHandler
extends ResultHandler {
    private static final Logger log = LoggerFactory.getLogger(ResultDBHandler.class);

    public void zeroTarget(long schdId, String triggerMethod) {
        if (triggerMethod.equalsIgnoreCase(Constants.TriggerMethod.C5.name())) {
            this.statusChanger.updateSchedule("15", schdId, "N", null, this.getClass().getSimpleName() + "||" + schdId + "|" + triggerMethod + "| target is zero. job_status changed  " + "15");
        } else {
            this.statusChanger.updateScheduleTarget("43", schdId, "N", 0L, this.getClass().getSimpleName() + "||" + schdId + "|" + triggerMethod + "| target is zero. job_status changed  " + "43");
        }
    }

    public void updateSchdError(long sendId, long schdId, String errorMessage) {
        this.updateSchdError(sendId, schdId, null, errorMessage);
    }

    public void updateSchdError(long sendId, long schdId, String mqPriority, String errorMessage) {
        try {
            this.statusChanger.updateSchedule("41", schdId, "N", mqPriority, this.getClass().getSimpleName() + "|" + sendId + "|" + schdId + "|| has Error(" + errorMessage + "). SCHD_INFO job_status changed " + "41");
            this.statusChanger.updateTestInfo("41", schdId, this.getClass().getSimpleName() + "|" + sendId + "|" + schdId + "|| has Error(" + errorMessage + "). TEST_INFO job_status changed " + "41");
            this.statusChanger.updateResendInfo("41", schdId, this.getClass().getSimpleName() + "|" + sendId + "|" + schdId + "|| has Error(" + errorMessage + "). RESEND_INFO job_status changed " + "41");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("{}|{}|{}|Controller has Exception. {} : {}", new Object[]{"CT0501", sendId, schdId, this.getClass().getSimpleName(), e});
        }
    }

    public boolean updateSchdErrorAndLog(HashMap<String, Object> mapPINFO, String expectJobStatus) throws Exception {
        if (this.stringUtil.hasKey(mapPINFO, Column.ERROR_CODE)) {
            if (!this.statusChanger.isScheduleExpectJobstatus(Long.valueOf(String.valueOf(mapPINFO.get(Column.SCHD_ID))), expectJobStatus)) {
                return true;
            }
            log.error("{}|{}|{}|{}", new Object[]{String.valueOf(mapPINFO.get(Column.ERROR_CODE)), String.valueOf(mapPINFO.get(Column.SEND_ID)), String.valueOf(mapPINFO.get(Column.SCHD_ID)), String.valueOf(mapPINFO.get(Column.DESCRIPTION))});
            this.updateSchdError(Long.valueOf(String.valueOf(mapPINFO.get(Column.SEND_ID))), Long.valueOf(String.valueOf(mapPINFO.get(Column.SCHD_ID))), null, String.valueOf(mapPINFO.get(Column.DESCRIPTION)));
            return true;
        }
        return false;
    }

    public boolean updateSchdErrorAndLog(String errorCode, String description, int sendId, int schdId) throws Exception {
        log.error("{}|{}|{}|{}", new Object[]{errorCode, sendId, schdId, description});
        this.updateSchdError(sendId, schdId, null, description);
        return true;
    }
}

